SET talk OFF
*
*set up the string macros
DO string
*
* set up the variables which control indenting
STORE "                     " TO blanks
STORE 1 TO indent
STORE 3 TO indentamt
STORE 1 TO line
*
*set up the text data file to receive the program
USE text
DELETE ALL
PACK
*
* get the name of the program to be pretty printed
ACCEPT "What is the program's name? " TO program
*
*set up alternate file to contain the pretty version
SET ALTERNATE TO &program
SET ALTERNATE ON
*
*append the program into the text file
STORE program + ".PRG" TO program
APPEND FROM &program sdf
*
*process every line of the program
GOTO TOP
DO WHILE .not. eof
  *
  *if the current line isn 't empty, make it pretty
  IF len(trim(text)) > 1 .OR. trim(text) <> " " 
    *
    *remove any original indentation
    STORE trim(text) TO string
    DO ltrim
    STORE newstring TO string
    *
    * get the first word of the program, and capitalize it
    &firstchar
    DO word
    STORE!(newstring) TO newstring
    *
    DO CASE
        *if the line is a comment, make it into lower case
      CASE newstring = "*" 
        DO lower
        STORE newstring TO string
        *
        *if the line contains a quated string
      CASE '"' $ string
        *find out where the quotes are
        STORE @( '"' ,string) TO quote1
        STORE @( '"' ,$(string,quote1 + 1)) + quote1 TO quote2
        *if there are any characters after the second quote
        IF len(trim(string)) > quote2
          *store the capitalized part before the quote
          *+ the quoted string + the capitalized part
          *after the string back to the string
          STORE !($(string,1,quote1 -1)) +;
          $(string,quote1,quote2 - quote1 +1) +;
          !($(string,quote2 +1)) TO string
        ELSE
          *store the capitalized part before the quote
          *+ the quoted part back to the string
          STORE !($(string,1,quote1-1)) +;
          $(string,quote1,quote2 - quote1 + 1) TO string
        ENDIF len(trim(string)) > quote2 
        *
        *if it is a normal line just capitalize it
      OTHERWISE
        STORE !(string) TO string
    ENDCASE 
    *
    *print the line with indentation
    DO CASE
        *
        *if the first word is do
      CASE newstring = "DO" 
        *print the line
        ? str(line,3) + $(blanks,1,indent) + string
        * get the next word
        DO word
        * if the next string is while or case, indent the next line
        IF !(newstring) = "WHILE" .OR. !(newstring) = "CASE" 
          STORE indent + indentamt TO indent
        ENDIF !(newstring) = "WHILE" .OR. !(newstring) = "CASE"  
        *
        * if the first word is endcase, enddo, or endif
      CASE newstring = "ENDCASE" .OR. newstring = "ENDDO" .OR.;
        newstring = "ENDIF" 
        * reduce the indentation and then print the line
        STORE indent - indentamt TO indent
        ? str(line,3) + $(blanks,1,indent) + string
        *
        * if the first word is else
      CASE newstring = "ELSE" 
        STORE indent - indentamt TO indent
        * reduce the indentation and print the line
        ? str(line,3) + $(blanks,1,indent) + string
        STORE indent + indentamt TO indent
        *
        * if the first word is if
      CASE newstring = "IF" 
        *print the line and then indent the next line
        ? str(line,3) + $(blanks,1,indent) + string
        STORE indent +indentamt TO indent
        *
        *if it is any otherwise type of line, just print it
      OTHERWISE
        ? str(line,3) + $(blanks,1,indent) + string
    ENDCASE 
    *
    *if the line was empty jsut print the line number
  ELSE
    ? str(line,3)
  ENDIF len(trim(text)) > 1 .OR. trim(text) <> " 
  *
  *move to the next line
  STORE line +1 TO line
  SKIP
  *
ENDDO WHILE .not. eof 
*
*clean up
USE
RELEASE blanks, indent, indentamt,line, program, string, newstring;
quote1,quote2
SET ALTERNATE OFF
SET talk ON
****************************************************************
****************************************************************
****************************************************************
