SET talk OFF
ERASE
*set up the string macros
DO string
*
*get the file and fields to process
ACCEPT "File name " TO FILE
ACCEPT "Field name(s) " TO string
USE &FILE
*
*process each field name in turn
&firstchar
DO WHILE .not. &endstring
  *
  * go to the next field name
  DO word
  STORE newstring TO FIELD
  *
  *initialize the variables to be used for statistics
  STORE "len(trim(&field))" TO length
  STORE 0 TO blanks
  STORE 0 TO TOTAL
  STORE 0 TO records
  *
  * make the first record both maximum and minimum
  GOTO TOP
  STORE &length TO maximum
  STORE &length TO minimum
  *
  DO WHILE .not. eof
    *
    DO CASE
        * the current record is blank
      CASE &length = 1 .AND. &FIELD = " " 
        STORE blanks + 1 TO blanks
        *
        * the current record is the new maximum
      CASE &length > maximum
        STORE &length TO maximum
        *
        * the current record is the new minimum
      CASE &length < minimum
        STORE &length TO minimum
    ENDCASE 
    *
    * accumulate the total charactrs and records so far
    STORE TOTAL + &length TO TOTAL
    STORE records + 1 TO records
    *
    SKIP
  ENDDO WHILE .not. eof 
  *
  *print the results for the current record
  ?
  ? "Statistics for &field" 
  ?
  ? "Number of records " , records
  ? "Blank records     " , blanks
  ? "Field length      " , len(&FIELD)
  ? "Maximum field     " , maximum
  ? "Minimum field     " , minimum
  ? "Percent usage     " , (TOTAL/(len(&FIELD)*records))* 100.00
  *
ENDDO WHILE .not. &endstring 
*
* clean up
RELEASE FILE, FIELD, string,newstring,length,blanks, maximum,;
minimum, TOTAL, records
SET talk ON
****************************************************************
****************************************************************
****************************************************************
