* windows.prg
* Author:  David Kanter
* Date: Wed  03-30-88
*
* This is small series of programs that allow easy windowing in clipper
* It uses the PD file CLIPSCRL by Tim Shriver.  It is quick but not I hope
* too crude.  This is also placed in the public domain by the author.
*
* Any questions on the use contact:
* David Kanter
* D & P Consulting
* Phone: 301-358-5420
*
* functions and syntax
* w_draw(wtop_row,wtop_col,wbot_row,wbot_col,wcolor)
*       routine for defining and drawing the window
*
* w_up(#rows) - uses scrlup from clipscrl.obj
* w_down(#rows) - uses scrldown from clipscrl.obj
*       These 2 functions scroll the contents of the window
*
* w_fill(char) - fills the window with char (use " " to clear)
*
* w_row(row)
* w_col(col)
*        These 2 functions position text relatively within the window.
*
* w_erase - clears the window and puts back old screen
*
* General usage:  When you need a window (just one please) call these programs.
*    You must first declare the following public variables:
*    Public wtop_row, wtop_col, wbot_row, wbot_col, wcolor, c_attrib, w_temp
*      wtop_row and wtop_col are the top left corner of the window
*      wbot_row and wbot_col are the right bottom corner of the window
*      wcolor is the color for the window in quotes (e.g. "GR+/B")
*      c_attrib is wcolor translated to a DOS attribute (see the case statements)
*      w_temp is the screen before doing the windows to restore to.
*    No error checking is done in this version.  If you exceed the window
*    boundries so be it.  It is also your responsibility to restore your 
*    origional colors.  See the file winddemo.prg for programming consideration.

procedure w_draw
* defines and draws the window.  Saves prior screen in w_temp.
* Syntax: do w_draw with <trow>,<tcol>,<brow>,<bcol>,<color>
parameter trow,tcol,brow,bcol,mcolor
save screen to w_temp
wtop_row = trow
wtop_col = tcol
wbot_row = brow
wbot_col = bcol
wcolor = mcolor
set color to wcolor
*** create color attribute for clipscrl ***
w_fg = upper(left(wcolor,at("/",wcolor)-1))
w_br = upper(substr(wcolor,at("/",wcolor)+1))
x = 1
set exact on
do while x <= 2  && do this twice. once for backround and then forground
  if x = 1
    cc = "w_br"
  else
    cc = "w_fg"
  endif
  do case
    case &cc = "N"  && black
      cc = 0
    case &cc = "B"  && Blue
      cc = 1
    case &cc = "G"  && green
      cc = 2
    case &cc = "BG"  && cyan
      cc = 3
    case &cc = "R"   && red
      cc = 4
    case &cc = "RB" && magenta
      cc = 5
    case &cc = "GR" && brown
      cc = 6
    case &cc = "W"  && white
      cc = 7
    case &cc = "N+"  && gray
      cc = 8
    case &cc = "B+"  && lite blue
      cc = 9
    case &cc = "G+"  && lite green
      cc = 10
    case &cc = "BG+"  && lite cyan
      cc = 11
    case &cc = "R+"
      cc = 12
    case &cc = "RB+"
      cc = 13
    case &cc = "GR+" && yellow
      cc = 14
    case &cc = "W+"
      cc = 15
  endcase
  if x = 1
    c_attrib = cc * 16
  else
    c_attrib = c_attrib + cc
  endif
  x = x + 1
enddo
set exact off  && remember to reset this if you normally have exact on.
*** draw and clear the window area ***
@wtop_row,wtop_col to wbot_row,wbot_col double
w_fill(" ")
return

function w_fill
* fills the window with a character.  Use " " to clear the window.
* Syntax:  w_fill()
parameter fillchar
x = wtop_row + 1
wlen = wbot_col - wtop_col - 1
do while x < wbot_row
  @x,wtop_col+1 say repl(fillchar,wlen)
  x = x + 1
enddo
return(.t.)

function w_row
* provides for relative addressing within the window.
* Syntax: @ w_row(mrow), w_col(mcol) say text
* Notes:  If you call this with w_row(2) your text will be placed on the
*         second line in the window area.
parameters mrow
return (mrow + wtop_row)

function w_col
* provides for relative addressing within the window.
* Syntax: @ w_row(mrow), w_col(mcol) say text
* Notes:  If you call this with w_col(2) your text will be placed in the
*         second column in the window area.
parameters mcol
return (mcol + wtop_col)

function w_up
* Scrolls the contents of the window up X rows.
* Syntax:  w_up(rows)
* Notes:  Uses clipscrl.obj
* Syntax for clipscrl: SCRLUP (<expN1>,<expN2>,<expN3>,<expN4>,<expN5>,<expN6>)
parameter num_rows
scrlup(num_rows, wtop_row+1, wtop_col+1, wbot_row-1, wbot_col-1, c_attrib)
return .t.

function w_down
* Scrolls the contents of the window down x rows.
* Syntax:  w_down(rows)
* Notes:  see w_up function for details.
parameter num_rows
scrldown(num_rows, wtop_row+1, wtop_col+1, wbot_row-1, wbot_col-1, c_attrib)
return .t.

function w_erase
* Erases the window and restores the screen from w_temp
* Syntax:  w_erase()
restore screen from w_temp
return .t.


Procedure ctr
* Centers text on a user specified row
* Parameters MESS (in quotes), ROW where message will be displayed
* syntax: do ctr_text with mess, row
para mess, mrow
mess_len = len(mess)
mctr = (79 - mess_len) / 2
@mrow,mctr say mess
return

function w_lookup
* Performs lookups on databases.  This version used only 2 fields, the code and
* the meaning of the code.  The bottom row of the window is 20 and the help is
* on lines 21 to 23.
* Parameters: trow - top row of window
*             tcol - left column of the window
*             mcolor - color attribute of the window (e.g. w/b)
*             area - area where the lookup file is
*             getfld - the field in the lookup table to get
*             showfield - the field with the code description
* Syntax: mcode = w_lookup()
*
parameter trow,tcol,mcolor,area,getfld,showfld
store alias() to currarea  && save the origional area
select area                && select the lookup table
go bottom                  && get last record number
lastrec = recno()
go top                     && go top and get first record
firstrec = recno()
Ret_key = 13               && setup keys and other variables
HomeKey  = 1
EndKey   = 6
UpArrow  = 5
DnArrow  = 24
PgUp     = 18
PgDn     = 3
brow = 20
bcol = tcol + len(&getfld) + len(&showfld) + 3
do w_draw with trow,tcol,brow,bcol,mcolor  && call w_draw
w_height = brow - trow - 1
@21,0 to 23,79 double                      && draw help box
do ctr with "Press , , PgUp, PgDn, Home or End to move cursor.  Press Enter to select.",22
finished = .f.

do while .not. finished
  w_fill(" ")         && clear the box
  x = 1
  do while x <= w_height              && display one box of information
    @w_row(x),w_col(1) say &getfld+'  '+&showfld
    x = x + 1
    skip
    if eof()
      exit
    endif
  enddo
  sb = recno()
  skip -(x - 1)
  x = 1
  @w_row(1),w_col(1) get &getfld
  clear gets

  action = .t.          && get a key and react accordingly
  do while action
    junk = 0
    do while junk = 0
      junk = inkey()
    enddo
    do case
      case junk = dnarrow
        if recno() = lastrec
          ??chr(7)
        else
          x = x + 1
          if x > w_height   && went past window
            x = w_height
            @w_row(w_height),w_col(1) say &getfld
            skip
            sb = recno()
            w_up(1)
            @w_row(x),w_col(1) say &getfld+'  '+&showfld
          else
            @w_row(x - 1),w_col(1) say &getfld
            skip
          endif
          @w_row(x),w_col(1) get &getfld
          clear gets
        endif
      case junk = uparrow
        if recno() = firstrec
          ??chr(7)
        else
          x = x - 1
          if x < 1
            x = 1
            @w_row(1),w_col(1) say &getfld
            skip - 1
            sb = recno()
            w_down(1)
            @w_row(1),w_col(1) say &getfld+'  '+&showfld
          else
            @w_row(x + 1),w_col(1) say &getfld
            skip - 1
          endif
          @w_row(x),w_col(1) get &getfld
          clear gets
        endif
      case junk = pgdn
        goto sb
        exit
      case junk = pgup
        skip -x
        y = 1
        do while y < w_height  && skip back checking for bof
          skip -1
          if recno() = firstrec
            exit
          endif
          y = y + 1
        enddo
        exit
      case junk = homekey
        go top
        exit
      case junk = endkey
        go bottom
        skip
        y = 1
        do while y < w_height  && skip back checking for bof
          skip -1
          if recno() = firstrec
            exit
          endif
          y = y + 1
        enddo
        exit
      case junk = ret_key
        finished = .t.
        exit
      otherwise   && invalid key
        ??chr(7)
    endcase

  enddo

enddo
mcode = getfld
select &currarea                      && SWITCH BACK TO ORIGINAL WORK AREA
return(&mcode)
