name SETTIME
page 66,132
INCLUDE BINOBJ.MAC

.XLIST
comment $____________________________________________________________

          Set the DOS time of day clock.  Works semi-identically in
          Clipper, dBASE III Plus/IV, Quicksilver/dBXL, FoxBASE+/Pro

syntax:
LOAD settime                      && only in interpreted versions or QS
CALL settime WITH "13:01:01:01"   && set time to 1 hour, minute, second,
                                  && and second/100 past noon

You *should* be able to leave off minutes or seconds, or esp. hundredths of
seconds.  You can use any non-numeric delimiters, not just colons.

Returns: nothing.  You can use TIME() to find out if it worked, but any valid
time should be successful.

To assemble:
============

For a BIN routine:

MASM SETTIME /D__BIN__;
LINK SETTIME;
EXE2BIN SETTIME;
DEL SETTIME.EXE
DEL SETTIME.OBJ

For Clipper pre-Summer '87 or QS CCALL OBJ:

MASM SETTIME /D__CCALL__;
(then link with your application's object code as directed in the
 compiler documentation)

For Clipper Summer '87:

MASM SETTIME /D__SUMMER87__;
(then link with your application's object code as directed in the
 compiler documentation)

(as documented in INTERRUPT.LST:)
INT 21 - DOS - SET CURRENT TIME
        AH = 2Dh
        CH = hours
        CL = minutes
        DH = seconds
        DL = hundredths of seconds
Return: AL = 00h if no error
           = FFh if bad value sent to routine
Note: DOS 3.3 also sets CMOS clock

Copyright (c) 1990 R. Russell Freeland (Synergy Corp.)
Compuserve 76146,371
7-14-90

______________________________________________________________________$
.LIST
.LALL


StartSeg@ SETTIME_SEG

PUBLIC SETTIME

SETTIME PROC FAR

        jmp init

Copyright@ SETTIME

;-----------data area

init:
        IFNDEF __BIN__
             push    ds                 ; save some registers
             push    bp
             mov     bp,sp              ; if not a BIN routine, get the
             mov     bx,8[bp]           ; parameters in conventional "C"
             mov     ds,10[bp]          ; fashion, from the stack
        ENDIF
        mov     si,bx
        call    makeint
        mov     ch,dl
        add     si,3
        call    makeint
        mov     cl,dl
        add     si,3
        call    makeint
        mov     dh,dl
        add     si,3
        call    makeint
        mov     ah,2dh
        int     21h
        IFNDEF __BIN__
                pop     ds
                pop     bp
        ENDIF
        RET
SETTIME ENDP

MAKEINT PROC NEAR               ; makes ASCII int pointed to by DS:si
                                ; into integer (actually unsigned char) in DL
          push si
          push ax
          push cx
          push dx
          xor  ax,ax
          mov  ch,10
nextdigit:
          mov  cl,byte ptr DS:[si]
          cmp  cl,'0'
          jl   intdone
          cmp  cl,'9'
          ja   intdone
          sub  cl,'0'
          mul  ch
          add  al,cl
          inc  si
          jmp  nextdigit
intdone:
          pop  dx                           ;get back dh
          mov  dl,al
          pop  cx
          pop  ax
          pop  si

          RET
MAKEINT ENDP

SETTIME_SEG ENDS
EndFile@ SETTIME

