name SETDATE
page 66,132
INCLUDE BINOBJ.MAC

.XLIST
comment $____________________________________________________________

          Set the DOS date.  Works semi-identically in
          Clipper, dBASE III Plus/IV, Quicksilver/dBXL, FoxBASE+/Pro

syntax:
LOAD setdate                      && only in interpreted versions or QS
CALL setdate WITH "01/01/1981"    && sets date to what you see, but cannot
                                  && set date before 01/01/1980 due to a
                                  && limitation of the DOS call SET DATE

You can use any non-numeric delimiters, not just slashes.  The date must,
however, be in the format shown above.

Returns: nothing.  You can use DATE() to find out if it worked, but any valid
date past 1/1/80 should be successful.

To assemble:
============

For a BIN routine:

MASM SETDATE /D__BIN__;
LINK SETDATE;
EXE2BIN SETDATE;
DEL SETDATE.EXE
DEL SETDATE.OBJ

For Clipper pre-Summer '87 or QS CCALL OBJ:

MASM SETDATE /D__CCALL__;
(then link with your application's object code as directed in the
 compiler documentation)

For Clipper Summer '87:

MASM SETDATE /D__SUMMER87__;
(then link with your application's object code as directed in the
 compiler documentation)


Copyright (c) 1990 R. Russell Freeland (Synergy Corp.)
Compuserve 76146,371
7-14-90


To assemble:
============

For a BIN routine:

MASM SETDATE /D__BIN__;
LINK SETDATE;
EXE2BIN SETDATE;
DEL SETDATE.EXE
DEL SETDATE.OBJ

For Clipper pre-Summer '87 or QS CCALL OBJ:

MASM SETDATE /D__CCALL__;
(then link with your application's object code as directed in the
 compiler documentation)

For Clipper Summer '87:

MASM SETDATE /D__SUMMER87__;
(then link with your application's object code as directed in the
 compiler documentation)

(as documented in INTERRUPT.LST:)
INT 21 - DOS - SET CURRENT DATE
	AH = 2Bh
	DL = day
	DH = month
	CX = year
Return: AL = 00h if no error
	   = FFh if bad value sent to routine
Note: DOS 3.3 also sets CMOS clock


Copyright (c) 1990 R. Russell Freeland (Synergy Corp.)
Compuserve 76146,371
7-14-90

______________________________________________________________________$
.LIST
.LALL

StartSeg@ SETDATE_SEG

PUBLIC SETDATE

SETDATE PROC FAR

        jmp init

Copyright@ SETDATE
savebyte        db      ?
;-----------data area

init:
        IFNDEF __BIN__
             push    ds                 ; save some registers
             push    bp
             mov     bp,sp              ; if not a BIN routine, get the
             mov     bx,8[bp]           ; parameters in conventional "C"
             mov     ds,10[bp]          ; fashion, from the stack
        mov     al,db_param+8           ; save first byte of century year
        mov     savebyte,al
        mov     db_param+8,0            ; make it null to get century
        mov     si,bx                   ; move pointer to century into si
        add     si,6
        call    makeint
        mov     al,dl                   ; setup to multiply * 100
        xor     ah,ah
        mov     cl,100
        mul     cl
        mov     cx,ax                   ; now cx=century*100
        mov     al,savebyte             ; move century year first byte back
        mov     db_param+8,al
        add     si,2                    ; point at it
        call    makeint
        add     cl,dl                   ; add century year to century in cx
        mov     si,bx                   ; point si at ASCII month
        call    makeint
        mov     dh,dl                   ; store month in dh
        add     si,3                    ; point at day
        call    makeint
        mov     ah,2bh
        int     21h
        IFNDEF __BIN__
                pop     ds
                pop     bp
        ENDIF
        RET
SETDATE ENDP

MAKEINT PROC NEAR                       ; makes ASCII int pointed to by DS:si
                                        ; into integer (actually uns char) in DL
          push si
          push ax
          push cx
          push dx
          xor  ax,ax
          mov  ch,10
nextdigit:
          mov  cl,byte ptr DS:[si]
          cmp  cl,'0'
          jl   intdone
          cmp  cl,'9'
          ja   intdone
          sub  cl,'0'
          mul  ch
          add  al,cl
          inc  si
          jmp  nextdigit
intdone:
          pop  dx                           ;get back dh
          mov  dl,al
          pop  cx
          pop  ax
          pop  si

          RET
MAKEINT ENDP

SETDATE_SEG ENDS
EndFile@ SETDATE

