#include "c:\clipper\nandef.h"
#include "c:\clipper\extend.h"

CLIPPER date2army()
/* Converts CLIPPER date to ARMY format, DDMMMYY */
{
	char mdate[9]; /* input string YYYYMMDD */
	char mmon[3];
	int cnt;
	int imon;
	char cdate[10]; /* return string DD-MMM-YY */
	char nulstr[9];
	char monames[37];
	
	strcpy(monames,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
	
	strcpy(mdate,_pards(1)); /* Load mdate with DTOS input string */

	strcpy(nulstr,"        ");
	if (strcmp(mdate,nulstr) == 0)
		{
		strcpy(cdate,"  -   -  ");
		}
	else
		{
		/* Load hyphens into positions 3 and 7 of cdate */
		cdate[2] = 45;
		cdate[6] = 45;
	
		/* Transfer the 2 character DAY verbatim */
		for(cnt = 0; cnt < 2; ++cnt)
		{
			cdate[cnt] = mdate[cnt + 6];
		}
	
		for(cnt = 0; cnt < 2; ++cnt)
		{
			mmon[cnt] = mdate[cnt + 4];
		}		/* mmon now contains the 2 digits of the month */
		mmon[2] = 0L;
		imon = atoi(mmon);
				/* imon is an int cooresponding to the month number */

  		for(cnt = 0; cnt < 3; ++cnt)
		{
			cdate[cnt + 3] = monames[(imon - 1) * 3 + cnt]; 
		}	  	/* cmon now contains the 3 character month abbrev. */
	
		/* load the cyear string with pos 2-3 of mdate (dropping century) */
  		for(cnt = 0; cnt < 4; ++cnt)
		{
			cdate[cnt + 7] = mdate[cnt + 2];
		}
		cdate[9] = 0L;
		}
	_retc(cdate);
}

/********************************************************************/

CLIPPER army2date()
/* Converts ARMY date to CLIPPER format, YYYYMMDD */
{
	char mdate[10]; /* input string DD-MMM-YY */
	char mmon[4];
	char cmon[3];
	char tempmo[4];
	int cnt;
	int cnt1;
	int imon;
	char cdate[9]; /* return string YYYYMMDD */
	
	char monames[37];
	strcpy(monames,"JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC");
	
	strcpy(mdate,_parc(1)); /* Load mdate with armydt input string */
	
	/* Load the first 2 characters of return string with '19' */
	
	cdate[0] = '1';
	cdate[1] = '9';
	
	/* Transfer the 2 character YEAR verbatim */
	for(cnt = 0; cnt < 2; ++cnt)
		cdate[cnt + 2] = mdate[cnt + 7];
	
	/* load MMON with the 3 character month id */
	
	for(cnt = 0; cnt < 3; ++cnt)
		mmon[cnt] = mdate[cnt + 3];
	mmon[3] = 0L;
	
	/* Search the monames string for a match */
	
	for(cnt = 0; cnt < 36; cnt += 3)
	{
		for (cnt1 = 0; cnt1 < 3; ++cnt1)
			tempmo[cnt1] = monames[cnt + cnt1];
		
		tempmo[3] = 0L;
		if (strcmp(tempmo,mmon) == 0)
			break;
	}
	if ( cnt > 35)
		imon = 0;
	else
		imon = cnt / 3 + 1;
	
	itoa(imon,cmon,10);
	if (imon < 10)
	{
		cdate[4] = '0';
		cdate[5] = cmon[0];
	}
	else
		for(cnt = 0; cnt < 3; ++cnt)
			cdate[cnt + 4] = cmon[cnt]; 
	
	/* load the cdate string day from pos 0-1 */
  	for(cnt = 0; cnt < 3; ++cnt)
	{
		cdate[cnt + 6] = mdate[cnt];
	}
	cdate[8] = 0L;
	_retds(cdate);
}
