* DATASCAN.PRG   && Code in dBASE III PLUS format.

SET TALK OFF
SET ECHO OFF
SET SCOREBOARD OFF
SET STATUS OFF
SET SAFETY OFF
SET BELL OFF
SET CONFIRM ON
SET DELETED ON
SET EXACT OFF
SET ESCAPE OFF
PRIVATE OPTION

SET PROCEDURE TO DATASCAN

* ---define key values.
UP = 5
DOWN = 24
BKSP = 127  && 8 for most compilers.
ENTER = 13
ESC = 27

USE ADDRESS INDEX PERSON

* Display and select from menu.
SET COLOR TO W/N
CLEAR
SET COLOR TO W+/B
@ 8, 8 CLEAR TO 16, 32
@ 8, 8 TO 16, 32 DOUBLE
@ 8, 10 SAY " Menu "
@ 10, 10 SAY "1. Data View/Search"
@ 11, 10 SAY "2. New Data entry"
@ 12, 10 SAY "3. Data Editing"
@ 14, 10 SAY "4. Quit Program"
@ 18, 8 CLEAR TO 20, 32
@ 18, 8 TO 20, 32 DOUBLE
@ 19, 10 SAY "Enter choice:"
OPTION = " "
DO WHILE OPTION <> "4"
  OPTION = " "
  SET COLOR TO , W+/B
  SET CONFIRM OFF
  DO WHILE .NOT. (OPTION >= "1" .AND. OPTION <= "4")
    @ 19, 24 GET OPTION
    READ
  ENDDO
  SET CONFIRM ON
  DO CASE
    CASE OPTION = "1"
      GO TOP
      DO DATAVIEW
    CASE OPTION = "2"
    CASE OPTION = "3"
  ENDCASE
ENDDO
SET COLOR TO W/N
CLEAR
SET PROCEDURE TO
RETURN

PROCEDURE DATAVIEW  && View and search for data.
PRIVATE RECNO, KEY
* Display boxes.
SET COLOR TO N/BG
@ 7, 35 CLEAR TO 12, 65
@ 7, 35 TO 12, 65
SET COLOR TO N/RB
@ 14, 35 CLEAR TO 16, 65
@ 14, 35 TO 16, 65
ROW = 15
COL = 38
FIND_DATA = ""
DO WHILE .T.
  SET COLOR TO N/BG
  @ 8, 38 SAY PERSON
  @ 9, 38 SAY STREET
  @ 10, 38 SAY CITY
  @ 11, 38 SAY PHONE
  @ ROW, COL SAY "" && Position cursor to locater.
  KEY = 0
  DO GET_KEY WITH KEY
  * ---user exits.
  IF KEY = ESC
    EXIT
  ENDIF
  * ---user presses up or down arrow.
  IF KEY = UP .OR. KEY = DOWN
    IF KEY = DOWN  && Down arrow.
      SKIP
      IF EOF()
        ?? CHR(7)
        GO BOTTOM
      ENDIF
    ELSE             && Up arrow.
      SKIP -1
      IF BOF()
        ?? CHR(7)
        GO TOP
      ENDIF
    ENDIF
  ENDIF
  * ---user edits search data.
  IF KEY > 32 .AND. KEY <= 123 .OR. ;
  KEY = BKSP .OR. KEY = ENTER
    DO CASE
    CASE KEY = BKSP         && Backspace
      DO BACKSPAC
    CASE KEY = ENTER        && Enter
      FIND_DATA = ""
      COL = 38
      SET COLOR TO N/RB
      @ ROW, 36 CLEAR TO ROW, 64
      @ ROW, 38 SAY ""
    OTHERWISE
      SET COLOR TO W+/RB
      @ ROW, COL SAY CHR(KEY)
      IF KEY > 96
        KEY = KEY - 32
      ENDIF
      COL = COL()
      FIND_DATA = FIND_DATA + CHR(KEY)
    ENDCASE
    IF LEN(FIND_DATA) > 0 && If find_data not empty
      RECNO = RECNO()  && Save current rec number.
      SEEK FIND_DATA
      IF .NOT. FOUND()
        ?? CHR(7)
        DO BACKSPAC
        GO RECNO  && Not found; return to old recno.
      ENDIF
    ENDIF
  ENDIF
ENDDO
SET COLOR TO W/N
@ 7, 35 CLEAR TO 16, 65
RETURN


PROCEDURE BACKSPAC   && Procedure for Backspace.

IF LEN(FIND_DATA) > 0
  FIND_DATA = LEFT(FIND_DATA, LEN(FIND_DATA)-1)
  SET COLOR TO W+/RB
  @ ROW, COL - 1 SAY " "
  @ ROW, COL - 1 SAY ""
  COL = COL()
ELSE
   ?? CHR(7)
ENDIF
RETURN


PROCEDURE GET_KEY   && Procedure records keypress.
PARAMETER KEY_CODE

KEY_CODE = 0
DO WHILE KEY_CODE = 0
  KEY_CODE = INKEY()
ENDDO
RETURN

* end of DATASCAN.PRG
