
\\ cString is a field with a length of (2+(nLeft+nRight)) * 10

LOCAL nTop := 5, nLeft := 10, nBottom := 10, nRight := 70
PRIVATE nMaxline := 10

REPLACE cString WITH MEMOEDIT(cString, nTop, nLeft, nBottom, nRight,;
                              .T., "MEMOFUNC")

LETS_SEE_IT(cString, 60)      // cString is the VAR/FIELD with the 
                              // MEMOEDIT string. 60 is the length
                              // of the string. 


*************************************************************************
*FUNCTION TO CONTROL THE MEMOEDIT/READ                                  *
*************************************************************************
FUNCTION MEMOFUNC(mode, line, col)
LOCAL nRet_val, cSave_line := ""

IF MODE = 3              // MODE = 3, START UP
   nRet_val := 0
ELSEIF MODE = 2          // MEMO = 2, MEMO CHANGED
   IF lastkey() = 27     // ESC AND CHANGED, ASK DO YOU WANT TO ABORT
      cSave_line := savescreen(0,0,1,79)
      @ 0, 60 SAY "Abort edit (Y/N)?"
      INKEY(0)
      IF(CHR(LASTKEY())$"Yy", nRet_val := 0, nRet_val := 32)
      RESTSCREEN(0,0,1,79,cSave_line)
   ELSEIF LASTKEY() = -9
      nRet_val := 23     // SAVE IF F-10 AND MEMO CHANGED
   ELSE
      nRet_val := 0
   ENDIF
ELSEIF MODE = 1          // MODE = 1, MEMO NOT CHANGED
   IF lastkey() = 27     // ESC AND CHANGED NOTHING, ASK DO YOU WANT TO ABORT
      cSave_line := savescreen(0,0,1,79)
      @ 0, 60 SAY "Abort edit (Y/N)?"
      INKEY(0)
      IF(CHR(LASTKEY())$"Yy", nRet_val := 0, nRet_val := 32)
      RESTSCREEN(0,0,1,79,cSave_line)
   ELSEIF LASTKEY() = -9
      nRet_val := 23     // SAVE IF F-10 AND MEMO NOT CHANGED
   ELSE
      nRet_val := 0
   ENDIF
ELSE                     // MODE = 0, DEFAULT ACTION, DO NOTHING
   nRet_val := 0
ENDIF

* WARNING WHEN nMaxline IS REACHED DEFINED IN PRIVATE VAR

if line = nMaxline
   @ 24, 0 SAY "max line reached.   "
elseif line > nMaxline
   BLINK(24,0,"this line not saved!")
else
   @ 24, 0 clear to 24, 79
endif
return(nRet_val) 

*********************************************************************
*   FUNCTION LETS_SEE_IT TO OUTPUT MEMO INFORMATION IN LINE FORM    *
*********************************************************************
FUNCTION LETS_SEE_IT(cVar, nLen)
LOCAL nI := 0, nLines := 0, mStrgs := {}
nLines := MLCOUNT(cVar, nLen)       //  HOW MANY LINES IN THE MEMO
for nI = 1 to nLines                //  PUT THE LINES IN AN ARRAY
   AADD(mStrgs, MEMOLINE(cVar, nLen, nI))
NEXT
*SPLASH THE ARRAY TO THE CURRENT DEVICE, SHOW ONLY ELEMENTS WITH DATA
*AEVAL(mStrgs, {|element| IF(EMPTY(ELEMENT),QQOUT(),QOUT(ELEMENT))}) //WITH DATA
AEVAL(mStrgs, {|element| QOUT(ELEMENT)})  // FOR ALL ELEMENTS
RETURN NIL

