/*	BIGARRAY.C

   Example of using C routines to simulate arrays in Clipper.

	This technique uses less memory space and is faster than the Clipper
	method.  There is no 14 byte per array member overhead.  There is
	also no garbage collection required.
		
	You must, of course, have Microsoft C version 5.x and
	know how to use it and the linker.

	In the following example there are 3 facts about 5000 items.
		
		The first, a character string, perhaps a name with a maximum length
		of 30 (1 for the null).

		The second is an integer value, perhaps an age.

		The third is a double precision floating point number, perhaps net worth.


	Each variable has 2 functions, a SET function and a GET function.

	In your Clipper application, you need a name, age and net worth.  These
	are called NAME, AGE and NET_WORTH.  NAME is character while the others
	are numeric.  The following example is silly because you would use
	dBASE files.  It could be used for any type of in memory tables.

	The function names of 'get_str' etc. should really be 'get_name' etc.
	Please forgive me for capitalizing the variables in dBASE.  I started
	doing years ago with dBASE II and can't stop.  I do however try to
	stick with the C convention of lowercase for everything except #defines.

	The Clipper program is called TEST.PRG.

	The C routine BIGARRAY.C is compiled with:

		cl /c /AL /Zl /Oalt /FPa /Gs bigarray.c

	The Clipper routine TEST.PRG is compiled with:
		
		clipper test

	The link (in this case Microsoft Link):

		link test bigarray,test,,clipper extend \msc\lib\llibce

		(Be sure to include any paths required)

	EXEPACK reduced the size of the TEST.EXE fro, 212K to 164K.  It comes
	with Microsoft C 5.x
			
	There are, of course, various safty features that you should build in.
	One is check that when you get a value that it has been set.  This
	could be done by loading one field with an unused value (like -1) and
	checking for it before retrieving the other fields.  Checking the
	range of the index is another good idea.

*/

#include <nandef.h>
#include <extend.h>

#define MAXSIZE 5000		 		/* Storage could be dynamically allocated */
#define MAXSTR  31		 		/* but is static here for simplicity		*/

char huge str_var[MAXSIZE][MAXSTR];	 /* 'huge' is used to exceed 64k	*/
int int_var[MAXSIZE];
double float_var[MAXSIZE];

CLIPPER set_int(void);										/* Store integer in array */
CLIPPER get_int(void);										/* Get integer from array */
CLIPPER set_dbl(void);										/* Store double in array */
CLIPPER get_dbl(void);										/* Get double from array */
CLIPPER set_str(void);										/* Store string in array */
CLIPPER get_str(void);										/* Get string from array */

/***************************************************************************/
CLIPPER set_int(void)									/* Store integer in array */
{
	int_var[_parni(1) - 1] = _parni(2);
}

/***************************************************************************/
CLIPPER get_int(void)				 					/* Get integer from array */
{
	_retni(int_var[_parni(1) - 1]);
	return;
}

/***************************************************************************/
CLIPPER set_dbl(void)									/* Store double in array */
{
	float_var[_parni(1) - 1] = _parnd(2);
}

/***************************************************************************/
CLIPPER get_dbl(void)									/* Get double from array */
{
	_retnd(float_var[_parni(1) - 1]);
	return;
}

/***************************************************************************/
CLIPPER set_str(void)									/* Store string in array */
{
	strcpy(str_var[_parni(1) - 1],_parc(2));
}


/***************************************************************************/
CLIPPER get_str(void)									/* Get string from array */
{
	_retc(str_var[_parni(1) - 1]);
	return;
}
/***************************************************************************/

