/*Ŀ
 ݳ                                                                      
 ݳ Program Name: BUILD.PRG         Copyright: Gallagher Computing Corp. 
 ݳ     Language: Clipper 5.2                                            
 ݳ       Author: Kevin S Gallagher                                      
 ݳ                                                                      
 Ĵ
 ݳ Comments:                                                            
 ݳ This utility is a remake of one that i created sometime ago. In this 
 ݳ version I'am playing with TinitFile class (c) RUNsoft, created by    
 ݳ Antonio Linares.                                                     
 ݳ                                                                      
 ݳ There may be sections of code that may appear to need more safety    
 ݳ features/error checking, but we are all smart enough (i hope) to not 
 ݳ need them - feel free to add um if so desired..                      
 Ĵ
 ݳ History:                                                             
 ݳ 06/93 - recoded for trying out TiniFile Class (c)                    
 
            */

#include "init.h"

static oIni, lFlag :=.t., xIniFile := "PINIT.INI"

/*
* function: main
*  purpose: decides which operation to carry out
* comments:
*/
function main( cParm )
    do case
        case cParm == nil
            if !lFlag
                if !EditInit()
                    abortProg(1)
                endif
            endif
            if alert("BACKUP;"+GET_TITLE()+";FILES",{" Yes ", " No "}) == 1
                DoBackups()
            else
                abortProg()
            endif
        case upper(cParm) == "/E"
            // edit init file
            EditInit()
        case upper(cParm) == "/?" .or. upper(cParm) == "/H"
            // show help on utility - tweak if so desired
            alert("OPTIONS;"+"/E EDIT INIT FILE;/H or /? THIS SCREEN")
    endcase
    CLOSE_INIT_FILE()
return nil

/*
* function: ListAsArray( <cList> [, <cDelimiter>] ) --> array
*  purpose: transforms a string into an array
* comments: by default the string is parsed by searching for commas unless
*         : a delimiter is supplied to override the comma ie., "-/;" etc.
*/
function ListAsArray( cList, cDelimiter )
    local nPos, aList := {}
    if cDelimiter = NIL
        cDelimiter := ","
    endif
    while (nPos := at(cDelimiter, cList)) != 0
        aadd(aList, substr(cList, 1, nPos - 1))
        cList := substr(cList, nPos + 1)
    enddo
    aadd(aList, cList)
return aList

/*
* function: BuildInit( <initialized object> )  --> nil
*  purpose: Creates a init file if it does not exit
* comments: Must call tinitfile() prior to calling this function
*/
function BuildIni( oIni )
    oIni:Set(  MAIN_TITLE    ,  "Project Undefined" )
    oIni:Set(  LIST_FILE     ,  ""                  )
    oIni:Set(  ZIP_FILE      ,  ""                  )
    oIni:Set(  EXT_LIST      ,  MyLocalList         )
    oIni:Set(  OBJ_LIST      ,  ""                  )
    oIni:Set(  LIB_LIST      ,  ""                  )
    oIni:Set(  ZIP_NAME      ,  "PKZIP"             )
    oIni:Set(  UNZIP_FILE    ,  "PKUNZIP"           )
    oIni:Set(  COMMENT_FILE  ,  "COMMENTS.TXT"      )

    WRITE_TO_INIT() 
return nil

/*
* function: EditInit
*  purpose: Allows a user to edit init under program control
* comments: This is not really needed unless the user is not be to trusted
*         : at the DOS level to open/edit the init file. Also note that the
*         : gets have thier colors assigned in a for-next loop, this was
*         : done so that all the code is within the 80 columns of my editor.
*         : The dispbegin()/dispend() makes the painting of the gets not to
*         : be shown during the redisplaying process!
*         : Note - I really cheated on the shadow effect also
*/
static function EditInit
    local SaveFullScreen(),oldcolor :=setcolor("w+/rb"),nCount :=len(aPic_)
    local getlist as arrays
    local i as ints
    local cTitle, cListFile, cZipFile, cExtList, cObjs as chars
    local cLibs, cZip, cUnZip,cComments  as chars
    local aArr_ := ReadInitFile(), lFlag := .t.

    cTitle      :=  padr( aArr_[1] ,  60 )
    cListFile   :=  padr( aArr_[2] ,  12 )
    cZipFile    :=  padr( aArr_[3] ,  12 )
    cExtList    :=  padr( aArr_[4] ,  70 )
    cObjs       :=  padr( aArr_[5] , 200 )
    cLibs       :=  padr( aArr_[6] , 200 )
    cZip        :=  padr( aArr_[7] ,  12 )
    cUnZip      :=  padr( aArr_[8] ,  12 )
    cComments   :=  padr( aArr_[9] ,  12 )

    DISPBEGIN()

    dispbox(0,0,maxrow(),maxcol(),""  ,"b+/b" )
    dispbox(3,2,15,maxcol()-1,    ""  ,"n+/n" )
    dispbox(2,1,14,maxcol()-3,     B_SINGLE+" ","w+/rb")

    @0,0 say padc("Editing initialization file",80) color "n/bg"

    @ 3,4 say "  Title for program:"
    @ 4,4 say "        PKlist file:"
    @ 5,4 say "         PKzip file:"
    @ 6,4 say "        Local Files:"
    @ 7,4 say "     Remote objects:"
    @ 8,4 say "   Remote libraries:"
    @ 9,4 say "  Name of Pkzip.exe:"
    @10,4 say "Name of Pkunzip.exe:" 
    @11,4 say "  Comment file name:"

    @ 3,26 get  cTitle     picture  aPic_[1]
    @ 4,26 get  cListFile  picture  aPic_[2] valid Parsename(cListFile)
    @ 5,26 get  cZipFile   picture  aPic_[3] valid Parsename(cZipFile)
    @ 6,26 get  cExtList   picture  aPic_[4] valid !empty(cExtList)
    @ 7,26 get  cObjs      picture  aPic_[5]
    @ 8,26 get  cLibs      picture  aPic_[6]
    @ 9,26 get  cZip       picture  aPic_[7] valid !empty(cZip)
    @10,26 get  cUnZip     picture  aPic_[8] valid !empty(cUnZip)
    @11,26 get  cComments  picture  aPic_[9] valid !empty(cComments)

    for i := 1 to nCount
        getlist[i]:colorSpec := Get_Colors
        getlist[i]:display()
    next

    DISPEND()

    if KSGREAD( 2 )
        oIni:Set(  MAIN_TITLE    , alltrim( cTitle    ) )
        oIni:Set(  LIST_FILE     , alltrim( cListFile ) )
        oIni:Set(  ZIP_FILE      , alltrim( cZipFile  ) )
        oIni:Set(  EXT_LIST      , alltrim( cExtList  ) )
        oIni:Set(  OBJ_LIST      , alltrim( cObjs     ) )
        oIni:Set(  LIB_LIST      , alltrim( cLibs     ) )
        oIni:Set(  ZIP_NAME      , alltrim( cZip      ) )
        oIni:Set(  UNZIP_FILE    , alltrim( cUnZip    ) )
        oIni:Set(  COMMENT_FILE  , alltrim( cComments ) )
        WRITE_TO_INIT() 
    else
        alert("ABORTING SAVES")
        lFlag := .f.
    endif

    setcolor(oldcolor)
    RestFullScreen()
return lFlag

function Parsename( cString )
    local lRetVal := .F., cMsg := ""
    do case
        case empty( cString )
            cMsg := "CAN NOT BE LEFT EMPTY"
        case at(".",cString) == 0
            cMsg := "NO PERIOD ENTERED"
        case at(".",cString) >= 9
            cMsg := "BASE FILENAME GREATER THAN 8 CHARACTERS"
        otherwise
            lRetVal := .T.
    endcase

    if !lRetVal
        tone(100,1);tone(70,1);tone(100,1)
        alert( cMsg, { " ERROR " } )
    endif
return lRetVal

/*
* function: ReadInitFile() --> 
*  purpose: used to allow program to read in values in the disk init file
* comments: returns aVars_[ nflag ] or entire array
*/
function ReadInitFile(nFlag)
    local aVars_ :=               ;
    { oIni:cGet( MAIN_TITLE    ) ,;
      oIni:cGet( LIST_FILE     ) ,;
      oIni:cGet( ZIP_FILE      ) ,;
      oIni:cGet( EXT_LIST      ) ,;
      oIni:cGet( OBJ_LIST      ) ,;
      oIni:cGet( LIB_LIST      ) ,;
      oIni:cGet( ZIP_NAME      ) ,;
      oIni:cGet( UNZIP_FILE    ) ,;
      oIni:cGet( COMMENT_FILE  )  ;
    }

    if valtype(nFlag) == "N"
        return aVars_[nFlag]
    endif
return aVars_

function abortProg( nDelete )
    CLOSE_INIT_FILE()
    if valtype( nDelete ) == "N"
        ferase(xIniFile)
    endif
    quit
return nil

/*
* function: IsInitHere
*  purpose: check to see if there is a init file, and creates one if not
* comments: [INIT] function is undocumented, and works in Clipper 5.2/5.1
*/
init procedure IsInitHere
    set(_SET_SCOREBOARD,.F.)

    OPEN_INIT_FILE()

    if !file(xIniFile)
        lFlag := .f.
        BuildIni( oIni )
    endif
return 

announce rddsys
init procedure rddinit()
    // no rdd please
return

exit procedure SoLong
    if errorlevel() <> 0
        inkey(0)
    endif
    setcolor("w/n")
    cls
return
