*  Function Ŀ
*   Description: Decimal to Microsoft Basic Format                          
*        Author: George D. Barnabic                                         
*  Date created: 03-3-93                                                    
*  Time created: 10:51:12pm                                                 
*     Copyright: George Barnabic                                            
* Ĵ
*      Function: DtoMBF()                                                   
*                                                                           
*     Arguments: nDecimal - the number to convert                           
*                lSingle  - pass .t. if single .f. if double prec.          
*                                                                           
*  Return Value: cMBF - a 4 or 8 byte string representing the binary number 
*                       for storage to a basic data file                    
* 
* 04/17/93 - Modified by John Wright to fix minor problem with decimals.
*            Original lines are commented as "***" to show old code.
*            This function is VERY slow when converting large numbers.

function DtoMBF(nDecimal, lSingle)

local cBinary := ''
local i
local cBSub := ''
local nInt
local nDec
local nTempDec
local lAddZero
local cBinDec := ''
local cIntDec := ''
local h
local lNeg
local cExp
local nLength
local cMBF

//----- default to double precision
if valtype(lSingle) != 'L'
        lSingle := .f.
endif
if lSingle
        nLength := 3
else
        nLength := 7
endif


if nDecimal == 0
  cMBF := replicate(chr(0),nLength + 1)
else

  //----- is number negative?
  lNeg := ( nDecimal <> abs(nDecimal) )

  //----- make it positive
  nDecimal := abs(nDecimal)

  *** //----- make it positive
  *** if (lNeg := nDecimal < 0)
  ***   nDecimal := abs(nDecimal)
  *** endif

  //----- split it up to Int and Decimal
  nDec := nDecimal - (nInt := int(nDecimal))

  //----- convert int to binary string
  if nInt > 0
    cIntDec := '0'
    for i := 1 to nInt
      h := len(cIntDec)
      do while .t.
        if substr(cIntDec, h,1) == '0'
          cIntDec := stuff(cIntDec, h,1,'1')
          exit
        else
          cIntDec := stuff(cIntDec, h,1,'0')
          if --h == 0
            cIntDec := '1' + cIntDec
            exit
          endif
        endif
      enddo
    next
  endif

  //----- convert the decimal part to binary string
  i := -1
  //----- keep adding 0 and 1's until the remainder is 0 or the length
  //----- of the trimed string is an 8 multiple of 3 or 7
  do while nDec != 0 .and.;
    len(stuff(cBinDec,1,at('1',cBinDec),'')) < (8*(nLength))
    lAddZero := (nTempDec := nDec - 2^i--) < 0
    if lAddZero
      cBinDec += '0'
    else
      nDec := nTempDec
      cBinDec += '1'
    endif
  enddo

  //----- find out if we have to add or sub from bias
  if len(cIntDec) != 0
    cExp := chr( 128 + len(cIntDec) )
  else
    *** cExp := chr(128 - at('1',cBinDec) - 1)
    cExp := chr(128 - ( at('1',cBinDec) - 1) )
  endif

  cBinary := cIntDec + cBinDec

  //----- strip off the leading zeros (if cIntDec is '')
  cBinary := substr(cBinary,at('1',cBinary))

  //----- set the sign bit
  cBinary := iif(lNeg,cBinary, stuff(cBinary,1,1,'0'))

  //----- pad the length with 0's
  cBinary := padr(cBinary,8*nLength,'0')

  i := 1
  cMBF := ''
  do while len(cMBF) < nLength
    *** cMBF := chr(Bin2Dec(substr(cBinary,i,8)+'B')) + cMBF // ProClip
    cMBF := chr(Bin2Dec(substr(cBinary,i,8))) + cMBF
    i += 8
  enddo
  cMBF := cMBF + cExp
  *** altd()
endif

return(cMBF)
*---------- end of func DtoMBF() -----------------------
