*******************************************************************************
*  CV_READ - User Defined Functions that provide the ability to read BASIC    *
*            numbers stored by the MKI$/MKS$/MKD$ functions.                  *
*                                                                             *
*  by John Wright (c) 1989-1994 - All rights reserved.                        *
*=============================================================================*
*                                                                             *
*  03/13/94 - Added CLIP2IEEE from from Ted Means to write numbers            *
*             in IEEE format.  Someone asked for this function.               *
*             Modified CVI & MKI functions to handle negative numbers.        *
*             Recompiled library with Clipper 5.2 instead of 5.01.            *
*             Added QTEST.BAS and QTEST.PRG to test QBASIC IEEE numbers.      *
*             Updated TEST.PRG to call QBASIC with /MBF paramater in          *
*             case someone does not have BASICA or GW-BASIC for testing.      *
*                                                                             *
*  08/08/93 - Added IEEE2CLIP from from Ted Means to read numbers             *
*             created by QBASIC programs.                                     *
*                                                                             *
*  04/17/93 - Fixed the problems with saving decimal values thanks            *
*             to code provided by George Barnabic in DtoMBF().                *
*             George tackled the conversion in a different way and            *
*             I was able to learn some new things from his code.              *
*                                                                             *
*  03/28/93 - Converted to Clipper 5 and added internal functions             *
*             to handle decimal to binary conversions.                        *
*             Modified MKS & MKD functions to handle decimals.                *
*             (There is a problem with saving decimal only values)            *
*                                                                             *
*  01/11/91 - Added a MKI, MKS and MKD functions to write data.               *
*             MKS & MKD functions only work with integer values.              *
*                                                                             *
*  07/19/90 - Fixed a problem with precision on numbers in the range          *
*             0.5040 to 0.5624.                                               *
*                                                                             *
*  07/18/89 - Created initial functions.                                      *
*                                                                             *
*=============================================================================*
*                                                                             *
*  Function     Description                                                   *
*  --------     ------------------------------------------------------------- *
*  CVI          Convert data stored by BASIC as an integer                    *
*  CVS          Convert data stored by BASIC as a single precision number     *
*  CVD          Convert data stored by BASIC as a double precision number     *
*                                                                             *
*  MKI          Write a number in BASIC (2 character) format                  *
*  MKS          Write a number in BASIC single precision (4 character) format *
*  MKD          Write a number in BASIC double precision (8 character) format *
*                                                                             *
*  BIN2DEC      Convert binary to decimal                                     *
*  DEC2BIN      Convert decimal to binary                                     *
*  NEG_BIN      Convert the binary number using negative power of 2           *
*  NEG_DEC      Convert the binary decimal using negative power of 2          *
*  SHOW_BIN     Show the actual binary number to examine layout               *
*                                                                             *
*******************************************************************************
*  C functions from Ted Means to convert between IEEE format used in QBASIC.  *
*                                                                             *
*  Clip2IEEE( <nNumberToConvert>, <nLen> )                                    *
*  where <nLen> is either 4 or 8 depending on whether you want a 4-byte or    *
*  8-byte IEEE number.  It defaults to 8.                                     *
*                                                                             *
*  IEEE2Clip( <cStoredNumber> )                                               *
*  This will convert a 4 or 8 character string into a number.                 *
*                                                                             *
*******************************************************************************


*!*********************************************************************
*!
*!       Function: CVI()
*!
*!*********************************************************************
FUNCTION Cvi( cString )
LOCAL nVal
* Translate a two-byte string to actual numbers  ( BASIC's CVI function )
nVal := ASC(SUBSTR(cString,1,1))+(ASC(SUBSTR(cString,2,1))*256)
RETURN ( nVal - IIF( nVal > 32767, 65536, 0 ) )


*!*********************************************************************
*!
*!       Function: CVS()
*!
*!*********************************************************************
FUNCTION Cvs( cString )
* Translate a four-byte string to actual numbers  ( BASIC's CVS function )
LOCAL i, cBasic := "", cv_pos, cv_exp, cv_man, cv_val, cv_dec

IF cString == REPLICATE( CHR(0), 4 )   // zero is stored as NULL characters
   RETURN 0
ENDIF

* Single precision numbers are stored as four bytes by MKS function in BASIC.
* The four bytes comprising single-precision numbers are read RIGHT to LEFT.
FOR i := 4 TO 1 STEP -1
   cBasic += Dec2Bin( ASC( SUBSTR( cString, i, 1 ) ) )
NEXT

* The exponent byte contains the binary number used to calculate exponent.
* This number is subtracted by 128 to get the actual exponent value.
* The exponent refers to a power of two, by which the mantissa is multiplied.
cv_exp := ASC( SUBSTR( cString, 4, 1 ) ) - 128

* The first character of the third byte contains the sign bit.
* If the number is positive it equals 0; if negative it equals 1.
cv_pos := IF( SUBSTR( cBasic, 9, 1 ) == "0", .T., .F. )

* The final 23 characters contain the mantissa.  All binary numbers except
* zero start with a 1.  This is not contained in the mantissa bytes.
cv_man := "1" + SUBSTR( cBasic, 10, 23 )

IF cv_exp > 0
   * Translate the binary number to integer.
   cv_val := Bin2dec( SUBSTR( cv_man, 1, cv_exp ) )

   * Translate the binary number to decimal equivalent.
   cv_dec := Neg_bin( SUBSTR( cv_man, cv_exp + 1 ) )

   cv_val += cv_dec

ELSE
   * Only a decimal value; move decimal to left by adding zeros.
   cv_val := Neg_bin( REPLICATE( "0", -1 * cv_exp ) + cv_man )
ENDIF

IF .NOT. cv_pos
   cv_val := cv_val * -1
ENDIF

RETURN cv_val


*!*********************************************************************
*!
*!       Function: CVD()
*!
*!*********************************************************************
FUNCTION Cvd( cString )
* Translate an eight-byte string to actual numbers  ( BASIC's CVD function )
LOCAL i, cBasic := "", cv_pos, cv_exp, cv_man, cv_val, cv_dec

IF cString == REPLICATE( CHR(0), 8 )    // zero is stored as NULL characters
   RETURN 0
ENDIF

* Double precision numbers are stored as eight bytes by MKD function in BASIC.
* The eight bytes comprising double-precision numbers are read RIGHT to LEFT.
FOR i := 8 TO 1 STEP -1
   cBasic += Dec2Bin( ASC( SUBSTR( cString, i, 1 ) ) )
NEXT

* The exponent byte contains the binary number used to calculate exponent.
* This number is subtracted by 128 to get the actual exponent value.
* The exponent refers to a power of two, by which the mantissa is multiplied.
cv_exp := ASC( SUBSTR( cString, 8, 1 ) ) - 128

* The first character of the seventh byte contains the sign bit.
* If the number is positive it equals 0; if negative it equals 1.
cv_pos := IF( SUBSTR( cBasic, 9, 1 ) = "0", .T., .F. )

* The final 55 characters contain the mantissa.  All binary numbers except
* zero start with a 1.  This is not contained in the mantissa bytes.
cv_man := "1" + SUBSTR( cBasic, 10, 55 )

IF cv_exp >= 0
   * Translate the binary number to integer.
   cv_val := Bin2dec( SUBSTR( cv_man, 1, cv_exp ) )

   * Translate the binary number to decimal equivalent.
   cv_dec := Neg_bin( SUBSTR( cv_man, cv_exp + 1 ) )

   cv_val += cv_dec

ELSE
   * only a decimal value; move decimal to left by adding zeros
   cv_val := Neg_bin( REPLICATE( "0", -1 * cv_exp ) + cv_man )
ENDIF

IF .NOT. cv_pos
  cv_val := cv_val * -1
ENDIF

RETURN cv_val


*!*********************************************************************
*!
*!       Function: MKI()
*!
*!*********************************************************************
FUNCTION Mki( nBasic )
* Translate a number into a two-byte string  ( BASIC's MKI function )
* Syntax: MKI(<num>)
LOCAL nInt
IF nBasic < 0
   nInt := INT(-nBasic/256)
   IF nBasic == nInt * -256
      RETURN CHR( 0 ) + CHR( 256 - nInt )
   ELSE
      RETURN CHR( nBasic + ( nInt * 256 ) ) + CHR( 255 - nInt )
   ENDIF
ENDIF
RETURN CHR( nBasic -( INT(nBasic/256) * 256 ) ) + CHR( INT(nBasic/256) )


*!*********************************************************************
*!
*!       Function: MKS()
*!
*!*********************************************************************
FUNCTION Mks( nBasic )
* Translate a number into a four-byte string  ( BASIC's MKS function )
LOCAL i, cString := "", cDecimal := "", cv_exp, lNeg, cReturn := ""

IF nBasic == 0
   RETURN REPLICATE( CHR(0), 4 )
ENDIF

* Is the number positive or not?
lNeg := ( nBasic <> ABS( nBasic ) )

* Make number positive
nBasic := ABS( nBasic )

* Convert integer to binary format
IF INT( nBasic ) > 0
   cString := Dec2bin( nBasic, 32 )
   cString := SUBSTR( cString, AT( "1", cString ) )
ENDIF

* Convert decimal to binary format
cDecimal := Neg_Dec( nBasic - INT( nBasic ), 32 )

* Exponent byte contains the binary number used to calculate exponent.
* Exponent refers to a power of two, by which the mantissa is multiplied.
if LEN( cString ) <> 0
   cv_exp := CHR( 128 + LEN( cString ) )
else
   cv_exp := CHR( 128 - ( AT("1",cDecimal) - 1) )
endif

* Add the decimal string to the integer string
cString += cDecimal

* strip off the leading zeros
cString := SUBSTR( cString, AT( "1", cString ) )

* set the sign bit
cString := IF( lNeg, cString, STUFF( cString, 1, 1, "0" ) )

* pad string with zeros
cString := PADR( cString, 24, "0" )
FOR i := 17 TO 1 STEP -8
   cReturn += CHR( Bin2dec( SUBSTR( cString, i, 8 ) ) )
NEXT

RETURN cReturn + cv_exp


*!*********************************************************************
*!
*!       Function: MKD()
*!
*!*********************************************************************
FUNCTION Mkd( nBasic )
* Translate a number into an eight-byte string  ( BASIC's MKD function )
LOCAL i, cString := "", cDecimal := "", cv_exp, lNeg, cReturn := ""

IF nBasic == 0
   RETURN REPLICATE( CHR(0), 8 )
ENDIF

* Is the number positive or not?
lNeg := ( nBasic <> ABS( nBasic ) )

* Make number positive
nBasic := ABS( nBasic )

* Convert integer to binary format
IF INT( nBasic ) > 0
   cString := Dec2bin( nBasic, 64 )
   cString := SUBSTR( cString, AT( "1", cString ) )
ENDIF

* Convert decimal to binary format
cDecimal := Neg_Dec( nBasic - INT( nBasic ), 64 )

* Exponent byte contains the binary number used to calculate exponent.
* Exponent refers to a power of two, by which the mantissa is multiplied.
if LEN( cString ) <> 0
   cv_exp := CHR( 128 + LEN( cString ) )
else
  cv_exp := CHR( 128 - ( AT("1",cDecimal) - 1) )
endif

* Add the decimal string to the integer string
cString += cDecimal

* strip off the leading zeros
cString := SUBSTR( cString, AT( "1", cString ) )

* set the sign bit
cString := IF( lNeg, cString, STUFF( cString, 1, 1, "0" ) )

* pad string with zeros
cString := PADR( cString, 58, "0" )
FOR i := 49 TO 1 STEP -8
   cReturn += CHR( Bin2dec( SUBSTR( cString, i, 8 ) ) )
NEXT

RETURN cReturn + cv_exp


*!*********************************************************************
*!
*!       Function: BIN2DEC()
*!
*!*********************************************************************
FUNCTION BIN2DEC( cBinary )
* Original input from Clayton Neff  72007,302
LOCAL nReturn := 0, i, nLen := LEN( cBinary )
FOR i := 0 TO nLen - 1
   IF SUBSTR( cBinary, nLen-i, 1 ) == '1'
      nReturn += 2^i
   ENDIF
NEXT i
RETURN nReturn


*!*********************************************************************
*!
*!       Function: DEC2BIN()
*!
*!*********************************************************************
FUNCTION Dec2Bin( nDec, nLength )
LOCAL i, cReturn := ""
nLength := IF( VALTYPE(nLength)<>"N", 7, nLength - 1 )
FOR i = nLength TO 0 STEP -1
  IF nDec >= 2 ^ i
     nDec -= 2 ^ i
     cReturn += "1"
  ELSE
     cReturn += "0"
  ENDIF
NEXT
RETURN cReturn


*!*********************************************************************
*!
*!       Function: NEG_BIN()
*!
*!*********************************************************************
FUNCTION Neg_Bin( cString )
* Convert the binary decimal items using negative power of 2
LOCAL i, nAmount := 0
FOR i := 1 TO LEN( cString )
   nAmount += IF( SUBSTR( cString, i, 1 ) == "1", 2^-i, 0 )
NEXT
RETURN nAmount


*!*********************************************************************
*!
*!       Function: NEG_DEC()
*!
*!*********************************************************************
FUNCTION Neg_Dec( nDec, nLength )
* Convert decimal value to binary decimal using negative power of 2
LOCAL i, cReturn := ""
nLength := IF( VALTYPE(nLength)<>"N", 8, nLength )
FOR i = 1 TO nLength
  IF nDec >= 2 ^ -i
     nDec -= 2 ^ -i
     cReturn += "1"
  ELSE
     cReturn += "0"
  ENDIF
NEXT
RETURN cReturn


*!*********************************************************************
*!
*!       Function: SHOW_BIN()
*!
*!*********************************************************************
FUNCTION Show_bin( cString )
* Show binary number string
LOCAL i, cBasic := ""
* String is read from RIGHT to LEFT !!!
FOR i = LEN( cString ) TO 1 STEP -1
   cBasic += Dec2Bin( ASC( SUBSTR( cString, i, 1 ) ) )
NEXT
RETURN cBasic

*: EOF: CV_READ.PRG
