
FUNCTION QTEST()
* Test IEEE2CLIP and CLIP2IEEE functions by running a QBASIC program
* reading the results.

LOCAL nOutKey := 0, nHandle, cText, x1, x2, x3, n2, n3, nDecimals := 8
LOCAL Getlist := {}

CLEAR SCREEN
@ 01,01 SAY "Set DECIMALS to:" GET nDecimals PICTURE "99"
READ
SET DECIMALS TO nDecimals
SET FIXED ON

DO WHILE nOutKey <> 27

   IF FILE("QTEST.BAS")
      RUN QBASIC /RUN QTEST
   ENDIF

   STORE SPACE(17) TO cText

   IF FILE("QTEST.DAT")
      nHandle := FOPEN( "QTEST.DAT", 0 )
      * read both examples
      FREAD( nHandle, @cText, 17 )
      FCLOSE( nHandle )
   ENDIF

   @ 08,00 SAY REPLICATE("=",80)

   x2 := SUBSTR( cText, 2, 4 )
   x3 := SUBSTR( cText, 9, 8 )

   @ 12,10 SAY "Value returned by IEEE2CLIP("+x2+"): "
   n2 := IEEE2CLIP(x2)
   @ 12,50 SAY n2
   x2 := CLIP2IEEE( n2, 4 )
   @ 14,10 SAY "Converted by CLIP2IEEE() => "+x2

   @ 18,10 SAY "Value returned by IEEE2CLIP("+x3+"): "
   n3 := IEEE2CLIP(x3)
   @ 18,50 SAY n3
   x3 := CLIP2IEEE( n3, 8 )
   @ 20,10 SAY "Converted by CLIP2IEEE() => "+x3

   @ 23,00 SAY "Press [Esc] to quit; any other key to repeat ..."
   nOutKey := INKEY(0)

ENDDO

RETURN .T.

*: END OF QTEST.PRG
