/******************************************************************************
* Program Id: curdrive.c
*     System: JFK.LIB
*     Client: You know who you are!
*    Version: 1.00
*******************************************************************************
*
*    Purpose: Provide the missing function that Clipper needs for indicating
*             what the current logged disk drive is.
*
*******************************************************************************
*
*  Called by: curdrive()
*
*   Calls to: DOS interrupt 21h
*
*******************************************************************************
* Date     Name Description
*
* 10/02/89 jfk  Original program
******************************************************************************/

#include <nandef.h>
#include <extend.h>

/******************************************************************************
Syntax:   drivenum()
Returns:  The drive number of the current logged drive, 0 for A to 25 for Z.

Notes:    Written for Turbo C 2.0.  Recompile with:
          tcc -c -f- -ml -K -N- curdrive.c

          Why use TC 2.0?  Because getting parameters and returning values from
          C with inline assembler is a breeze!
******************************************************************************/

CLIPPER drivenum( void )
{

  asm mov ah, 19h;  /* Current disk drive */
  asm int 21h;      /* DOS interrupt */
  _retni( _AL );

}
