******************************************************************
* The functions in this file simplify the usage of semaphore
* locks with CA-Clipper Tools III. Note that the <cSemaphore>
* parameter is not case sensitive. Semaphore names can be up to
* 54 characters long. Compile with /n /m /w switches.
*
*   gsISSEMLOCK( <cSemaphore> ) => <lIslocked>
*
*   gsSEMLOCK( <cSemaphore> ) => <lDidlock>
*
*   gsSEMUNLOCK( <cSemaphore> ) => <lDidUnLock>
*
* Example:
*
* if gsISSEMLOCK('INDEXING')
*    ? 'Another workstation is busy indexing.'
* else
*    if gsSEMLOCK('INDEXING')
*       ? 'Indexing...'
*       gsSEMUNLOCK('INDEXING')
*    else
*       ? 'Error: Locking semaphore INDEXING failed.'
*    endif
* endif
******************************************************************

function gsISSEMLOCK(semaphore)
*******************************
local retvar := .f.
local handle := NNETSEMOPN(semaphore,1)

if ! handle == 0
   if NNETSEMOPC(handle)>1
      retvar := .t.
   endif
   NNETSEMCLO(handle)
endif

return(retvar)


function gsSEMLOCK(semaphore)
*****************************
local retvar := .t.
local handle := NNETSEMOPN(semaphore,1)

if ! handle == 0
   if NNETSEMOPC(handle)>1
      NNETSEMCLO(handle)
      retvar := .f.
   endif
endif

return(retvar)


function gsSEMUNLOCK(semaphore)
*******************************
local handle := NNETSEMOPN(semaphore)

if ! handle == 0
   NNETSEMCLO(handle)
endif

return(.t.)
