* Program Name: win_func.pre 
* Author: George Dunham 
* Copyright (c) 1990 by Unified Systems Computer Services, Inc. 
*-----------------------------------------------------------------------------
* Created: 1/15/1990 at 14:42
*  
*     This Function source file is used for manipulating the display
*  using Clipper Tools 1 and provided functions.
*  
*     Window closing is left to the calling procedure to facilitate
*  leaving multiple windows open. Hopping about is then possible.
*  
*     The PUSHWIN/POPWIN functions Create a PUBLIC String WIN_STACK.
*  This stack has 8 single CHR elements and can be searched for a window
*  handle. Pushes are called prior to opening a window and pops are called
*  after closeing a window. Poping the stack does not close the current
*  window as this may result in closing a window still on the stack and
*  leaving a window open no longer on the stack. This most likely would
*  be caused because The clipper tools 1 library function WCLOSE restores
*  the screen to the last window handle > 0 this corrupts the sequential
*  nature of its own window handle history. 
*
*     The purpose here is to provide a simple trail out to follow back.
*
*.............................................................................
* Revision: 1.0 Last Revised: 1/15/1990 at 14:42
* Description: Original Creation.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------



*** POPERR()
*
*
* SYNTAX    :  POPERR(Exp_C,Exp_N,Exp_N,Exp_C)
*                                    
*                                     Window Title  (Optional)
*                                Window Col    (Optional)
*                           Window Row    (Optional)
*                      Message Text
*         
* PURPOSE   :  Place Error Messages in a Window. 
*           :  If Row is omitted or invalid the window will appear
*           :  away from the cursor.
*
* CALLS     :  EMPTY, PCOUNT, POPMSG
*
* RETURNS   :  True or False - This allows placing an expression as Arg 1
*
* EXAMPLE   :  POPERR(IF(FILE("DATA_DIC.DBF"),"","Bad or Missing Data Dictionary"))
*
***
FUNCTION POPERR
   PARAMETERS msg, r, c, title
   PRIVATE p, Void, True
   p = PCOUNT()
   IF p > 0 .AND. EMPTY(msg)
      RETU (.T.)
   ENDIF
   True = .T.
   DO CASE
      CASE p = 1
         POPMSG(@msg,"","","","",@true)
      CASE p = 2
         POPMSG(@msg,r,    "","","",@true)
      CASE p = 3
         POPMSG(@msg,r,    c,    "","",@true)
      CASE p = 4
         POPMSG(@msg,r,    c,    "","",@true,@title)
   ENDCASE
RETURN (.F.)

*** STATMSG()
*
*
* SYNTAX    :  STATMSG(Exp_c)
*                               
*                       Message Text
*                      
* PURPOSE   :  Write Info to line 24
*           :  If message longer than 79 Calls POPMSG
*           :  If message "" or undefined line 24 cleared.
*
* CALLS     :  LEN, CSETCURS, PADRIGHT, POPMSG, POPWIN, PUSHWIN,
*              SETCOLOR, TYPE, WSELECT
*
* RETURNS   :  Void
*
* ASSUMED   :  Color variable msgcolor
*
* EXAMPLE   :  STATMSG("27 Records SELECTED.")
*
***
FUNCTION STATMSG
   PARAMETERS msg
   PRIVATE o_win, o_colr, o_set_cur
   IF ! (TYPE("msg") $ [C])
      msg = ""
   ENDIF
   IF LEN(msg) < 79
      PUSHWIN()
      WSELECT(0)
      CSETCURS(.F.)
      SETCOLOR(M->msgcolor)
      @ 24,0 SAY PADRIGHT(msg,80)
      POPWIN()
   ELSE
      POPMSG(msg)
   ENDIF
RETURN (.T.)

*** POPMSG()
*
* SYNTAX : POPMSG(Exp_C1,Exp_N1,Exp_N2,Exp_N3,Exp_N4,Exp_L,Exp_C2)
*                                                    
*                                                     Title.
*                                               
*                                                TRUE if ERROR.
*                                         
*                                          Right.
*                                   
*                                    Bottom.       
*                             
*                              Left.
*                       
*                        Top.          
*                 
*                  Message.
*
* PURPOSE   :  Display message text in a shadowed window.
*           
* NOTES:    1. If the Message will not fit in the window we call
*              MEMOEDIT and allow scrolling, ESC required to exit.
*              
*           2. Always Pauses any key will close window and proceed
*              except as noted above.
*              
*           3. The window auto sizes 1 to 4 High, 19 Wide.
*              
*           4. Auto detects Underlying Cursor position and Avoids
*              the area if no Row is specified.
*
* CALLS     :  COL, CSETCURS, EMPTY, INKEY, LEN, MAX, MAXCOL, MAXROW, 
*              MEMOEDIT, MIN, MLCOUNT, PADRIGHT, POPWIN, PUSHWIN,
*              ROW, SETCOLOR, TYPE, WCEN, WCLOSE, WS_OPEN, WSELECT
*
* RETURNS   :  Void.
*
* ASSUMED   :  Color variable msgcolor, errcolor
*
* EXAMPLE   :  POPMSG("POPMSG always pauses. If window size is exceeded ESC to Exit")
*
FUNCTION POPMSG
   PARAMETERS msg, r, c, b_r, b_c, err, title
   PRIVATE o_r, o_c, o_colr, b_title, t_title, w_start, lines, i, o_set_cur
   IF ! (TYPE([err]) $ [L])
      err = .F.
   ENDIF
   M->title = IF(TYPE("title")$[U],[],M->title)
   PUSHWIN()
   CSETCURS(.F.)
   M->o_r = ROW()
   IF ! ([N] $ TYPE([r]))
      IF M->o_r < 12
         r = 14
      ELSE
         r = 2
      ENDIF
   ENDIF
   WSELECT(0)
   SETCOLOR(IF(M->err,M->errcolor,M->msgcolor))
   M->c = IF([N] $ TYPE([c]),M->c,19)
   M->h = MIN(MLCOUNT(M->msg,38) + 2,8)
   M->b_c = IF(TYPE([b_c])$[N],M->b_c,c+40)
   M->b_r = IF(TYPE([b_r])$[N],M->b_r,r + MIN(MLCOUNT(M->msg,38) + 2,8))
   M->t_title = IF(M->err ,IF(EMPTY(M->title),[ ERROR ],M->title),IF(EMPTY(M->title),[ Message Box ],M->title))
   M->b_title = IF(M->err .OR. MLCOUNT(M->msg,38) > 6,[ Esc to Continue... ],IF((b_r - r) = 3,[ Any Key to Continue... ],[  Esc to Exit ]))

   WS_OPEN(M->r,M->c,M->b_r,M->b_c,1,M->t_title,M->b_title)

   IF err
      ?? CHR(7)
      * CRIT_ERR()                               && Use this if you have one
   ENDIF
   IF (b_r - r) = 3
      WCEN(0,M->msg)
      IF M->b_title == [ Any Key to Continue... ]
         INKEY(0)
      ELSE
         DO WHILE INKEY(0) # 27
         ENDDO
      ENDIF

   ELSE
      IF M->b_title == [ Any Key to Continue... ]
         KEYBOARD CHR(27)
         MEMOEDIT(M->msg,0,1,MAXROW(),MAXCOL()-1,.F.)
         INKEY(0)
      ELSE
         MEMOEDIT(M->msg,0,1,MAXROW(),MAXCOL()-1,.F.)
      ENDIF
   ENDIF
   WCLOSE()
   POPWIN()
RETURN ("")

*** WCEN()
*
* SYNTAX    :  WCEN(Exp_N,Exp_C)
*
*                        
*                         Text to Center.
*                   
*                    Line to Display on.
*
* PURPOSE   :  Centers character string in window.
*
* CALLS     :  LEN, MAXCOL
*
* RETURNS   :  Void.
*
FUNCTION WCEN
   PARAMETERS LINE, STRING
   IF LEN(M->STRING) < MAXCOL()
      @ M->LINE, ((MAXCOL() - LEN(M->STRING)+1)/2) SAY M->STRING
   ELSE
      @ M->LINE, 0 SAY M->STRING
   ENDIF
RETURN ("")

*** WS_OPEN()
*
*                                                          Border Color.  Ŀ  
*                                                                          
*                                                 Inside Color.    Ŀ      
*                                                                         
*                                                Top Title. Ŀ            
*                                                                        
*                                     Bottom Title   Ŀ                  
*                                                                       
*
* SYNTAX : WS_OPEN(Exp_N1,Exp_N2,Exp_N3,Exp_N4,Exp_N5,Exp_C1,Exp_C2,Exp_X1,Exp_X2)
*
*                                          
*                                           Type. (See NOTES)
*                                    
*                                     Right. (REQUIRED)
*                              
*                               Botttom. (REQUIRED)
*                        
*                         Left. (REQUIRED)
*                  
*                   Top. (REQUIRED)
*
*           :  Type (0 or "" = none, 1 =  , 2 =  , 3 =  , 4 =  , 5 = 
*           :        6 = )
*
* PURPOSE   :  Open Shadowed Window and outline as required by Type.
*
* NOTES:    1. Type designates the Border type.
*
*              a. The Default is no border.
*
*              b. Summery of Types.
*
*                 0)
*                 1) Ŀ
*                 2) ͻȺ
*                 3) ͸Գ
*                 4) ķӺ
*                 5) 
*                 6) ͻϳ
*
*           2. PUSHWIN and POPWIN are the responsibility of the calling
*              procedure and are not called here.
*
* CALLS     :  COLORREPL, CSETCURS, MAXROW, NTOCOLOR, PCOUNT, SETCOLOR,
*              TYPE, WBOX, WCEN, WFORMAT, WOPEN
*
* RETURNS   :  Window Handle.
*
FUNCTION WS_OPEN
   PARAMETERS t,l,b,r,bdr,t_title, b_title, b_color, i_color
   PRIVATE w_hand, o_colr, p
   M->p = PCOUNT()
   M->box_str = [ĿͻȺ͸ԳķӺͻϳ]
   IF M->p < 4
      TEXT

   Parameters less than 4
   Some times I wonder about you as a programmer!


      ENDTEXT
      QUIT
      * SQLQST()                                 && A QUIT function I use.
   ELSE
      IF M->p > 4
         IF ! (TYPE([bdr]) $ [N])
            M->bdr = 0
         ENDIF
         IF ! (TYPE([t_title]) $ [C])
            M->t_title = ""
         ENDIF
         IF ! (TYPE([b_title]) $ [C])
            M->b_title = ""
         ENDIF
         b_color = IF([U] $ TYPE([b_color]),SETCOLOR(),IF([C] $ TYPE([b_color]),b_color,NTOCOLOR(b_color)))
         i_color = IF([U] $ TYPE([i_color]),SETCOLOR(),IF([C] $ TYPE([i_color]),i_color,NTOCOLOR(i_color)))
      ELSE
         M->bdr = 0
         M->t_title = ""
         M->b_title = ""
         b_color = SETCOLOR()
         i_color = b_color
      ENDIF
   ENDIF
   M->w_hand = WOPEN(M->t,M->l,M->b,M->r,.F.)
   WFORMAT(1,2,0,0)
   COLORREPL("W/N")
   WFORMAT(-1,-2,1,2)
   IF M->bdr # 0
      SETCOLOR(b_color)
      WBOX(SUBSTR(M->box_str,((M->bdr-1)*08)+01,08)+[ ])
      WCEN(-1,M->t_title)
      WFORMAT(0,0,-1,0)
      WCEN(MAXROW(),M->b_title)
      SETCOLOR(i_color)
      WFORMAT(0,0,1,0)
      * CLWIN()
      COLORREPL(TOKEN(i_color,[,],1))
   ELSE
      SETCOLOR(i_color)
      WBOX(SPACE(9))
      WFORMAT(-1,-1,-1,-1)
   ENDIF
RETURN (M->w_hand)

*** WPAD()
*
* SYNTAX    :  WPAD(Exp_C1,Exp_C2)
*                         
*                          Pad Char (Default " ")
*                   
*                    String
*
* PURPOSE   :  To pad a string to the full width of a window.
*
* CALLS     :  LEFT, MAXCOL, PADRIGHT
*
* RETURNS   :  Padded string
*
FUNCTION WPAD
   PARAMETERS string, pad
   pad = IF([C] $ pad,LEFT(pad,1)," ")
RETURN (PADRIGHT(@string,MAXCOL(),@pad))


*** PUSHWIN()
*
*
* SYNTAX    :  PUSHWIN()
*
* PARAMETERS:  None.
*
* PURPOSE   :  To push a string on to the besinning of the window stack.
*
* NOTES:    1. This function Checks for a PUBLIC of WIN_STACK and
*              declares it if necessary.
*
*           2. Each PUSH adds:
*              a. Unselected color
*              b. Selected color
*              c. Standard color
*              d. Insert state
*              e. Cursor on/off
*              f. Column
*              g. Row
*              h. Window handle.
*
*           3. All Entities are in string format.
*           
*           4. The string functions as an array.
*
*           5. The spacing is consistant such that the string can be scanned
*              to find a specific window already open then select it and
*              reset all window parameters.
*
* CALLS     :  COLORREPL, CSETCURS, MAXROW, NTOCOLOR, PCOUNT,
*              READINSERT, SETCOLOR, TYPE, WBOX, WCEN, WFORMAT, WOPEN
*
* RETURNS   :  Void
*
***
FUNCTION PUSHWIN
   PRIVATE tcolor
   IF [U] $ TYPE([WIN_STACK])
      PUBLIC WIN_STACK
      WIN_STACK = [ ]
   ENDIF
   tcolor = SETCOLOR()
   WIN_STACK = CHR(COLORTON(TOKEN(tcolor,[,]  )))+WIN_STACK
   WIN_STACK = CHR(COLORTON(TOKEN(tcolor,[,],2)))+WIN_STACK
   WIN_STACK = CHR(COLORTON(TOKEN(tcolor,[,],1)))+WIN_STACK
   WIN_STACK = CHR(WSELECT())+CHR(ROW())+CHR(COL())+A2C(CSETCURS())+A2C(READINSERT())+WIN_STACK
RETURN ("")

***  POPWIN() POPWIN()
*
*
* SYNTAX    :  POPWIN()
*
* PARAMETERS:  None.
*
* PURPOSE   :  To pop a string from the besinning of the window stack.
*           :  To restore the proper environment for the popped window.
*
*           1. This function Checks for WIN_STACK underflow and
*              informs operator before quitting.
*
*           2. Each POP removes:
*              a. Unselected color
*              b. Selected color
*              c. Standard color
*              d. Insert state
*              e. Cursor on/off
*              f. Column
*              g. Row
*              h. Window handle.
*
*           3. All Entities are in string format.
*
*           4. The string functions as an array.
*
* CALLS     :  ABYTE, ASCPOS, CSETCURS, LEN, NTOCOLOR,
*              READINSERT, SETCOLOR, SETRC, WSELECT
*
* RETURNS   :  Void
*
***
FUNCTION POPWIN
   PRIVATE tcolor
   IF LEN(WIN_STACK) < 8
      WAIT "FATAL Error - Window Stack Underflow..."
      QUIT
      * SQLQST()
   ENDIF
   WSELECT(ASCPOS(WIN_STACK,1))
   SETRC(ASCPOS(WIN_STACK,2),ASCPOS(WIN_STACK,3))
   CSETCURS([T] $ ABYTE(WIN_STACK,4))
   READINSERT([T] $ ABYTE(WIN_STACK,5))
   tcolor = NTOCOLOR(ASCPOS(WIN_STACK,6))+[,]+NTOCOLOR(ASCPOS(WIN_STACK,7))+[,N,N,]+NTOCOLOR(ASCPOS(WIN_STACK,8))
   SETCOLOR(tcolor)
   WIN_STACK = SUBSTR(WIN_STACK,9)
RETURN("")
