* Procedure File ...: SWAP.PRG
* Date .............: 01/29/91
* Author ...........: Suat Aricanli,  The Basys Development Group.
* Purpose ..........: Function that calls SWITCHIT() handling interrupts.
*
*          Copyright (C) 1991 Suat Aricanli.  All Rights Reserved.
*
* Notes .....: 1- This product is compatible with Clipper's Summer' 87
*                 version and is not guaranteed to work with release 5.
*              2- You must already have SWITCHU7.OBJ and the Clipper
*                 Tools One Library to use this function.
*              3- CTOOLD87.OBJ must be replaced by MTOOLD87.OBJ
*                 (will not work without MTOOLD87.OBJ).
*              4- MTOOLD87.OBJ has to be linked into main load module
*                 (root of your application) as CTOOLD87.OBJ also must.
*              5- All interrupts will be handled even those additional
*                 to the ones set by CT1.
*
*************************************************************************
*  If you are using any of the three functions SWITCHIN(), SWITCHOUT(), *
*  or CT1SWITCH() then send $25.00 to:                                  *
*                                       Suat Aricanli                   *
*                                       The Basys Development Group     *
*                                       P.O.BOX 23066                   *
*                                       Cleveland, OH  44123            *
*                                                                       *
*  Registered users will receive one free update and telephone support. *
*                                                                       *
*************************************************************************
*
* FUNCTION CT1SWITCH
*
* Syntax: CT1SWITCH(<expC1>,<expC2>,<expN>)
*
*
* Parameters:
*         <expC1> = Command Line to be executed by DOS.  If blank, DOS
*                   window is made available.  Type EXIT to return
*                   from DOS window.  If given, command is executed
*                   at DOS level.
*         <expC2> = Path to create temporary file in.
*         <expN>  = Number of Kbytes to free.
*
*
* Returns:
*         A value as described by the Switchit documentation is returned.
*
*
* Actions taken by CT1SWITCH():
*
*      1- Reset CT1 and additional interrupts to values previous to
*         program start, saving current status [ calling SWITCHOUT() ].
*
*      2- Call the SWITCHIT() function.
*
*      3- Reset CT1 and other interrupts to values previous to the
*         SWITCHOUT() call [ calling SWITCHIN() ].
*
************************************************************************


FUNCTION CT1SWITCH
PARAMETERS L_SW1, L_SW2, L_SW3

PRIVATE L_SWROW, L_SWCOL, L_SWSCR, L_SWRET

IF PCOUNT()<3
   L_SW3=640
ENDIF
IF PCOUNT()<2
   L_SW2=""
ENDIF
IF PCOUNT()<1
   L_SW1=""
ENDIF

L_SWROW=ROW()
L_SWCOL=COL()
SAVE SCREEN TO L_SWSCR

SWITCHOUT()                        && clear CTOOLD87 settings

CLEAR

@24,0 SAY ""

IF EMPTY(L_SW1)
   ?
   ? "Type EXIT to return to program."
   ?
ENDIF

SET CURSOR ON

L_SWRET=SWITCHIT(L_SW1, L_SW2, L_SW3)

SET CURSOR OFF

SWITCHIN()                         && restore CTOOLD87 settings

RESTORE SCREEN FROM L_SWSCR
@ L_SWROW,L_SWCOL SAY ""

RETURN L_SWRET
*

