
* syntax:       SCR_PLAY(<[expN1]>, <[expN2]>, <[expN3]>, <[expN4]>)

* purpose:      Move a box around the screen saving the underlying screen
*               attributes, changing them, and restoring them after moving
*               to another screen location; i.e. just playing around.

* argument:     <expN1> and <expN2> are the horizontal and vertical size
*               of a box that will be moved around the screen changing the
*               attributes of the characters within the box.  <expN3> and
*               <expN4> are the horizontal and vertical step sizes to move 
*               the box.

* returns:      Nothing.

*               I was playing around and thought I'd upload this since it was 
*               so much fun to do.  Consider the clipper code public domain.
*               My thanks to Jim Nickel.

!type attrplay.doc
SCR_PLAY()
return

func SCR_PLAY
para HorSize, VerSize, HorStep, VerStep
  HorSize = if(type('HorSize') == 'N', HorSize, 15)
  VerSize = if(type('VerSize') == 'N', VerSize, 10)
  VerStep = if(type('VerStep') == 'N', VerStep,  3)
  HorStep = if(type('HorStep') == 'N', HorStep,  6)
priv key, OldScreen, Top, Left, Bottom, Right, OldPlace,;
     TextColor, BackColor, SaveColor
  Esc          = 27
  UpArrow      = 5
  DnArrow      = 24
  LeftArrow    = 19
  RightArrow   = 4
  F1           = 28
  F2           = -1
  Top          = 5
  Left         = 5
  Bottom       = 24
  Right        = 79
  TextColor    = 14
  BackColor    = 5
  SaveColor    = SETCOLOR()
  save screen to OldScreen
  set cursor off
  HELP_LINE()
  OldPlace = Savescreen(Top, Left, Top + VerSize, Left + HorSize)
  SETATTR(Top, Left, Top + VerSize, Left + HorSize, BackColor * 16 + TextColor)
  SHOW_NAME(TextColor, BackColor)
  do while .t.
    key = inkey(0)
    do case
      case key = Esc
        restore screen from OldScreen
        set color to SaveColor
        set cursor on
        exit
      case key = UpArrow
        Restscreen(Top, Left, Top + VerSize, Left + HorSize, OldPlace)
        Top = if(Top - VerStep < 0, Bottom - VerSize, Top - VerStep)
        OldPlace = Savescreen(Top, Left, Top + VerSize, Left + HorSize)
      case key = LeftArrow
        Restscreen(Top, Left, Top + VerSize, Left + HorSize, OldPlace)
        Left = if(Left - HorStep < 0, Right - HorSize, Left - HorStep)
        OldPlace = Savescreen(Top, Left, Top + VerSize, Left + HorSize)
      case key = DnArrow
        Restscreen(Top, Left, Top + VerSize, Left + HorSize, OldPlace)
        Top = if(Top + VerSize + VerStep > Bottom, 0, Top + VerStep)
        OldPlace = Savescreen(Top, Left, Top + VerSize, Left + HorSize)
      case key = RightArrow
        Restscreen(Top, Left, Top + VerSize, Left + HorSize, OldPlace)
        Left = if(Left + HorSize + HorStep > Right, 0, Left + HorStep)
        OldPlace = Savescreen(Top, Left, Top + VerSize, Left + HorSize)
      case key = F1
        TextColor = if(TextColor = 15, 0, TextColor + 1)
      case key = F2
        BackColor = if(BackColor = 7, 0, BackColor + 1)
    endcase
    SETATTR(Top,Left,Top + VerSize, Left + HorSize, BackColor * 16 + TextColor)
    SHOW_NAME(TextColor, BackColor)
  enddo
  set cursor on
return ''

func COLORS
para StdFore,  StdBack, CurFore,  CurBack, UnselFore, UnselBack
  StdFore   = if(type('StdFore')   == 'C', StdFore,  'w+')
  StdBack   = if(type('StdBack')   == 'C', StdBack,   'n')
  CurFore   = if(type('CurFore')   == 'C', CurFore,  'w+')
  CurBack   = if(type('CurBack')   == 'C', CurBack,   'r')
  UnselFore = if(type('UnselFore') == 'C', UnselFore, 'n')
  UnselBack = if(type('UnselBack') == 'C', UnselBack, 'w')
priv UnselGet, CurGet, StdColor
  StdColor  = StdFore + '/' + StdBack
  CurGet  = ',' + CurFore + '/' + CurBack
  UnselGet = ',,,' + UnselFore + '/' + UnselBack
  set color to (StdColor + CurGet + UnselGet)
return ''

func HELP_LINE
  COLORS('gr+', 'bg')
  @ 24, 0 clear
  @ 24, 0            say 'Esc'
  COLORS('n', 'bg')
  @ row(), col()     say '=Quit'
  COLORS('gr+', 'bg')
  @ row(), col() + 1 say chr(24)
  COLORS('n', 'bg')
  @ row(), col()     say '=Up'
  COLORS('gr+', 'bg')
  @ row(), col() + 1 say chr(25)
  COLORS('n', 'bg')
  @ row(), col()     say '=Down'
  COLORS('gr+', 'bg')
  @ row(), col() + 1 say chr(27)
  COLORS('n', 'bg')
  @ row(), col()     say '=Left'
  COLORS('gr+', 'bg')
  @ row(), col() + 1 say chr(26)
  COLORS('n', 'bg')
  @ row(), col()     say '=Right'
  COLORS('gr+', 'bg')
  @ row(), col() + 1 say 'F1'
  COLORS('n', 'bg')
  @ row(), col()     say '=Text'
  COLORS('gr+', 'bg')
  @ row(), col() + 1 say 'F2'
  COLORS('n', 'bg')
  @ row(), col()     say '=Back'
  COLORS()
return ''

func SHOW_NAME
para Text, Back
priv Attr, Row, Col, ColorStr
  attr = setcolor()
  Row  = row()
  Col  = col()
  COLORS('gr+', 'bg')
  ColorStr = COLOR_NAME(Text) + ' on ' + COLOR_NAME(Back)
  @ 24, 55 say ColorStr + replicate(' ', 25 - len(ColorStr))
  setcolor(attr)
  @ Row, Col say ''
return ''

func COLOR_NAME
para SomeColor
priv  NameArray[16]
  NameArray[ 1] = 'Black'
  NameArray[ 2] = 'Blue'
  NameArray[ 3] = 'Green'
  NameArray[ 4] = 'Cyan'
  NameArray[ 5] = 'Red'
  NameArray[ 6] = 'Magenta'
  NameArray[ 7] = 'Brown'
  NameArray[ 8] = 'White'
  NameArray[ 9] = 'Gray'
  NameArray[10] = 'Bright Blue'
  NameArray[11] = 'Bright Green'
  NameArray[12] = 'Bright Cyan'
  NameArray[13] = 'Bright Red'
  NameArray[14] = 'Bright Magenta'
  NameArray[15] = 'Yellow'
  NameArray[16] = 'Bright White'
return NameArray[SomeColor + 1]

