* Program..: Cross Tabulations for Clipper
* Author...: CARL G. SLUTTER
* Date.....: August 31, 1986
* Notice...: Copyright (c) 1986, CARL G. SLUTTER, All Rights Reserved
* Notes....: Requires Winter 85 version of Clipper as it uses functions
*            contained in the "Extended libraries supplied with Clipper.
*            As written, the program is limited to a maximum of 6 columns 
*            for reasons relating to screen display.
clear
clear all
*public buffer_0, buffer_1, buffer_2
store " " to colmon, out
if iscolor()
*   do frame with 10,7,14,73,2,0,''
   @ 12, center("Press <C> for Color Display or <M> for Mono Display") ;
say "Press <C> for Color Display or <M> for Mono Display" get colmon ;
picture"!" valid(colmon $ "CM")
read
   if colmon = "C"
      set color to GR+/B,W+/R,B
   endif && colmon = c
endif && iscolor
clear
*do frame with 10,7,14,73,2,0,''
@ 12, center("Send Output to <S>creen or <P>rinter?") say ;
"Send Output to <S>creen or <P>rinter?" get out picture "!" ;
valid(out $ "PS")
read
if out = "P"
   prnt = .t.
   do while .not. isprinter()
      clear
      ?? chr(7)
*      do frame with 10,7,14,73,2,0,''
      @ 12, center("Check Printer") say "Check Printer"
      @ 23, 0 clear
      wait
   enddo && while not printer
else
   prnt = .f.
endif && out = p
clear
title_1 = "Cross Tabulations"
store space(30) to title_2, title_3
do while .t.
store space(8) to db
*   do frame with 1,0,5,79,3,0,''
   @ 3, 3 say "Enter name of data base to use" get db picture "@!"
   read
   dbfile = trim(db) + ".DBF"
   if .not. file("&dbfile")
     clear
     ?? chr(7)
*     do frame with 10,5,16,75,2,0,''
     @ 12, center("File does not exist") say "File does not exist"
     @ 14, center("Press <Enter> to try again.  Any other key to terminate.") ;
say "Press <Enter> to try again.  Any other key to terminate."
     key = inkey(0)
        if key = 13
           clear
           loop
        else
           quit
        endif && key = 13
    else
       exit
    endif && file = dbfile
enddo
use &dbfile
clear
*do frame with 5,0,11,79,3,0,"Data Base is &dbfile"
@ 7, 3 say "Enter Title for Columns" get title_3 picture "@!"
@ 9, 3 say "Enter Title for Rows   " get title_2 picture "@!"
read
clear
*do frame with 1,0,3,79,2,0,''
fra =chr(201)+chr(205)+chr(187)+chr(186)+chr(188)+chr(205)+chr(200)+chr(186)
@ 1,0,3,79 box fra
@ 2, center("Limit Cross Tabulation to 6 Columns") ;
say "Limit Cross Tabulation to 6 Columns"
store 0 to colno
*count = 0
do while .t.
   row = 7
   @ 4, 0 clear
*   if count = 1
*      do rest_scr with 0
*   else
*      do frame with 5,0,15,79,3,0, " V J Consulting "
*      do save_scr with 0
*      count = 1
*   endif && count = 1
   colno = colno + 1
      if colno > 6
         clear
         ?? chr(7)
         @ 12, center("This Program is Limited to 6 Columns") ;
say "This Program is Limited to 6 Columns"
         @ 23, 0 clear
         wait
         cno = 6
         exit
      endif && colno > 6
   store "ctitle" + ltrim(str(colno)) to frst
   store "cfld" + ltrim(str(colno)) to scnd
   store "ccolmn" + ltrim(str(colno)) to trd
   store space(6) to &frst 
   store space(20) to &scnd
   store colno to &trd 
   @ row, 3 say "Enter Title of Column" get &frst picture "@!"
   @ row + 2, 3 say "Enter Data Base Field Specification" get &scnd picture "@!"
   store " " to doit
   if colmon = "M"
      set color to W+/
   endif && colmon = m
   @ row + 4, center("Please VERIFY entries in above fields") say ;
"Please VERIFY entries in above fields"
   if colmon = "M"
      set color to
   endif && colmon = m
   @ row + 6, 3 say "Press <C>ontinue or <E>xit" get doit picture "!" ;
valid(doit $ "CE")
   read
   if doit = "E"
         clear 
         store colno to cno
         doit = " "
         exit
   endif && doit = e
doit = " "
enddo
store 0 to rowno
do while .t.
*   count = 0
   row = 7
   @ 4, 0 clear
*   if count = 1
*      do rest_scr with 1
*   else
*      do frame with 5,0,15,79,3,0," V J Consulting "
*      do save_scr with 1
*      count = 1
*   endif && count = 1
   rowno = rowno + 1
   store "rtitle" + ltrim(str(rowno)) to frst
   store "rfld" + ltrim(str(rowno)) to scnd
   store "rcolmn" + ltrim(str(rowno)) to trd
   store space(9) to &frst 
   store space(20) to &scnd
   store rowno to &trd 
   @ row, 3 say "Enter Title of Row" get &frst picture "@!"
   @ row + 2, 3 say "Enter Data Base Field Specification" ;
get &scnd picture "@!" 
   store " " to doit
   if colmon = "M"
      set color to W+/
   endif && colmon = m
   @ row + 4, center("Please VERIFY entries in above fields") say ;
"Please VERIFY entries in above fields"
   if colmon = "M"
      set color to
   endif && colmon = m
   @ row + 6, 5 say "Press <C>ontinue or <E>xit" get doit picture "!" ;
valid(doit $ "CE")
   read
      if doit = "E"
         clear 
         store rowno to rno
         clear
         doit = " "
         exit
      endif && doit = E
   doit = " "
enddo
*do frame with 0,0,23,79,3,0," V J Consulting "
@ 8, center("Cross Tabulations Being Made") say  "Cross Tabulations Being Made"
if colmon = "C"
   set color to GR+*/B,W+/R,B
else
   set color to w*/
endif && colmon = c
@ 16, center("Please Wait") say "Please Wait"
if colmon = "C"
   set color to GR+/B,W+/R,B
else 
   set color to
endif && colmon = c
@ 24,0 say""
set console off
*Count for cross tabulations
qq = rno * cno
uu = 1
dd = 1
for aa = 1 to qq
store uu to uno
store dd to dos
store space(20) to rcount,ccount
store space(40) to criteria
store "rfld"+ltrim(str(uno)) to rcount
store "cfld"+ltrim(str(dos)) to ccount
criteria = alltrim(&ccount) + ' .and. ' + alltrim(&rcount)
store "mem" + ltrim(str(aa)) to mtemp
count for &criteria to _temp
&mtemp = _temp
dd = dd + 1
if dd <= cno
   uu = uu
   dd = dd
else
   uu = uu + 1
   dd = 1
endif
next
*Get row and column totals
for i = 1 to rno
   store "rowtot"+ltrim(str(i)) to temp
   store "rfld"+ltrim(str(i)) to mtemp
   criteria = &mtemp
   count for &criteria to _temp
   &temp = _temp
next
for i = 1 to cno
   store "coltot" + ltrim(str(i)) to temp
   store 0 to &temp
next
for j = 1 to cno
store space(40) to criteria
   for k = 1 to rno
      store "coltot"+ltrim(str(j))+ltrim(str(k)) to temp
      store "cfld"+ltrim(str(j)) to mtemp1
      store "rfld"+ltrim(str(k)) to mtemp2
      criteria = alltrim(&mtemp1)+' .and. '+alltrim(&mtemp2)
      count for &criteria to _temp
      &temp = _temp
   next
next
for i = 1 to cno
   store "coltot"+ltrim(str(i)) to hold1
   for j = 1 to rno
      store "coltot"+ltrim(str(i))+ltrim(str(j)) to hold2
      &hold1 = &hold1 + &hold2
   next
next
div = 0
for i = 1 to rno
   store "rowtot" + ltrim(str(i)) to divtemp
   div = div + &divtemp
next
*Set up and display screen
vert1=15
vert2=23
vert3=31
vert4=39
vert5=47
vert6=55
vert7=63
vert8=71
row = 1
set console on
clear
if prnt
   set device to print
endif && prnt
@ row, center(title_1) say title_1
@ row +2, 1 say title_2
@ row +2, center(trim(title_3)) say title_3
@ row +3, 1 say replicate("-",len(trim(title_2)))
@ row +3, center(trim(title_3)) say replicate("-",len(trim(title_3)))
for i = 1 to cno
   store "vert"+ltrim(str(i)) to temp
   store "ctitle" + ltrim(str(i)) to title
   @ row + 4, &temp say rjust(8,&title)
next
store "vert"+ltrim(str(cno + 1)) to temp
row_total = &temp
@ row + 4, &temp say "Row Tot"
store "vert"+ltrim(str(cno + 2)) to temp
row_pct = &temp
@ row + 4, &temp say " Row %"
l=1
tot = 0
for i = 1 to rno
   row = i + 6
   store "rtitle"+ltrim(str(i)) to rtemp
   store "rowtot"+ltrim(str(i)) to _total
   @ row, 3 say trim(&rtemp)
   for k = 1 to cno
      store "vert"+ltrim(str(k)) to ctemp
      store "mem"+ltrim(str(l)) to mtemp
      @ row, &ctemp say rjust(4,alltrim(str(&mtemp)))
      l = l + 1
   next
   @ row, row_total say rjust(4,alltrim(str(&_total)))
   if div > 0
      @ row, row_pct say rjust(6,alltrim(str((&_total/div)*100))) 
      tot = tot + (&_total/div)*100
   else
      @ row, row_pct say " NA"
   endif && div > 0
next
row = rno + 8
@ row, 3 say "Col. Tot."
for i = 1 to cno
   store "vert" + ltrim(str(i)) to ctemp   
   store "coltot" + ltrim(str(i)) to _coltot
   @ row, &ctemp say rjust(4,alltrim(str(&_coltot)))
next
@ row, row_total say rjust(4,alltrim(str(div)))
@ row + 2, 3 say "Col. %"
for i = 1 to cno
   store "vert" + ltrim(str(i)) to ctemp   
   store "coltot" + ltrim(str(i)) to _coltot
   if div > 0
      @ row + 2, &ctemp say rjust(6,alltrim(str((&_coltot/div)*100)))
   else
      @ row + 2, &ctemp say " NA"
   endif && div > 0
next
@ row + 2, row_pct say rjust(6,alltrim(str(tot)))
if prnt
   set device to screen
   eject
   clear all
   return
endif && prnt
@ 23, 0 clear
wait""
clear all 

Function rjust
Parameters fldwidth, string
store space(fldwidth) to rjuststr
rj = fldwidth - len(string)
rjuststr = space(rj) + "&string"
return(rjuststr)


