* CPARDEMO.PRG
*
* Terry Hackett
* Dictate, Inc
* RR1, Box 750
* Oxford, ME 04270    (207) 539-8477

SET SCOREBOARD OFF
CLEAR SCREEN

@0,15 SAY "C Parser and Tokenizer Function Demo/Test Program"

pText    = "This is some sample text for testing the parser, cparse()."
pDelims  = ""
pMinStr  = 3
pStart   = 1

tText    = "This is some sample text for testing the tokenizer, ctoken()"
tDelims  = "ô"
tStart   = 1

DO WHILE .T.
   * Pop multiple exploding menus with sound and animation.

   @2,20 SAY "Press 'P' to Thrash on the Parser"
   @3,20 SAY "Press 'T' to Thrash on the Tokenizer"
   @5,20 SAY "Your Selection? "
   choi = UPPER(CHR( INKEY(0) ))

   @1,0 CLEAR TO 24,79

   IF choi == "P"
      *-------------------------------*
      * CPARSE() PARSER TEST
      *-------------------------------*

      pText   = PAD( pText, 250 )
      pDelims = PAD( pDelims, 60 )

      @2,20 SAY                     "C Parser Test"
      @3,0  SAY "Enter some test text to parse out  (GET scrolls to 250 chars)..."
      @4,0  GET pText PICT "@KS80"

      @6,2  SAY   "The default delimiters will return ONLY alpha or alpha with"
      @7,0  SAY "embedded apostrophes.  Parser returns ONLY ASCII 32 - 126."
      @8,0  SAY "Enter the delimiter string, or leave blank for defaults..."
      @9,5  GET pDelims

      @11,2 SAY   "The minimum return string length defaults to 3, i.e. the "
      @12,0 SAY "parser will continue until a 3-char or longer word is found."
      @13,0 SAY "Enter the minimum return string length: " GET pMinStr PICT "999" VALID (pMinStr > 0)

      @15,2 SAY   "The parser should be initialized whenever starting a new block"
      @16,0 SAY "of text.  It will default to start at the first char.  This "
      @17,0 SAY "feature can also be used to jump around a block of text without"
      @18,0 SAY "parsing every character."
      @19,0 SAY "Enter parser starting position:" GET pStart PICT "999" VALID (pStart > 0)

      READ
      IF LASTKEY() == 27
         EXIT
      ENDIF

      pDelims = ALLTRIM(pDelims)
      pText   = ALLTRIM(pText)

      InitCparse(pStart)               && Init parser starting position.

      @5,0 CLEAR TO 24,79
      @5,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890123456789"
      R = 6
      DO WHILE .T.
         retword = cparse( @pText, pDelims, pMinstr )
         @R,0 SAY "->"+retword+"<-"

         * Demo the position functions, used for SUBS(), STUFF(), etc.
         @R,25 SAY "Start Pos:"  + LTRIM(STR( cp_StPos()  ))
         @R,40 SAY "Word Start:" + LTRIM(STR( cp_StWord() ))
         @R,58 SAY "End Pos:"    + LTRIM(STR( cp_EndPos() ))

         IF cp_EndPos() == 1
            * Hit end of string and auto-reset to 1st char.
            ?? " Note Reset"
         ENDIF

         R = R+1

         INKEY(0)

         IF EMPTY( retword )
            ?
            ? "This loop exits on a null '' string return, Press a Key..."
            INKEY(0)
            EXIT
         ENDIF

         IF R > 24
            R = 6
            @6,0 CLEAR TO 24,79
         ENDIF
      ENDDO

      @5,0 CLEAR TO 24,79

      @6,0 SAY "Now for the fun part - speed testing.  The test text entered"
      @7,0 SAY "will be REPLICATEd 100 times.    Press a key when ready..."
      INKEY(0)

      block = REPLICATE( pText, 100 )
      wcnt  = 0
      @9,0 SAY "Time test for " + LTRIM(STR(LEN(block))) + " characters..."

      @11,0 SAY ">"
      InitCparse(1)                    && Reset to first char.
      SET CURSOR OFF

      @13,0 SAY TIME() + " ...Start"
      DO WHILE .T.
         retword = cparse( block, pDelims, pMinStr )
         IF EMPTY( retword )
            EXIT
         ENDIF
         wcnt = wcnt + 1
         @11,1 SAY retword + "                   "     && Spaces just to clear.
      ENDDO
      @14,0 SAY TIME() + " ...Done  (Note: faster without @..SAY display)"

      @15,0 SAY LTRIM(STR(wcnt)) + " words."
      INKEY(0)
      SET CURSOR ON

   ELSEIF choi == "T"
      *-------------------------------*
      * CTOKEN() TOKENIZER TEST
      *-------------------------------*
      tText   = PAD( tText, 250 )
      tDelims = PAD( tDelims, 2 )

      @2,20 SAY                     "C Tokenizer Test"
      @3,0  SAY "Enter some test text to extract tokens from (GET scrolls to 250 chars)..."
      @4,0  GET tText PICT "@KS80"

      @6,2  SAY   "The default delimiters for the tokenizer are 'ô', chr(195)"
      @7,0  SAY "for the L delim and chr(180) for the R delim.  Must be (at least) 2 chars."
      @8,0  SAY "Enter the delimiter string, or leave blank for defaults..."
      @9,5  GET tDelims

      @11,2 SAY   "There is no minimum return length for the tokenizer, and"
      @12,0 SAY "any ASCII char is valid."

      @15,2 SAY   "The tokenizer should be initialized whenever starting a new block"
      @16,0 SAY "of text.  It will default to start at the first char.  This "
      @17,0 SAY "feature can also be used to jump around a block of text without"
      @18,0 SAY "parsing every character."
      @19,0 SAY "Enter tokenizer starting position:" GET tStart PICT "999" VALID (tStart > 0)

      READ
      IF LASTKEY() == 27
         EXIT
      ENDIF

      tDelims = ALLTRIM(tDelims)
      tText   = ALLTRIM(tText)

      InitCtoken(tStart)               && Init parser starting position.

      @5,0 CLEAR TO 24,79
      @5,0 SAY "1234567890123456789012345678901234567890123456789012345678901234567890123456789"
      R = 6
      DO WHILE .T.
         retword = ctoken( @tText, tDelims )
         @R,0 SAY "->"+retword+"<-"

         * Demo the position functions, used for SUBS(), STUFF(), etc.
         @R,25 SAY "Start Pos:"   + LTRIM(STR( ct_StPos()   ))
         @R,40 SAY "Token Start:" + LTRIM(STR( ct_StToken() ))
         @R,58 SAY "End Pos:"     + LTRIM(STR( ct_EndPos()  ))

         IF ct_EndPos() == 1
            * Hit end of string and auto-reset to 1st char.
            ?? " Note Reset"
         ENDIF

         R = R+1

         INKEY(0)

         IF EMPTY( retword )
            ?
            ? "This loop exits on a null '' string return, Press a Key..."
            INKEY(0)
            EXIT
         ENDIF

         IF R > 24
            R = 6
            @6,0 CLEAR TO 24,79
         ENDIF
      ENDDO

      @5,0 CLEAR TO 24,79

      @6,0 SAY "Now for the fun part - speed testing.  The test text entered"
      @7,0 SAY "will be REPLICATEd 100 times.    Press a key when ready..."
      INKEY(0)

      block = REPLICATE( tText, 100 )
      wcnt  = 0
      @9,0 SAY "Time test for " + LTRIM(STR(LEN(block))) + " characters..."

      @11,0 SAY ">"
      InitCtoken(1)
      SET CURSOR OFF

      @13,0 SAY TIME() + " ...Start"
      DO WHILE .T.
         retword = ctoken( @block, tDelims )
         IF EMPTY( retword )
            EXIT
         ENDIF
         wcnt = wcnt + 1
         @11,1 SAY retword + "                   "     && Spaces just to clear.
      ENDDO
      @14,0 SAY TIME() + " ...Done  (Note: faster without @..SAY display)"

      @15,0 SAY LTRIM(STR(wcnt)) + " tokens."
      INKEY(0)
      SET CURSOR ON

   ELSE
      *-------------------------------*
      * EXIT ENDLESS LOOP
      *-------------------------------*
      EXIT
   ENDIF

   @1,0 CLEAR TO 24,79
ENDDO

?
?
? "Crash test: cparse() missing all parameters"
cparse()
?
? "Didn't crash cparse() if we got this far..."
?
?
? "Crash test: ctoken() missing all parameters"
ctoken()
?
? "Didn't crash ctoken() if we got this far..."
?

byebye = "Have fun and HAPPY CLIPPING"
InitCparse(1)

? "Last cparse() test...  Strike a key..."
?
INKEY(0)
DO WHILE .T.
   retword = cparse( @byebye )
   IF EMPTY(retword)
      EXIT
   ENDIF
   ?? retword + " "
ENDDO
?


