** Message capture from RIME's Clipper Conference.
*
*
*    Date: 11-06-91 (19:28)      Clipper Number: 6967
*      To: ALL
*    From: FRANK KJAER                     Read: 11-11-91 (06:16)
*    Subj: FILES=N & SET CLIPPER=FN
*
*    I've seen that some of us have problems with number of files
*    for their Clipper-programs.
*
*    -    You have seen the charming message "DOS error 4" ? ...
*
*
*
*    Function to Count number of free Dos-Handles
*    ********************************************
*
*    This function is useful in any multitasking environment, and when
*    you want to Swap to/from other programs. You never know how many
*    files which already are opened by other programs, or if there are
*    enough FILES=<number> in the Config.Sys file for your
*    Clipper-program.
*
*    Maybe you have forgotten set Dos-Environment variable
*    SET CLIPPER=F<number> ?
*
*    Use this function to determine how many files you can open right
*    now, terminate your program if it's not enough, and/or give the
*    proper instructions. Like this :
*
*      IF Count_Hdl()<30 && Its less than 30 available file-handles
*         ?
*         ? 'There is just '+STR(Count_Hdl(),3)+' file-handles left ...'
*         ?
*         ? 'This program requires at least 30 handles, please check'
*         ? 'your Config.Sys file and the statement FILES=<number>'
*         ?
*         QUIT
*      ENDI
*
*
*    If you find this function useful for your needs, I'll be happy if you
*    drop me a message.
*
*    Regards from Frank Kjaer, Oslo - Norway.  Fax. + 47.2.83 69 63
*
*    * - - *

FUNCTION COUNT_HDL  && Count number of free Dos-Handles
*
*   No parameters, returns Integer value of free Dos-Handles
*
*   Written by Frank Kjaer, Oslo - Norway. Sent to you via Thunderball
*   Cave BBS, Oslo - Norway. ( +.47.2.56 70 18 )


PRIVATE Hdl_Cnt,Ret_Var && Declare count-variable and Return-variable

PRIVATE Hdl_Tst[256]   && Declare Array to hold open Dos-Handles
AFILL(Hdl_Tst,0)       && Fill all array elements with Zeros

FOR Hdl_Cnt=1 TO 255  && Loop, Maximum 255 tries to open handles

   Hdl_Tst[Hdl_Cnt]=FOPEN('\NUL',0)  && Try to open New R/O handle on
                                     && NUL-device, save file-handle
                                     && in array.

   IF Hdl_Tst[Hdl_Cnt]<4  && Couldn't open more handles,
                          && exit loop

      Hdl_Tst[Hdl_Cnt]=0  && Just in case, reset this element
                          && to Empty()
      EXIT

   ENDIF

NEXT

Ret_Var=Hdl_Cnt-1  && Number of _free_ Dos-handles, the last
                   && try was unsuccesful, therefore Hdl_Cnt-1

Hdl_Cnt=1          && Start next loop at element 1, Hdl_Tst[1]

DO WHILE ! EMPTY(Hdl_Tst[Hdl_Cnt])   && Loop until Array-element is
                                     && Empty()

   FCLOSE(Hdl_Tst[Hdl_Cnt]) && Close all handles which where opened
                            && by this function

   Hdl_Cnt=Hdl_Cnt+1  && Don't worry, there will always be one
                      && Empty() element, Hdl_Tst[256]
ENDDO

RETURN Ret_Var  && Return value to calling function/procedure

* - - *
                                                       
*    PCRelay:CAVE -> #334 RelayNet (tm)
*    4.10            Thunderball Cave,Norway HUB 472567018 HST/V42
*
