*:*********************************************************************
*:
*:        Program: COPYIT.PRG
*:
*:         System: Copyit
*:         Author: Tom Leylan 74216,3212
*:      Copyright (c) 1988, The Leylan Factor
*:  Last modified: 03/15/88     11:30
*:
*:  Procs & Fncts: COPY_ALL()
*:               : COPY_TO()
*:               : MASK()
*:               : FILE_NAM()
*:               : FILE_EXT()
*:
*:          Calls: COPY_ALL()     (function  in COPYIT.PRG)
*:
*:      Documented 03/18/88 at 15:21                SNAP!  version 3.12a
*:*********************************************************************
CLEAR
@ 01,00 SAY 'COPY_IT DEMO'
@ 14,00 SAY "I'm not parsing the file name so you better enter valid file names"
@ 15,00 SAY "and if you use wildcards they have to be of equal length"

@ 05,00 SAY STR(copy_all('COPY*.PRG','DONE*.TST'))+' FILES COPIED'

PRIVATE l_one, l_two
l_one = SPACE(12)
l_two = l_one

@ 07,00 SAY 'Enter File to Copy From : ' GET l_one PICT '@!'
@ 08,00 SAY 'Enter File to Copy To   : ' GET l_two PICT '@!'
READ

@ 10,00 SAY STR(copy_all(l_one,l_two))+' FILES COPIED'

@ 20,00

RETURN

*!*********************************************************************
*!
*!       Function: COPY_ALL()
*!
*!      Called by: COPYIT.PRG                    
*!
*!          Calls: COPY_TO()      (function  in COPYIT.PRG)
*!
*!*********************************************************************
FUNCTION copy_all
PARAMETERS l_fr, l_to
PRIVATE l_max, l_cnt, l_filef, l_filet
l_max = Adir(l_fr)
PRIVATE a_files[L_MAX]
Adir(l_fr,a_files)
l_cnt = 1
FOR l_cnt = 1 TO l_max STEP 1
  l_filef = a_files[L_CNT]
  l_filet = copy_to(l_filef,l_to)
  COPY FILE &l_filef TO &l_filet
NEXT
RETURN(l_max)

*!*********************************************************************
*!
*!       Function: COPY_TO()
*!
*!      Called by: COPY_ALL()     (function  in COPYIT.PRG)
*!
*!          Calls: MASK()         (function  in COPYIT.PRG)
*!               : FILE_NAM()     (function  in COPYIT.PRG)
*!               : FILE_EXT()     (function  in COPYIT.PRG)
*!
*!*********************************************************************
FUNCTION copy_to
PARAMETERS l_file, l_mask
l_name = mask(file_nam(l_file), file_nam(l_mask))
l_extn = mask(file_ext(l_file), file_ext(l_mask))
RETURN(l_name + '.' + l_extn)

*!*********************************************************************
*!
*!       Function: MASK()
*!
*!      Called by: COPY_TO()      (function  in COPYIT.PRG)
*!
*!*********************************************************************
FUNCTION mask
PARAMETERS l_name, l_mask
PRIVATE l_max, l_temp, l_cnt, l_char, l_to
l_max  = LEN(l_mask)
l_temp = ''
l_cnt  = 1
FOR l_cnt = 1 TO l_max STEP 1
  l_char = SUBS(l_mask,l_cnt,1)
  l_temp = l_temp+IIF(l_char='*','????????',l_char)
NEXT
l_temp = SUBS(l_temp,1,LEN(l_name))

l_max = LEN(l_temp)
l_to  = ''
l_cnt = 1
FOR l_cnt = 1 TO l_max STEP 1
  l_char = SUBS(l_temp,l_cnt,1)
  l_to = l_to+IIF(l_char='?',SUBS(l_name,l_cnt,1),l_char)
NEXT
RETURN(l_to)

*!*********************************************************************
*!
*!       Function: FILE_NAM()
*!
*!      Called by: COPY_TO()      (function  in COPYIT.PRG)
*!
*!*********************************************************************
FUNCTION file_nam
PARAMETERS l_file
PRIVATE l_dot
l_file = LTRIM(TRIM(l_file))
l_dot = AT('.',l_file)
l_dot = IIF(l_dot=0,LEN(l_file),l_dot-1)
RETURN(TRIM(SUBS(l_file,1,l_dot)))

*!*********************************************************************
*!
*!       Function: FILE_EXT()
*!
*!      Called by: COPY_TO()      (function  in COPYIT.PRG)
*!
*!*********************************************************************
FUNCTION file_ext
PARAMETERS l_file
PRIVATE l_dot
l_file = LTRIM(TRIM(l_file))
l_dot = AT('.',l_file)
l_dot = IIF(l_dot=0,l_dot,l_dot+1)
RETURN(LTRIM(SUBS(l_file,l_dot)))

*: EOF: COPYIT.PRG
