* PROGRAM: CONDNTX.PRG by Bill Osolinski (518-237-0433)
* Example of conditional index using a UDF.
*
* The keyexpr() UDF returns only those keys that meet the condition.
* One additional key is created because an EOF occurs before the index
* operation is complete.  Before this index can be used, the first key
* on the first page of index keys must be removed.  This is accomplished
* by the fixfirst() function.  Any comments or enhancements to this
* program would be greatly appreciated.


* CONSTANTS
  dbfname = 'CUSTMAST'
  ntxname = 'CUR_BAL'
  condition = 'ARTOT > 0'
  key = 'CNUM'

* PROCESSING
  use &dbfname
  index on keyexpr() to &ntxname
  close
  cleanup()
  return

* FUNCTIONS
  function keyexpr
  do while .not. (&condition .or. eof())
    skip
  enddo
  return(&key)

  function cleanup
  private size, buffer, source, shandle, keylen, compkey, offset, newkeylen, oldkeylen, remainder
  size = 1024
  buffer = space(size)
  source = ntxname + ".NTX"
  newkeylen = len(key)
  oldkeylen = len('KEYEXPER()')
  shandle = fopen(source,2)
  fseek(shandle, 0)
  fread(shandle, @buffer, size)
  keylen = bin2i(substr(buffer,15,1))
  compkey = bin2i(substr(buffer,13,1))
  offset = bin2i(substr(buffer,21,1))
  offset = offset * 4 + 4
  do case
    case newkeylen < oldkeylen
      key = key + replicate(chr(0),oldkeylen-newkeylen)
      buffer = stuff(buffer, 23, oldkeylen, key)
    case newkeylen < oldkeylen
      x = oldkeylen - newkeylen
      buffer = stuff(buffer, 23, oldkeylen-newkeylen, key)
    otherwise
      buffer = stuff(buffer, 23, oldkeylen, key)
  endcase
  fseek(shandle, 0)
  fwrite(shandle, buffer, size)
  fread(shandle, @buffer, size)
  pagekeys = bin2i(substr(buffer,1,1))
  pagekeys = pagekeys - 1
  buffer = stuff(buffer, 1, 2, i2bin(pagekeys))
  buffer = stuff(buffer, offset+1, compkey, '')
  offset = offset + (pagekeys * compkey) + 1
  remainder = size - offset
  buffer = stuff(buffer, offset, 0, replicate(chr(0),remainder))
  fseek(shandle, size, 0)
  fwrite(shandle, buffer, size)
  fclose(shandle)
  return(.T.)


* EOF: CONDNTX.PRG
