
************************************************
**  Program:  Condex
**  Author :  Michael Dwyer
**  Date   :  04/01/90
**  Purpose:  Demonstrates Conditional Indexing
**  (c) 1990 Custom Microware
************************************************
**  Notes:  Creates A Database Called DATA.DBF With 1000 Records
**          Of These, The Very First And The Very Last Record
**          Have Account Types = "@".  Browse For This Type
**          To See The Speed Advantage Of Contitional Indexing.
**
**  Requires: Clipper.Lib and Extend.lib
**  Calls   : BROWSE().  You May Substitute DBEDIT() If You Wish




CLEAR
if .not. file("DATA.DBF")
   @ 0,0 TO 24,79 DOUBLE
   @ 13,25 SAY "One Moment, Please..."
   *** CREATE DATA.DBF ON FLY
   CREATE $TEMP
   APPEND BLANK
   REPLACE FIELD_NAME WITH "ACCTNUM",FIELD_TYPE WITH "N",FIELD_LEN WITH 4,FIELD_DEC WITH 0
   APPEND BLANK
   REPLACE FIELD_NAME WITH "ACCTTYPE",FIELD_TYPE WITH "C",FIELD_LEN WITH 1,FIELD_DEC WITH 0
   USE
   CREATE DATA FROM $TEMP
   ERASE $TEMP.DBF
   USE DATA
   *** LOAD THE DATABASE WITH BOGUS DATA
   TYPESTR= "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   TYPECNT= 1
   FOR X= 1 TO 1000
      APPEND BLANK
      REPLACE ACCTNUM WITH X
      REPLACE ACCTTYPE WITH SUBSTR(TYPESTR,TYPECNT,1)
      TYPECNT= IIF(TYPECNT= LEN(TYPESTR),1,TYPECNT+1)
   NEXT
   ** JUST FOR FUN, REPLACE FIRST AND LAST ACCTTYPE WITH A '@' TO SHOW SPEED
   GO TOP
   REPLACE ACCTTYPE WITH "@"
   GO BOTT
   REPLACE ACCTTYPE WITH "@"
   GO TOP
ELSE
   USE DATA
ENDIF

CLEAR

** MAIN PROGRAM LOOP
DO WHILE .T.
   CLEAR
   THETYPE= " "

   @ 24,25 SAY "PRESS <ESC> TO EXIT"
   @ 10,50 say "(A-Z, @)"
   @ 10,10 SAY "ACCOUNT TYPE: " GET THETYPE PICTURE "!"
   READ
   IF LASTKEY()= 27
      EXIT
   ENDIF
   ** DEFINE CONDITIONAL INDEX VARIABLES
   CONDITION    = [ACCTTYPE= "&THETYPE"]   && DEFINE THE CONDITION IN A MACRO
   KEYVAL       = [ACCTNUM]                && DEFINE THE INDEX KEY EXPRESSION
   _CIEVAL      = .T.                      && LOGICAL VARIABLE.
   *                                       &&   .T. WHEN CREATING INDEX
   *                                       &&   .F. OR UNDEF OTHERWISE
   @ 24,0
   @ 24,30 SAY "INDEXING FILE."

   *** HERE'S THE CALL TO THE CONDITIONAL INDEX FUNCTION ***
   INDEX ON CONDINDX(CONDITION,KEYVAL) TO $TEMP
   _CIEVAL = .F.                           && RESET TO .F. AFTER INDEX CREATED

   SET FILTER TO &CONDITION                && NEEDED TO FILTER OUT FIRST RECORD
   GO TOP
   BROWSE()

ENDDO
ERASE $TEMP.NTX


********************
FUNCTION CondIndx
********************
PARAMETERS Condition,Keyval
if type("_CIEVAL")<> "U"
  if _CIEVAL
    DO WHILE ! (&condition) .AND. RECNO() < LASTREC()
       GOTO RECNO()+1
    ENDDO
  endif
endif
RETURN &keyval


