*******************************************************************
* Program: COM_TEST.prg						  *
* Author : Tom Chang						  *
* Date   : July 19, 1989					  *
* Version: Clipper Summer '87					  *
* Library: Clipper, Extend, CT1					  *
* Note(s): Serial port communication using "Clipper Tools One".   *
*          Hardware Handshaking using CTS and RTS to control.     *
*          Copyright (c) 1989 Nantucket Corp. All rights Reserved.*
*******************************************************************
SET SCOREBOARD OFF
SET CURSOR OFF
SET WRAP ON
SET KEY 250 TO BUFFEREAD                    &&  Use for COM_KEY()
PUBLIC PORT,BAUD,PARITY,WORDBIT,STOPBIT,BUFFNUM,HANDSHAKE,COMINTOK
STORE .F. TO HANDSHAKE,COMINTOK
STORE 1 TO STOPBIT, PORT
STORE 10000 TO BUFFNUM
BAUD = 9600
PARITY = "N"
WORDBIT = 8
WBOARD(3,0,22,79)
SYSCOLOR(1)
CLEAR
STATUSFRM()
STATUSMSG()
@ 2,0 SAY REPL(CHR(196),80)
DO WHILE .T.
    @ 1, 2 PROMPT "SETUP"
    @ 1,12 PROMPT "TX/RV"
    @ 1,21 PROMPT "CHAT"
    @ 1,28 PROMPT "EXIT"
    MENU TO CHOICE
    DO CASE
        CASE CHOICE = 1
            DO SETWIN
            STATUSMSG()
        CASE CHOICE = 2
            DO TXRV
        CASE CHOICE = 3
            DO CHWIN
        CASE CHOICE = 4
            CLEAR
            RETURN
    ENDCASE
ENDDO
RETURN

**************
*   SETWIN   *
**************
PROCEDURE SETWIN
    SET CURSOR ON
    WIN1 = WOPEN(4,1,12,19)
    WSELECT(WIN1)
    WBOX()
    @ 0,2 SAY "PORT  :" GET PORT    PICT "9"  VALID (PORT=1 .OR.;
PORT=2)
    @ 1,2 SAY "BAUD  :" GET BAUD    PICT "9999"
    @ 2,2 SAY "PARITY:" GET PARITY  PICT "!"  VALID (PARITY$"NEO")
    @ 3,2 SAY "WORD  :" GET WORDBIT PICT "9"  VALID (WORDBIT=8;
.OR. WORDBIT=7)
    @ 4,2 SAY "STOP  :" GET STOPBIT PICT "9"  VALID (STOPBIT=1;
.OR. STOPBIT=2)
    @ 5,2 SAY "BUFF  :" GET BUFFNUM PICT '99999'
    @ 6,2 SAY "HANDSHAKE:" GET HANDSHAKE PICT "L"
    READ
    SET CURSOR OFF
    WCLOSE()
RETURN

**************
*    TXRV    *
**************
PROCEDURE TXRV
    PRIVATE SELTR,CHOOSE,WIN2,WIN2A,WIN2B
    DECLARE TXT_FILE[ADIR("*.TXT")]         &&  For selection of
    ADIR("*.TXT",TXT_FILE)                  &&  file transmission.
    WIN2 = WOPEN(4,11,7,28)
    WSELECT(WIN2)
    WBOX()
    @ 0,2 PROMPT "UpLoad File "
    @ 1,2 PROMPT "DnLoad File"
    MENU TO SELTR
    DO CASE
       CASE SELTR = 0 .OR. LASTKEY() = 27
            WCLOSE()
            RETURN
       CASE SELTR = 1                       &&  Upload
            WIN2A = WOPEN(08,08,15,23)
            WSELECT(WIN2A)
            WBOX()
            CHOOSE = ACHOICE(0,1,6,12,TXT_FILE)
            IF CHOOSE #0
               WCLOSE()
               FILETX(CHOOSE)
            ELSE
               WCLOSE()
            ENDIF
       CASE SELTR = 2                       &&  Dnload
            WIN2B = WOPEN(10,20,12,50)
            WSELECT(WIN2B)
            WBOX()
            SET CURSOR ON
            F_NAME = SPACE(8)
            @ 1,1 SAY "File name to save:" GET F_NAME;
PICT "!!!!!!!!"
            READ
            SET CURSOR OFF
            WCLOSE()
            IF !EMPTY(F_NAME)
               FILERV(F_NAME)
            ENDIF
    ENDCASE
WCLOSE()
RETURN

***************
*    CHWIN    *
***************
PROCEDURE CHWIN
    PRIVATE MSG,SENDOK,WIN3_S,WIN3_R,OLDBUFF
    OLDBUFF = BUFFNUM                       &&  Temporary change of
    BUFFNUM = 100                           &&  buffer size.
    R = 1
    C = 0
    COMOK = COM_OPEN(PORT,BUFFNUM,.T.)       
    IF COMOK = .T.                              
        STATUSMSG()
        COM_INIT(PORT,BAUD,PARITY,WORDBIT,STOPBIT)
        COM_RTS(PORT,.T.)
        COM_KEY(PORT,250)                   &&  Incoming data de-
        SET CURSOR ON                       &&  tected calls pro-
        SYSCOLOR(2)                         &&  cedure "BUFFERREAD"
        WIN3_R = WOPEN(15,1,22,78)          &&  Receive Window
        WSELECT(WIN3_R)
        WBOX("ķӺ")
        @ 0,1 SAY "<Receive>"
        WIN3_S = WOPEN(3,1,14,78)           &&  Send Window
        WSELECT(WIN3_S)
        WBOX("ķӺ")
        CLEAR
        @ 0,1 SAY "<Send>"
        @ 0,49 SAY "<Send>:Ctrl-W, <Quit>:Esc"
        DO WHILE LASTKEY() # 27             &&  ESC to quit
            MSG = SPACE(1)
            MSG = MEMOEDIT(MSG,1,1,9,75)
            SENDOK = COM_SEND(PORT,MSG)
            @ 0,8 SAY IIF(SENDOK=0,"<OK>","<NO>")
            COM_FLUSH(PORT)
            INKEY(0.1)
        ENDDO
        WACLOSE()
        SET CURSOR OFF
        SYSCOLOR(1)
    ELSE
        PORT_OK(PORT)                       &&  COM port not ready
    ENDIF
    BUFFNUM = OLDBUFF
    STATUSMSG()
    COM_KEY(PORT)
    COM_CLOSE(PORT)
RETURN

****************
*  BUFFEREAD   *
****************
PROCEDURE BUFFEREAD                         
    PRIVATE IN_MSG
    WSELECT(WIN3_R)                         
    IN_MSG = COM_READ(PORT)
    IF R = 5
        R = 1
        @ 1,0 CLEAR
    ENDIF
    @ R,C SAY IN_MSG
    C = C + LEN(IN_MSG)
    IF C > 70
        C = 0
        R = R + 1
    ENDIF
    COM_KEY(PORT,250)
    WSELECT(WIN3_S)
RETURN

**************
*   FILETX   *
**************
FUNCTION FILETX
    PARAMETER NUM
    PRIVATE FILEDATA
    FILEDATA = MEMOREAD(TXT_FILE[NUM])
    COMOK = COM_OPEN(PORT,BUFFNUM)
    IF COMOK = .T.
        COM_DTR(PORT,.T.)
        COMINTOK = LTOC(COM_INIT(PORT,BAUD,PARITY,WORDBIT,STOPBIT))
        COM_RTS(PORT,.T.)            &&  Request To Send (4)
        IF HANDSHAKE
            COM_HARD(PORT,.T.)       &&  Enable Hardware Handshake
            IF CTS_OK(5)             &&  Wait 5sec for RV response
                COMSTAWIN()          &&  Open Com Status Window
                COMSTAMSG()          &&  Show communication status
                COM_SEND(PORT,FILEDATA)
            ELSE                            
                RDY_MSG(1)                  &&  RV not ready
            ENDIF
            COM_HARD(PORT,.F.)              &&  Disable Handshaking
        ELSE                                
            COMSTAWIN()
            COMSTAMSG()
            COM_SEND(PORT,FILEDATA)
        ENDIF
        COM_FLUSH(PORT)
        INKEY(.5)
        WCLOSE()
    ELSE                                    
        PORT_OK(PORT)                       &&  COM port not ready
    ENDIF
    COM_CLOSE(PORT)
RETURN .T.

**************
*   FILERV   *
**************
FUNCTION FILERV
    PARAMETER FNAME
    PRIVATE DATAIN,DATAFILE,DATATEMP
    STORE SPACE(1) TO DATAIN,DATATEMP
    DATAFILE = ALLTRIM(FNAME)+".TXT"
    COMOK = COM_OPEN(PORT,BUFFNUM)
    IF COMOK = .T.
        COM_DTR(PORT,.T.)
        COMINTOK = LTOC(COM_INIT(PORT,BAUD,PARITY,WORDBIT,STOPBIT))
        IF HANDSHAKE
            COM_HARD(PORT,.T.)       &&  Enable Handshaking
            IF CTS_OK(5)             &&  Wait 5sec for TX send RTS
                COM_RTS(PORT,.T.)              
                COMSTAWIN()                 
                COMSTAMSG()
                INKEY(1)
                DO WHILE COM_COUNT(PORT) > 0
                   DATATEMP = COM_READ(PORT,100)
                   DATAIN = DATAIN + DATATEMP
                ENDDO
                WCLOSE()
                MEMOWRIT(DATAFILE,DATAIN)
            ELSE
                RDY_MSG(2)                  &&  TX not ready
            ENDIF
            COM_HARD(PORT,.F.)              &&  Disable handshaking
        ELSE
            COMSTAWIN()
            COMSTAMSG()
            INKEY(1)
            DO WHILE COM_COUNT(PORT) > 0
               DATATEMP = COM_READ(PORT,100)
               DATAIN = DATAIN + DATATEMP
            ENDDO
            WCLOSE()
            MEMOWRIT(DATAFILE,DATAIN)
        ENDIF
    ELSE
        PORT_OK(PORT)                       &&  COM port not ready
    ENDIF
    COM_CLOSE(PORT)
RETURN .T.

****************
*   COMSTAMSG  *
****************
FUNCTION COMSTAMSG                          &&  Show current status
    @ 0, 8 SAY "Communication  Status"
    @ 2, 1 SAY "COM OPEN : "+LTOC(COMOK)
    @ 2,16 SAY "COM INIT : "+COMINTOK
    @ 3, 1 SAY " (4) RTS : "+LTOC(COM_RTS(PORT))
    @ 3,16 SAY "  L S R  : "+NTOC(COM_LSR(PORT),2)
    @ 4, 1 SAY " (5) CTS : "+LTOC(COM_CTS(PORT))
    @ 4,16 SAY "  M C R  : "+NTOC(COM_MCR(PORT),2)
    @ 5, 1 SAY "(20) DTR : "+LTOC(COM_DTR(PORT))
    @ 5,16 SAY "  M S R  : "+NTOC(COM_MSR(PORT),2)
RETURN ('')

**************
*  COMSTAWIN *
**************
FUNCTION COMSTAWIN
    WINCOMST = WOPEN(3,42,11,78)
    WSELECT(WINCOMST)
    WBOX("͸Գ")
RETURN("")

***************
*   CTS_OK    *
***************
FUNCTION CTS_OK                             &&  Checks CTS status
    PARAMETER WAIT                          &&  a number of seconds
    PRIVATE FOREVER                         &&  while waiting for
    FOREVER =(WAIT=0)                       &&  RV or TV response.
    DO WHILE (FOREVER .OR. WAIT > 0)
        IF COM_CTS(PORT)                    &&  Hardware handshake
           RETURN(.T.)                      &&  successful if .T.
        ENDIf
        INKEY(1)
        WAIT = WAIT - 1
    ENDDO
RETURN(.F.)

**************
*   PORT_OK  *
**************
FUNCTION PORT_OK
    PARAMETER XX
    PRIVATE OLDSELWIN
    OLDSELWIN = WSELECT()
    WSELECT(0)
    ?? CHR(7)
    @ 20,25 SAY "Com Port "+STR(XX,1)+" Is Not Available"
    INKEY(2)
    @ 20,0
    WSELECT(OLDSELWIN)
RETURN('')

**************
*  RDY_MSG   *
**************
FUNCTION RDY_MSG
    PARAMETER Y
    PRIVATE TR
    IF Y = 1
        TR = "Receiver"
    ELSE
        TR = "Transmitter"
    ENDIF
    OLDSELWIN = WSELECT()
    WSELECT(0)
    ?? CHR(7)
    @ 20,25 SAY TR+" Is Not Ready"
    INKEY(2)
    @ 20,0
    WSELECT(OLDSELWIN)
RETURN('')

***************
*  STATUSFRM  *
***************
FUNCTION STATUSFRM
    @ 23,0 SAY REPL(CHR(196),80)
    @ 24,1 SAY "PORT:    BAUD:      PARITY:    WORD:    STOP:   "+;
    "BUFF SIZE:       HANDSHAKE:"
RETURN ('')

****************
*   STATUSMSG  *
****************
FUNCTION STATUSMSG
    @ 24,07 GET PORT    PICT "9"
    @ 24,16 GET BAUD    PICT "9999"
    @ 24,29 GET PARITY  PICT "!"
    @ 24,38 GET WORDBIT PICT "9"
    @ 24,47 GET STOPBIT PICT "9"
    @ 24,60 GET BUFFNUM PICT '99999'
    @ 24,77 GET HANDSHAKE  PICT "L"
    CLEAR GETS
RETURN ('')

************
* SYSCOLOR *
************
FUNCTION SYSCOLOR
    PARAMETER NUM
    IF ISCOLOR()
        DO CASE
           CASE NUM = 01
               clr = "GR+/B,R/W,B"
           CASE NUM = 02
               clr = "GR+/B,GR+/B,B"
        ENDCASE
    ELSE
        DO CASE
           CASE NUM = 01
               clr = "W/N,N/W+,N"
           CASE NUM = 02
               clr = "W/N,W/N,N"
        ENDCASE
    ENDIF
    SET COLOR TO &clr
RETURN 0
*******************************************************************
