* File Name: compstru.prg
* Author:   Michael A. Cohen
*           Triton Systems Corporation
*           9300 Lee Highway
*           Fairfax, Va 22031
*           703-934-3900
*
* Compares database structure(s) in Clipper
* Date....: March 1989
* Notes...: Clipper function to compare database structures
*
* Syntax:   compstru [Wildcard] [database2 or directory] [/L]'
*--------------------------------------------------------------------------------
parameter twild,file2,options
? 'TSC Compare DBF Structures, Version 1.01  March 12, 1990'
if pcount() < 2
 ? 'Format is: compstru [wildcard] [database2 or directory] [/L]'
 ? 'where [wildcard] is the first database file(s)'
 ? 'where [database2 or directory] is the second database file or directory'
 ? 'where [/L] is the list flag (which lists the structure of both databases)'
 return
endif
listflag=.F.
if pcount() = 3
 if 'L'$upper(options)
  listflag=.T.
 endif
endif

twild=trim(twild)
if .not.('.'$twild)
 twild=trim(twild)+'.DBF'
endif
* Get just the directory from the string
if '\'$twild
 tdbdir=substr(twild,1,rat('\',twild))
elseif ':'$twild
 tdbdir=substr(twild,1,at(':',twild))
else
 tdbdir=""
endif

dbcount=adir(twild)
declare dbf_files[dbcount]
adir(twild,dbf_files)

for ifile=1 to dbcount
 tdb1=tdbdir+dbf_files[ifile]

 tdb2=trim(file2)
 if ('\'$tdb2 .or. ':'$tdb2) .and. .not.('.DBF'$upper(tdb2))   && it is a directory
  tdb2=iif(substr(tdb2,-1,1)='\',tdb2,iif(substr(tdb2,-1,1)=':',tdb2,tdb2+'\'))
  tdb2=tdb2+trim(dbf_files[ifile])
 else
  if .not.('.'$file2)
   tdb2=trim(file2)+'.DBF'
  endif
 endif

 if .not.file(tdb1)
  ? CHR(7)+tdb1,' not found'
  loop
 endif
 if .not.file(tdb2)
  ? CHR(7)+tdb2,' not found'
  loop
 endif

 ? 'File 1: ',tdb1
 ? 'File 2: ',tdb2

 select 1
 use (tdb1)
 if .not.used()
  ? CHR(7)+'Not a database: ',tdb1
  loop
 endif
 tcount=fcount()

 declare fname[tcount],ftype[tcount],fwidth[tcount],fdec[tcount]

 afields(m->fname,m->ftype,m->fwidth,m->fdec)

 select 2
 use (tdb2)
 if .not.used()
  ? CHR(7)+'Not a database: ',tdb2
  loop
 endif
 tcount2=fcount()
 declare fname2[tcount2],ftype2[tcount2],fwidth2[tcount2],fdec2[tcount2]
 afields(m->fname2,m->ftype2,m->fwidth2,m->fdec2)

 select 1

   tcount=fcount()
   lastup=lupdate()
   numrec=reccount()
   reclen=asum(m->fwidth)+1

   tcount2=b->(fcount())
   lastup2=b->(lupdate())
   numrec2=b->(reccount())
   reclen2=asum(m->fwidth2)+1

   close data

 if listflag
   ? 'Structure for database:',upper(tdb1)     ,'      Structure for database:',upper(tdb2)
   ? 'Number of data records:',numrec          ,'           Number of data records:',numrec2
   ? 'Date of last update:',lastup             ,'             Date of last update:',lastup2
   ? 'Field  Field Name  Type       Width  Dec','  Field Name  Type       Width  Dec'
 endif

   diff=.F.
   if tcount2 <> tcount
    diff=.T.
   endif
   for i = 1 to max(tcount,tcount2)
    if listflag
     if i <= tcount
      ? str(i,5,0)+'  '+pad(fname[i],10)+'  '+pad(longtype(ftype[i]),9)+'  '+str(fwidth[i],5,0)+'  '+str(fdec[i],3,0)
     else
      ? str(i,5,0)+space(35)
     endif
     if i <= tcount2
      ?? '   '+pad(fname2[i],10)+'  '+pad(longtype(ftype2[i]),9)+'  '+str(fwidth2[i],5,0)+'  '+str(fdec2[i],3,0)
     endif
    endif
    if i <= tcount .and. i <= tcount2
     if fname[i] # fname2[i] .or. ftype[i] # ftype2[i] .or. ;
      fwidth[i] # fwidth2[i] .or. fdec[i] # fdec2[i]
      if listflag
       ?? '*'
      endif
      diff=.T.
     endif
    endif
   next
   if listflag
    ? '** Total **'+space(19)+str(reclen,5,0)+'            '+space(19)+str(reclen2,5,0)
    ?
   endif
   ? 'Databases are '+iif(diff,chr(7)+"different","the same")
next
Return

Function longtype
parameter fieldtype
* Converts short field type to long name
if fieldtype='C'
 Return('Character')
elseif fieldtype='D'
 Return('Date')
elseif fieldtype='N'
 Return('Numeric')
elseif fieldtype='L'
 Return('Logical')
elseif fieldtype='M'
 Return('Memo')
else
 Return('Unknown')
endif

Function asum
parameter tarr
private tsum,i
tsum=0
for i = 1 to len(tarr)
 tsum=tsum+tarr[i]
next
return (tsum)
