*/
*/ _COMP4.PRG - Copyright 1990 Michael P. Deignan. All Rights Reserved.
*/              Refer To The File COMP50.DOC For Further Information On
*/		Usage And Distribution Limitations.
*/
*/ Function:   COMP4
*/ Parameters: passed_value
*/
*/ Purpose: This routine will convert a numeric value to a compressed binary
*/ character string. It will also convert a character string containing a 
*/ compressed binary value back to a numeric value.
*/
*/ Function Caveats: This routine handles values up to 2^64 power. It is not
*/ "compatible" with IBM's COMP4 function, as COMP4 is generally COMP on most
*/ machines anyway. This routine will return a double-word (8 bytes) to the
*/ caller.
*/
FUNCTION comp4
PARAMETERS passed_value
PRIVATE invalue, outvalue, power, routine, signbyte, byteval

STORE "COMP4()"     						TO routine
STORE passed_value 						TO invalue
DO CASE
   CASE TYPE("invalue")="N"
      STORE "" 							TO outvalue
      STORE +1 							TO signbyte
      IF invalue<0
         STORE -1           					TO signbyte
	 STORE ABS(invalue) 					TO invalue
      ENDIF
      FOR power=64 TO 0 STEP -8
        IF invalue>=2**power
           STORE INT(invalue/2**power)           		TO byteval
           STORE invalue - ( byteval * 2**power) 		TO invalue
           STORE outvalue + CHR(byteval)         		TO outvalue
	ENDIF
      NEXT
      IF INT(LEN(outvalue)/4)#LEN(outvalue)/4
         STORE REPLICATE(CHR(00),IIF(LEN(outvalue)>4,8,4)-;
	       LEN(outvalue))+outvalue 				TO outvalue
      ENDIF
   CASE TYPE("invalue")="C"
      STORE +1 TO signbyte
      STORE 0 							TO outvalue
      FOR power=(LEN(invalue)-1)*8 TO 0 STEP -8
         STORE outvalue+;
         ASC(SUBSTR(invalue,LEN(invalue)-power/8,1))*(2**power) TO outvalue
      NEXT
      STORE outvalue*signbyte 					TO outvalue
   OTHERWISE
      DO binary_error WITH routine
ENDCASE
RETURN outvalue

