*/
*/ _COMP1.PRG - Copyright 1990 Michael P. Deignan. All Rights Reserved.
*/              Refer To The File COMP50.DOC For Further Information On
*/		Usage And Distribution Limitations.
*/
*/ Function:   COMP1
*/ Parameters: passed_value
*/
*/ This function will convert a numeric value to a character string containing
*/ a fullword, internal floating point binary number. Any character data
*/ is converted back from binary to numeric. This routine is used when short-
*/ precision fractional exponentiation is required.
*/
FUNCTION comp1
PARAMETERS passed_value
PRIVATE invalue, outvalue, power, routine, signbyte, exponent, fraction

STORE "COMP1()"     						TO routine
STORE passed_value 						TO invalue
DO CASE
   CASE TYPE("invalue")="N"
      STORE +1							TO signbyte
      IF invalue<0
         STORE ABS(invalue)					TO invalue
	 STORE -1 						TO signbyte
      ENDIF
      STORE AT(".",ALLTRIM(STR(invalue,100,50)))-1		TO exponent
      DO WHILE INT(invalue)#invalue
         STORE invalue*10					TO invalue
      ENDDO
      STORE invalue                     			TO fraction
      DO WHILE fraction>2**24
         STORE INT(fraction/10)					TO fraction
      ENDDO
      STORE RIGHT(COMP(fraction),3)				TO fraction
      STORE RIGHT(COMP(exponent),1)				TO exponent
      STORE exponent+fraction					TO outvalue
      IF signbyte=-1
      	 STORE twos_compliment(outvalue)			TO outvalue
      ENDIF
   CASE TYPE("invalue")="C"
      STORE +1 TO signbyte
      IF ASC(SUBSTR(invalue,1,1))>127
         STORE twos_compliment(invalue)				TO invalue
	 STORE -1						TO signbyte
      ENDIF
      STORE COMP(LEFT(invalue,1))				TO exponent
      STORE COMP(SUBSTR(invalue,2,3))				TO fraction
      DO WHILE fraction>1
      	 STORE fraction/10					TO fraction
      ENDDO
      STORE signbyte * fraction* (10**exponent)			TO outvalue
   OTHERWISE
      DO binary_error WITH routine
ENDCASE
RETURN outvalue
