*/
*/ _COMP3.PRG - Copyright 1990 Michael P. Deignan. All Rights Reserved.
*/              Refer To The File COMP50.DOC For Further Information On
*/		Usage And Distribution Limitations.
*/
*/ Function:   COMP3
*/ Parameters: passed_value
*/
*/ This function will convert a numeric value to a character string containing
*/ a packed decimal value, or a character string containing a packed decimal
*/ value back to a numeric value.
*/
*/ Function Caveats: This routine is slightly different than IBM's COMP-3 data
*/ type, however, is backwards compatible with it. The primary difference is 
*/ that packed decimal values created by this routine will have the number of
*/ decimals stored in the sign half-byte, which will be re-used to properly
*/ place the decimal point upon uncompression.
*/
*/ Should a character field be passed to this routine which contains a non-
*/ packed-decimal value, then the routine will return '0' for the decimal
*/ number.
*/
*/ When handling decimals, a maximum of seven decimals places are accounted
*/ for. Any data beyond the seventh decimal is trucated by the function.
*/
FUNCTION comp3
PARAMETERS passed_value
PRIVATE invalue, outvalue, signbyte, byteval, bytemsb, bytelsb, routine
PRIVATE decimals

STORE "COMP3()"    						TO routine
STORE passed_value 						TO invalue
DO CASE
   CASE TYPE("invalue")="N"
      STORE 00 							TO signbyte,;
      								   decimals
      IF invalue<0
         STORE 01           					TO signbyte
	 STORE ABS(invalue) 					TO invalue
      ENDIF
      STORE STR(invalue)   					TO byteval
      IF "."$byteval
	 STORE LEN(byteval)-AT(".",byteval) 			TO decimals
         STORE invalue*10**decimals         			TO invalue
      ENDIF
      IF decimals>7
      	 STORE 7 						TO decimals
      ENDIF
      STORE decimals*2+signbyte    				TO signbyte
      STORE STR(INT(invalue),19,0) 				TO invalue
      STORE LTRIM(invalue)         				TO invalue
      IF LEN(invalue)=INT(LEN(invalue))
         STORE "0"+invalue 					TO invalue
      ENDIF
      STORE "" 							TO outvalue
      FOR byte = 1 TO LEN(invalue)-1 STEP 2	
	 STORE outvalue + ;
	       CHR((ASC(SUBSTR(invalue,byte+0,1))-48)*16+;
                   (ASC(SUBSTR(invalue,byte+1,1))-48))		TO outvalue
      NEXT
      STORE outvalue+CHR((ASC(SUBSTR(invalue,;
            LEN(invalue),1))-48)*16 + signbyte) 		TO outvalue
   CASE TYPE("invalue")="C"
      STORE "" TO outvalue
      FOR byte = 1 TO LEN(invalue)-1
         STORE ASC(SUBSTR(invalue,byte,1))         		TO byteval
         STORE INT(byteval/2**4)                   		TO bytemsb
         STORE byteval - (bytemsb * 2**4)          		TO bytelsb
         STORE outvalue + CHR(bytemsb+48)          		TO outvalue
         STORE outvalue + CHR(bytelsb+48)          		TO outvalue
      NEXT
      STORE ASC(SUBSTR(invalue,LEN(invalue),1))    		TO invalue
      STORE INT(invalue/2**4)                      		TO byteval
      STORE invalue - (byteval * 2**4)             		TO invalue
      STORE outvalue + CHR(byteval+48)             		TO outvalue
      STORE IIF(INT(invalue/2)#invalue/2,-1,+1)    		TO signbyte
      STORE INT(invalue/2)                         		TO decimals
      STORE (VAL(outvalue)*signbyte)/10**decimals  		TO outvalue
   OTHERWISE
      DO binary_error WITH routine
ENDCASE
RETURN outvalue

