*ͻ*
*   System Name:   Suite of programs to show off 5.0               *
*   Module Name:   COLORSPE.PRG                                    *
*   Description:   Demo of coloring individual rows and of the     *
*                  line mode change capabilities.                  *
*   Notes......:   Really can't remember why I called it           *
*                  COLORSPE.PRG.  Use F1 for help.                 *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   Oct. 16 1990                                    *
*   History....:   It's one of those perpetually "adding on to"    *
*                  programs.  But the real history is that a       *
*                  woman called in to our office and said she      *
*                  wanted to have her servicemen pick out their    *
*		    areas by colored rows.  The rest was history.   *
*                                                                  *
*   Copyright..:   (c) Micro Tech Consultant Services, 1990        *
*                  (c) The people at Nantucket Canada, 1990        *
*                  Is this possible?                               *
*ͼ*
#include "inkey.ch"
#include "funcs.ch"

//  Array containing the values for line modes
LOCAL aMode := { 25, 43, 50 }
LOCAL cDefCol, cHilite
LOCAL nI, nKey, nMode
//  'oBrowse' is defined with MAXROW() in case the mode was changed in DOS.
//  'oBrowse' contains what I like to call an Object Handle.
LOCAL oBrowse := TBROWSEDB( 2, 6, MAXROW() - 4, 72 ), oColumn

SETCURSOR( 0 )

CLS

Panel()
@MAXROW(), 0
@MAXROW(), 71 SAY 'F1 - Help'

USE ColorSpe INDEX ColorSp1, ColorSp2

//  Defines the Column, Header, and Footer separators for the TBrowse.
oBrowse:COLSEP := ""
oBrowse:HEADSEP := ""
oBrowse:FOOTSEP := ""

SETCOLOR( 'w+/b' )
//  Draws a shadowed box on the screen
Shad( 1, 5, MAXROW() - 3, 73, .T., 'w+/b' )

SETBLINK( .F. )

//  Sets up the color table for the TBrowse.  Internally they are separated
//  by the comma and numbered in order.
oBrowse:COLORSPEC := "W+/B, N/W, W+/R, N/G, N/BG, B/RB, W+/GR, N/B*, N/G*, N/R*"

***************************** Order Number Column *****************************
//  Sets up my first column.  Note the semi-colon in the Header String.
oColumn := TBCOLUMNNEW( "   ORDER ;  NUMBER",;
		{ || PADC( TRIM( ColorSpe->OrderNum ), 10 ) } )
oColumn:FOOTING := PadC( '*INDEX*', 10 )
//  Adds the column object into the TBrowse, by passing the Object Handle
//  Variable.
//  First in, first position
oBrowse:ADDCOLUMN( oColumn )

****************************** Service Type Column ****************************
//  Adds the column object into the TBrowse.  Not having to add any more to
//  the column, I am able to bypass the Object Handle Variable and pass the Object
//  Handle directly into the TBrowse.
//  Second in, second position.
oBrowse:ADDCOLUMN( TBCOLUMNNEW( "  SERVICE;   TYPE",;
			{ || PADC( LTRIM( STR( ColorSpe->ServType ) ), 10 ) } ) )

********************************* From Column *********************************
//  Adds the column object into the TBrowse.
//  Third in, third position.
oBrowse:ADDCOLUMN( TBCOLUMNNEW( PADC( "FROM", 22 ),;
			{ || PADC( ColorSpe->From, 22 ) } ) )

********************************** To Column **********************************
//  Adds the column object into the TBrowse.
//  Fourth in, fourth position.
oBrowse:ADDCOLUMN( TBCOLUMNNEW( PADC( "TO", 22 ),;
			{ || PADC( ColorSpe->To, 22 ) } ) )

*******************************************************************************

//  Set the automatic highlighting off
oBrowse:AUTOLITE := .F.

//  Uses the CARGO area of the Browse Object to hold the toggle data
oBrowse:CARGO := .F.

//  Loops until the F10 Keypress is passed to "nKey"
DO WHILE ! ( nKey == K_F10 )

	//  Sets up the virtual screen
	BEGINPAINT()
	//  Redraws the changed data rows
	DO WHILE ! ( oBrowse:STABILIZE() )
	ENDDO
	//  Draws the virtual screen
	ENDPAINT()

	//  Hilites a whole row including column separators
	cHilite := SAVESCREEN( ROW(), 6, ROW(), 72 )
	RESTSCREEN( ROW(), 6, ROW(), 72, TRANSFORM( cHilite,;
		REPLICATE( "X", 71 ) ) )

	//  Waits for a keypress
	nKey := INKEY( 0 )

	//  Restores the original row colors
	RESTSCREEN( ROW(), 6, ROW(), 72, cHilite )

	DO CASE
	CASE nKey == K_F1
		Help()

	//  Moves down one row.
	CASE nKey == K_DOWN
		oBrowse:DOWN()

	//  Moves up one row.
	CASE nKey == K_UP
		oBrowse:UP()

	//  Moves down one screen of data
	CASE nKey == K_PGUP
		oBrowse:PAGEUP()

	//  Moves up one screen of data
	CASE nKey == K_PGDN
		oBrowse:PAGEDOWN()

	//  Moves to the first data item
	CASE nKey == K_HOME
		oBrowse:GOTOP()

	//  Moves to the last data item
	CASE nKey == K_END
		oBrowse:GOBOTTOM()

	//  Toggles the coloring of rows
	CASE nKey == K_F3
		//  Fills the CARGO area with the alternate value
		oBrowse:CARGO := IF( oBrowse:CARGO, .F., .T. )

		//  Loops thru the columns
		FOR nI := 1 TO ( oBrowse:COLCOUNT )
			//  Passes the appropriate code block into each
			//  of the column objects.
			//  When the code blocks are evaluated, arrays
			//  are passed with values that point to the
			//  COLORSPEC table.  The first elements contains
			//  the location, of the unselected color, in the
			//  COLORSPEC table.  The second elements contains
			//  the location of the selected color.
			( oBrowse:GETCOLUMN( nI ) ):COLORBLOCK :=;
			IF( oBrowse:CARGO,;
				{ || { ColorSpe->ServType + 1, 10 } },;
				{ || { 1, 10 } } )
		NEXT nI

		//  Sets up the controlling index.
		SET ORDER TO IF( oBrowse:CARGO, 2, 1 )

		//  Gives the non-index column an empty FOOTER
		( oBrowse:GETCOLUMN( IF( oBrowse:CARGO, 1, 2 ) ) ):FOOTING :=;
			''
		//  Gives the index column the '*INDEX*' FOOTER
		( oBrowse:GETCOLUMN( IF( oBrowse:CARGO, 2, 1 ) ) ):FOOTING :=;
			PadC( '*INDEX*', 10 )

		//  Forces the TBrowse to rewrite it's FOOTER.
		//  Will re-configure the whole TBrowse but in this case it
		//  is used for the footer.
		oBrowse:CONFIGURE()
		//  Moves to the first data item, which in this case is the
		//  first record in the new index.
		oBrowse:GOTOP()

	CASE nKey == K_F9
		//  Passes the aMode array into the ChgMode function,
		//  which will return the position the New Line Mode in
		//  the aMode array.  If the screen is unchanged 0 is
		//  returned
		nMode := ChgMode( aMode )
		IF nMode != 0
			//  Sets the line mode with the value in the
			//  nMode'th element.
			SETMODE( aMode[ nMode ], 80 )

			Panel()
			cDefCol := SETCOLOR( 'w/n' )
			@MAXROW(), 0
			@MAXROW(), 71 SAY 'F1 - Help'
			SETCOLOR( cDefCol )

			//  Redraws a shadowed box on the screen
			Shad( 1, 5, MAXROW() - 3, 73, .T., 'w+/b' )

			//  Changes the bottom coordinate of the TBrowse.
			oBrowse:NBOTTOM := MAXROW() - 4
			//  Moves to the first data item.
			oBrowse:GOTOP()
		ENDIF
		SETCURSOR( 1 )

	CASE nKey == K_F10
		//  Envokes a function that returns 1 if you want to
		//  exit. If you do not want to exit, nKey has zero 
		//  assigned to it, which keeps you in the loop.
		IF( TimeToExit() = 1, Nil, nKey := 0 )

	ENDCASE

ENDDO

SETCURSOR( 1 )
Credit()
//  Resets the mode to 25 lines per screen.
SETMODE( 25, 80 )

RETURN



* * * *
*
*	Function ChgMode()
*
//  Dialog Box for a screen mode change.
FUNCTION ChgMode( aMode )
	LOCAL cDefCol, cDefColor := SETCOLOR( 'w+/br' ),;
		cFullScrn := SAVESCREEN( 0, 0, MAXROW(), 79 )
	//  ASCAN will scan for the current screen line mode in the aMode
	//  array.
	//  nHalfScrn finds the location of vertical middle of the screen.
	LOCAL nChMode := ASCAN( aMode, MAXROW() + 1 ),;
		nHalfScrn := INT( MAXROW()/2 )

	//  Draws a shadowed box on the screen.
	BoxShad( ( nHalfScrn - 3 ), 29, ( nHalfScrn + 2 ), 46, 'w+/br' )
	
	//  Sets up the line mode menu.
	@nHalfScrn - 2, 31 PROMPT ' 25 Line Mode '
	@nHalfScrn - 1, 31 PROMPT ' 43 Line Mode '
	@nHalfScrn, 31 PROMPT ' 50 Line Mode '
	@nHalfScrn + 1, 31 PROMPT " Don't Change "
	MENU TO nChMode

	SETCOLOR( cDefColor )

	//  Checks if the menu selection was aborted, 'Don't Change' was
	//  selected or the current line mode was selected.  If any of
	//  these conditions are met the function returns zero.
	IF nChMode == 0 .OR. nChMode == 4 .OR. aMode[ nChMode ] == MAXROW() + 1
		RESTSCREEN( 0, 0, MAXROW(), 79, cFullScrn )
		nChMode := 0
	ENDIF

//  Will return the location of the element which contains the value for
//  the new screen line mode.
RETURN nChMode


* * * *
*
*	Function TimeToExit()
*
//  Dialog Box for Exiting
FUNCTION TimeToExit()
	LOCAL cDefCol := SETCOLOR( 'w+/r' ),;
		cFullScrn := SAVESCREEN( 0, 0, MAXROW(), 79 )
	LOCAL nExitCh := 1, nHalfScrn := INT( MAXROW()/2 )

	//  Draws a shadowed box on the screen.
	BoxShad( ( nHalfScrn - 3 ), 29, ( nHalfScrn + 1 ), 47, 'w+/r' )

	//  Sets up the exit menu.
	@nHalfScrn - 2, 32 SAY 'Do You Really'
	@nHalfScrn - 1, 32 SAY 'Want to Exit?'
	@nHalfScrn, 33 PROMPT ' YES '
	@nHalfScrn, 40 PROMPT ' NO '
	MENU TO nExitCh

	SETCOLOR( cDefCol )
	RESTSCREEN( 0, 0, MAXROW(), 79, cFullScrn )

//  Will return 1 if you want to exit.
RETURN nExitCh



* * * *
*
*	Function Help()
*
FUNCTION Help()
	LOCAL cDefCol := SETCOLOR( 'n/bg' ),;
		cFullScrn := SAVESCREEN( 0, 0, MAXROW(), 79 )
	LOCAL nHalfScrn := INT( MAXROW()/2 )

	//  Draws a shadowed box on the screen.
	BoxShad( ( nHalfScrn - 6 ), 25, ( nHalfScrn + 5 ), 52, 'n/bg' )

	//  Sets up the Help Dialog.
	@nHalfScrn - 5, 31 SAY CHR( 25 ) + ' - Down'
	@nHalfScrn - 4, 31 SAY CHR( 24 ) + ' - Up'
	@nHalfScrn - 3, 28 SAY 'PgDn - Next Screen'
	@nHalfScrn - 2, 28 SAY 'PgUp - Previous Screen'
	@nHalfScrn - 1, 29 SAY 'End - Bottom of File'
	@nHalfScrn , 28 SAY 'Home - Top of File'
	@nHalfScrn + 2, 30 SAY 'F3 - Sort Toggle'
	@nHalfScrn + 3, 30 SAY 'F9 - Line Mode'
	@nHalfScrn + 4, 29 SAY 'F10 - Exit'

	//  Waits for a Keypress
	INKEY( 0 )

	SETCOLOR( cDefCol )
	RESTSCREEN( 0, 0, MAXROW(), 79, cFullScrn )

RETURN Nil