*:*********************************************************************
*:
*:        Program: COLORCHG.PRG
*:
*:         System: COLOR SELECTION PROGRAM
*:         Author: Paul Ferrara [70075,252]
*:      Copyright (c) 1989, ColumbuSoft
*:  Last modified: 02/22/89     09:00
*:
*:  Procs & Fncts: WRITENORM
*:               : WRITEWIND
*:               : WRITEERR
*:               : WRITEMSG
*:               : WHATMVAR
*:
*:          Calls: WRITENORM        (procedure in COLORCHG.PRG)
*:               : WRITEWIND        (procedure in COLORCHG.PRG)
*:               : WRITEERR         (procedure in COLORCHG.PRG)
*:               : WRITEMSG         (procedure in COLORCHG.PRG)
*:               : WHATMVAR         (procedure in COLORCHG.PRG)
*:               : &MPROC
*:
*:   Memory Files: COLORS.MEM
*:
*:     Documented: 02/17/89 at 11:39                SNAP! version 2.55
*:*********************************************************************
SET BELL OFF                                    && Ŀ
SET SAFETY OFF                                  &&     These lines
SET SCOREBOARD OFF                              &&   would normally
SET STATUS OFF                                  &&     be in your
SET TALK OFF                                    &&    calling program
SET PROCEDURE TO colorchg.prg                   && Foxbase+ & dBASE IV
LOAD colors.bin                                 && Foxbase+ & dBASE IV
*
* note: colors.bin was written by Russell Freeland and permission
*       to use and distribute it with this program is gratefully
*       acknowledged.
*
SET COLOR TO W/N
CLEAR

RELEASE ALL LIKE m*
IF FILE("COLOR.MEM")
   RESTORE FROM color ADDITIVE
ELSE
   mnormh='W+/G   '
   mnormn='N/G    '
   mnorme='N/W    '
   mwindh='W+/B   '
   mwindn='W/B    '
   mwinde='N/W    '
   merrh='W+/R   '
   merrn='W/R    '
   merre='N/W    '
ENDIF

DO writenorm
DO writewind
DO writeerr
DO writemsg

xcolor=mnormh                                           && color of arrow
xvar="mnormh"
xproc="writenorm"                                       && window to draw

?? SYS(2002)                                            && Foxbase+
SET CURSOR OFF                                          && Clipper
x=9
y=12
xkey=1
DO WHILE xkey<>27 .AND. xkey<>-9
   DO whatxvar
   SET color TO &xcolor
   @ x,y SAY ""
   xkey=INKEY(0)
   @ x,y SAY "  "
   * valid rows -  9, 11, 13  = X
   * valid cols = 12, 32, 52  = Y
   DO CASE
      CASE xkey=1                                       && home
         x=9
         y=12
      CASE xkey=6                                       && end
         x=13
         y=52
      CASE xkey=4                                       && right arrow
         IF y=52
            y=12
         ELSE
            y=y+20
         ENDIF
      CASE xkey=19                                      && left arrow
         IF y=12
            y=52
         ELSE
            y=y-20
         ENDIF
      CASE xkey=24                                      && down arrow
         IF x=13
            x=9
         ELSE
            x=x+2
         ENDIF
      CASE xkey=5                                       && up arrow
         IF x=9
            x=13
         ELSE
            x=x-2
         ENDIF
      CASE xkey=13                                      && enter
         ?? SYS(2002,1)                                 && Foxbase+
         SET CURSOR ON                                  && Clipper
         tempcolor=SPACE(7)
         CALL colors WITH tempcolor                     && FB+ & dBASE IV
         tempcolor=COLORS()                             && Clipper
         ?? SYS(2002)                                   && Foxbase+
         SET CURSOR OFF                                 && Clipper
         IF ASC(tempcolor)<>27                          && Foxbase+
         IF ""<>tempcolor                               && Clipper
            &xvar=tempcolor
            DO &xproc
         ENDIF
   ENDCASE
ENDDO
SET CURSOR ON                                           && Clipper
?? SYS(2002,1)                                          && Foxbase+
IF xkey=-9
   SAVE ALL LIKE m* TO color
ENDIF
CLOSE PROCEDURE
RELEASE MODULE colors.bin                               && FB+ & dBASE IV
RETURN

PROCEDURE whatxvar
   DO CASE
      CASE y=12
         xcolor="W+/"+RIGHT(mnormh,LEN(mnormh)-AT('/',mnormh))
         xproc="writenorm"
         DO CASE
            CASE x=9
               xvar="mnormh"
            CASE x=11
               xvar="mnormn"
            CASE x=13
               xvar="mnorme"
         ENDCASE
      CASE y=32
         xcolor="W+/"+RIGHT(mwindh,LEN(mwindh)-AT('/',mwindh))
         xproc="writewind"
         DO CASE
            CASE x=9
               xvar="mwindh"
            CASE x=11
               xvar="mwindn"
            CASE x=13
               xvar="mwinde"
         ENDCASE
      CASE y=52
         xcolor="W+/"+RIGHT(merrh,LEN(merrh)-AT('/',merrh))
         xproc="writeerr"
         DO CASE
            CASE x=9
               xvar="merrh"
            CASE x=11
               xvar="merrn"
            CASE x=13
               xvar="merre"
         ENDCASE
   ENDCASE
RETURN

PROCEDURE writenorm
   SET COLOR TO &mnormh.,&mnorme
   @  5,10,15,28 BOX "ͻȺ "                        && Foxbase+ & Clipper
   @  5,10 TO 15,28 "","","","","","","",""     && dBASE IV
   @  6,16 SAY "NORMAL"
   @  7,10 SAY "͹"
   @  9,14 SAY "HIGHLIGHTED"
   SET COLOR TO &mnormn.,&mnorme
   @ 11,16 SAY "NORMAL"
   SET COLOR TO &mnorme.,&mnorme
   @ 13,15 SAY "ENHANCED"
RETURN

PROCEDURE writewind
   SET COLOR TO &mwindh.,&mwinde
   @  5,30,15,48 BOX "ͻȺ "                        && Foxbase+ & Clipper
   @  5,30 TO 15,48 "","","","","","","",""     && dBASE IV
   @  6,36 SAY "WINDOWS"
   @  7,30 SAY "͹"
   @  9,34 SAY "HIGHLIGHTED"
   SET COLOR TO &mwindn.,&mwinde
   @ 11,36 SAY "NORMAL"
   SET COLOR TO &mwinde.,&mwinde
   @ 13,35 SAY "ENHANCED"
RETURN

PROCEDURE writeerr
   SET COLOR TO &merrh.,&merre
   @  5,50,15,68 BOX "ͻȺ "                        && Foxbase+ & Clipper
   @  5,50 TO 15,68 "","","","","","","",""     && dBASE IV
   @  6,56 SAY "ERRORS"
   @  7,50 SAY "͹"
   @  9,54 SAY "HIGHLIGHTED"
   SET COLOR TO &merrn.,&merre
   @ 11,56 SAY "NORMAL"
   SET COLOR TO &merre.,&merre
   @ 13,55 SAY "ENHANCED"
RETURN

PROCEDURE writemsg
   SET COLOR TO GR+/GR
   @ 16,10,18,68 BOX "ͻȺ "                        && Foxbase+ & Clipper
   @ 16,10 TO 18,68 "","","","","","","",""     && dBASE IV
   SET COLOR TO W/GR
   @ 17,16 SAY "ENTER=Select   "+CHR(26)+"=Move   Esc=Abort   F10=Save"
RETURN
