/*    COLOR.PRG

      12/19/90
  
      Test colors for 5.0
*/
#define K_F2   -1
#define K_ESC  27
#define K_INS  22
memvar GetList

function main()
   local ColorSet := Space(60)
   cls
   SetKey(K_F2, { || BlinkToggle() })     // Blink toggle
   SetKey(K_INS, { || InsertKey() })      // Insert cursor
   set score off
   SetBlink(.F.)                          // Enable hi inten background.
   while lastkey() <> K_ESC
      center(0,"Clipper 5.0 Color Test Program by Jeff Stapleton")
      center(2,'This will test color combinations.')
      center(4,'Press Esc to quit.  Press F2 to toggle SETBLINK().')
      @ 6,0 say padr(if(SetBlink(), "Blinking enabled", ;
           "Hi-Intensity background colors enabled"), 80)   
      // Display color chart...
      @ 8,0  say "color                 monochrome  color                    monochrome"
      @ 9,0  say "Black, Space  N   0   Black       Gray            N+   8   Black"
      @ 10,0 say "Blue          B   1   Underline   Bright Blue     B+   9   Bright Underline"
      @ 11,0 say "Green         G   2   White       Bright Green    G+  10   Bright White"
      @ 12,0 say "Cyan          BG  3   White       Bright Cyan     BG+ 11   Bright White"
      @ 13,0 say "Red           R   4   White       Bright Red      R+  12   Bright White"
      @ 14,0 say "Magenta       RB  5   White       Bright Magenta  RB+ 13   Bright White"
      @ 15,0 say "Brown         GR  6   White       Yellow          GR+ 14   Bright White"
      @ 16,0 say "White         W   7   White       Bright White    W+  15   Bright White"
      // Prompt for color      
      center(18,'Enter color combination:') 
      @ 18,53 get colorset pict "@S20"
      read
      setcolor(colorset)
      cls
   enddo
   set color to
   SetBlink(.T.)                          // Dissable on exit.
   cls
   
function BlinkToggle()
   SetBlink(if(SetBlink(), .F., .T.))
   @ 6,0 say padr(if(SetBlink(), "Blinking enabled", ;
        "Hi-Intensity background colors enabled"), 80)   
        
function InsertKey()
   // Toggle ReadInsert() and cursor height dependant on Readinsert() state.
   if !ReadInsert()
      ReadInsert(.T.)
      SetCursor(2)
   else
      ReadInsert(.F.)
      SetCursor(1)
   endif

FUNCTION Center(row, string)
   @ row, (MAXCOL() / 2) - (LEN(string) / 2) SAY string

      