*ͻ*
*   System Name:   CODE BLOCK DEMONSTRATION SUITE                           *
*   Module Name:   CBMULTI.PRG                                              *
*   Description:   Shows how multiple code blocks contained in              *
*                  an array can be send to and then evaluated               *
*                  in a generalized function.                               *
*   Notes......:   Simplistic but effectively shows the power               *
*                  of arrays and code blocks.                               *
*                  *** Compile with the /N/W/A switches ***                 *
*   Author.....:   Micheal Todd Charron                                     *
*   Date.......:   Oct. 23, 1990                                            *
*   History....:   Thought up, on a Train to Montreal                       * 
*ͼ*

FUNCTION Main()
     LOCAL aCodeBlocks
     LOCAL nI

     CLS

     aCodeBlocks := {;
                    { | p1 | LTRIM( STR( p1 ) ) + ' ' + 'Times' } ,;
                    { | p1 | REPLICATE( "*", p1 ) } ,;
                    { | p1 | ( MOD( p1, 3 ) == 0 ) } ,;
                    { | p1 | DATE() + p1 } ;
                   }

     FOR nI = 1 TO 4
          CodeDisp( aCodeBlocks[ nI ], ( nI * 25 ) )
     NEXT nI

     INKEY( 0 )

RETURN Nil



* * * *
*
*    Function CodeDisp()
*
FUNCTION CodeDisp( bCodeBlock, nParam )

     ? EVAL( bCodeBlock, nParam )

RETURN Nil


/******************************************************************************
  FUNCTION MAIN()
*******************************************************************************
        ͸
Line 21    aCodeBlocks := {;                                                 
Line 22                   { | p1 | LTRIM( STR( p1 ) ) + ' ' + 'Times' } ,;   
Line 23                   { | p1 | REPLICATE( "*", p1 ) } ,;                 
Line 24                   { | p1 | ( MOD( p1, 3 ) == 0 ) } ,;                
Line 25                   { | p1 | DATE() + p1 } ;                           
Line 26                  }                                                   
        ;
Above, four Code Blocks are defined and their references are stored into a 
literal array.  Although full literal Code Blocks are defined here, one has to 
remember that only the references to the Code Blocks are stored within the 
array.

        ͸
Line 28    FOR nI = 1 TO 4                                                   
Line 29         CodeDisp( aCodeBlocks[ nI ], ( nI * 25 ) )                   
Line 30    NEXT nI                                                           
        ;
In this FOR...NEXT loop the Code Blocks' references are passed one at a time 
into the CodeDisp() function.  The iterater "nI" is multiplied by 25 and passed 
as the second parameter.

/******************************************************************************
  FUNCTION CodeDisp()
*******************************************************************************
        ͸
Line 42   FUNCTION CodeDisp( bCodeBlock, nParam )                            
                                                                             
Line 44        ? EVAL( bCodeBlock, nParam )                                  
                                                                             
Line 46   RETURN Nil                                                         
        ;
The CodeDisp() function becomes a generalized function that only displays what
is returned by the EVAL() function.  The reference contained in the variable 
"bCodeBlock" is the first parameter of the EVAL() function and all parameters 
after that are the parameters that will be passed into the Code Block.

*******************************************************************************

This give programmers the ability to have more control in the main modules of 
the application and less to supporting modules.

Character strings of the expressions in the Code Blocks could have been passed 
into the function and then they could have been macro expanded but there are 
difficulties in doing this.  Macro strings can only contain one expression
whereas Code Blocks can contain any number of expressions.  The second
parameter would have to be passed with the PARAMETER statement and it would
have to be the same name as the variable in the macro.  Also macros are a lot
slower than code blocks.

******************************************************************************/
