/*
  CLRTBL.PRG
  
  Author .... D.B. McDonald  [ CIS 76334,3521 ]
  Update .... February 17, 1992
  Version ... 1.00.00
  Compiler .. CLIPPER 5.01 using options /M /N /W

  VGA Color Table displaying all 256 color combinations.
  SetBlink bit may be toggled ON/OFF.

  Red, Green, and Blue VGA color tints may be individually adjusted
  for each of the 16 color palettes.

  Custom hot-key functions may be added to key-scan routine.

*/
#include "vgacolor.ch"

#define TOP    2
#define LEFT   4
#define BOTTOM 22
#define RIGHT  75

#xtranslate .Key   => \[ 1 ]
#xtranslate .Block => \[ 2 ]


* --------------------------------------------------------------------------- *
Function ColorTable( aKeyCode )
*    Display Color Table with all 256 color combinations
* --------------------------------------------------------------------------- *
  local nR, nC, i, xTmp, nRed, nGreen, nBlue
  local nSavShdw := wSetShadow( NO_SHADOW )
  local nSavCurs := SetCursor( SC_NONE )
  local cSavClr  := SetColor()     
  local cHiLite  := '+' + cSavClr
  local nTop     := TOP
  local nLeft    := LEFT
  local nBott    := BOTTOM
  local nRight   := RIGHT
  local nKey     := 0
  local nPal     := 0

   //... Paint Color Table Window
   DispBegin()
   wOpen( nTop, nLeft, nBott, nRight )
   SetColor( cHiLite )
   wBox( DOUBLE_LINE )                              
   xTmp := expand( "Color Attribute Table" )
   wSay( 0, centerpos( xTmp ), xTmp )
   SetColor( cSavClr )
   aeval( FOREGROUND, { |a,c| wSay( 1, 5 + 4 * ( c - 1 ), padl( a, 3 ) ) } )
   aeval( BACKGROUND, { |a,c| wSay( c + 1, 1, padl( a, 3 ) ) } )

   //... Paint all 256 color combinations
   i := 0
   for nR = 0 to 15
      for nC = 0 to 15
         wSay( nR + 2, 5 + 4 * nC, str( i,3 ), i++ )
      next nC
   next nR 
   DispEnd()

   //... Execute hotkey functions
   while nKey # K_ESC
      dispBegin()
      wSay( 18, 05, "VGA Palette:" + NumFix( nPal, 2 ), cHiLite )
      wSay( 18, 25, "Red Tint:"    + NumFix( nRed   := GetVgaPal( nPal, RED   ), 2 ), cHiLite )
      wSay( 18, 39, "Green Tint:"  + NumFix( nGreen := GetVgaPal( nPal, GREEN ), 2 ), cHiLite )
      wSay( 18, 56, "Blue Tint:"   + NumFix( nBlue  := GetVgaPal( nPal, BLUE  ), 2 ), cHiLite )
      DispEnd()

      nKey := inkey(0)
      do case
         //... Increment VGA Palette
         case nKey == K_F5
            if ++nPal > 15
               nPal := 0
            endif
            
         //... Decrement VGA Palette
         case nKey == K_SH_F5
            if --nPal < 0
               nPal := 15
            endif
            
         //... Increment Red Tint
         case nKey == K_F6                  
            if ++nRed > 63
               nRed := 0
            endif
            VgaPalette( nPal, nRed, nGreen, nBlue )

         //... Increment Green Tint
         case nKey == K_F7
            if ++nGreen > 63
               nGreen := 0
            endif
            VgaPalette( nPal, nRed, nGreen, nBlue )

         //... Increment Blue Tint
         case nKey == K_F8
            if ++nBlue > 63
               nBlue := 0
            endif
            VgaPalette( nPal, nRed, nGreen, nBlue )

         //... Decrement Red Tint
         case nKey == K_SH_F6                  
            if --nRed < 0 
               nRed := 63
            endif
            VgaPalette( nPal, nRed, nGreen, nBlue )

         //... Decrement Green Tint
         case nKey == K_SH_F7
            if --nGreen < 0 
               nGreen := 63
            endif
            VgaPalette( nPal, nRed, nGreen, nBlue )

         //... Decrement Blue Tint
         case nKey == K_SH_F8
            if --nBlue < 0 
               nBlue := 63
            endif
            VgaPalette( nPal, nRed, nGreen, nBlue )

         //... Reset VGA Palette to default settings
         case nKey == K_F9
            VgaPalette()

         //... Toggle setblink bit 
         case nKey == K_F10
           SetBlink( iif( setblink(), .F., .T. ) )

         //... Scan Custom Hot Key Code blocks if ESC not pressed
         otherwise 
           if nKey # K_ESC
              CustomKey( nKey, aKeyCode ) 
           endif

      endcase

   enddo                 

   //... Restore calling screen setup
   wClose()
   wSetShadow( nSavShdw )
   SetCursor( nSavCurs )

Return NIL


* --------------------------------------------------------------------------- *
Function CustomKey( nKey, aCode )
*    Scan array of key-codes and associated code blocks for key press.
*    If found execute code block associated to key code.
* --------------------------------------------------------------------------- *
  local xRetVal := NIL
  local nIdx    := 0

  //... Parameter aCode must be defined as a 2 member array
  //... Each member of the array contains 2 elements
  //... Elem 1 is a numeric key code
  //... Elem 2 is a code block to execute when the associated key code exists
  if aCode # NIL .and. ValType( aCode ) == 'A'

     //... Scan for valid key code
     if ( nIdx  := aScan( aCode, { |Code| Code.Key == nKey } ) ) > 0
        xRetVal := eval( aCode[ nIdx ].Block )
     endif

  endif

return xRetVal

* --------------------------------------------------------------------------- *
* EOF: CLRTBL.PRG				February 17, 1992 at 14:56:51
* --------------------------------------------------------------------------- *


