;----------------------------------------------------------------------------
;
; DESCRIPTION:
;       This function was designed to have my application emulate the 
;       non-destructive shadowing of the PC-TOOLS application. This function
;       was written in Assembly language for speed since, the same function
;       written in Clipper was too slow. The size of this function could be
;       reduced by re-writing the SET_CUR_POSITION, READ_CHARACTER, and 
;       WRITE_CHARACTER macros as procedures. Note: this will slow it down
;       a tad, since stack manipulation will be involved.
;
; CALLING CONVENTIONS:
;       This function requests the coordinates of the screen region. The
;       values passed are the same ones passed to the SAVESCREEN() function
;       of clipper.
;       
;               SHADOW(<expN1>, <expN2>, <expN3>, <expN4>)
;
;                      <expN1> = Upper Left Row
;                      <expN2> = Upper Left Column
;                      <expN3> = Lower Right Row
;                      <expN4> = Lower Right Column
;   
; RETURNS:
;       The function returns a numeric value to be evaluated by your program.
;       The values are;
;                       1  = Shadow Drawn
;                       0  = Shadow not Drawn
;
; CAUTIONS:
;       1. If you are using the SAVESCREEN() function to save your screen,
;          remember to save enough screen for the shadow. The shadow will
;          require 1 row and 2 columns.
;
;               save_win = SAVESCREEN(Trow,Tcol,Brow+1,Bcol+2)
;
;       2. If you specify screen cordinated outside the 24 row or 80 column
;          boundry, no shadow will be drawn.
;          
;       3. This function utilizes the standard IBM BIOS services to display
;          the shadow and could possibly create some problems in less-known
;          non-IBM compatiables.
;
; SAMPLE PROGRAM:
;
;       Private Save_Win
;
;       Save_Win = SaveScreen(10,10,21,52)      && save enough for the shadow
;       Shadow(10,10,20,50)                     && draw shadow
;
;       ...
;       do what ya' like
;       ...
;
;       RestScreen(10,10,21,52,Save_Win)        && restore screen
;       Return
;
; CREDITS:
;       This function was written by Reginald B. Walton [72701,2366].
;
;----------------------------------------------------------------------------
	page	66,80
	title	shadow.asm
	public	shadow

	include	\clipper\extenda.mac	; include clipper definitions

;
; These macros can be re-written into procedures for size decrease.
;
set_cur_pos	macro
	mov	ah,02h 			; set cursor position
	mov	bh,cpage		; current display page
	int	10h			; call BIOS
	endm

read_character	macro
	local	outta
	mov	ah,08h			; read character & attribute at cursor
	mov	bh,cpage		; current display page
	int	10h			; call BIOS
					; AH = attribute
					; AL = character

        ; Use this portion if you have drawn a PC-TOOLS like desktop
        ; on your screen using the ASCII character 178.
	cmp	al,178                  ; if the character is the ASCII 178
        jne     outta                   ;  make it the ASCII 176 to emulate
	                                ;  a contrast change. 
        dec     al
        dec     al

outta:
	endm

write_character	macro
	mov	ah,09h			; write character & attribute at cursor
	mov	bh,cpage		; current display page
	mov	bl,00000111b		; BL = attribute (white/black)
	xor	cx,cx			; Times to write character
	mov	cx,1			;  is 1
	int	10h
	endm

dgroup	group	dseg			; combine data segment with Clipper's
dseg	segment byte public 'DATA'     	; data segment declaration
	toprow	db	0               ; top row
	topcol	db	0               ; top column
	botrow	db	0               ; bottom row
	botcol	db	0               ; bottom column
	cpage	db	0 		; current page	
dseg	ends


cseg	segment byte public 'CODE'      ; declare code segment
	assume	cs:cseg,ds:dgroup


shadow	proc	far			; start or routine
	push	bp 			; set up stack addressability   			; save Clipper's registers       		      
   	mov   	bp,sp    			
   	push  	es       		; save registers
	push	ds
	push	di
	push	si

    	get_pcount     			; How many parameters?
    	cmp   	ax,4  			; are there 4 parameters?
    	je    	allok 			; yes there are 4
 	
 	xor	ax,ax			; clear ax register for 0
                                        ;  return code
    	jmp   	exit   			; no , return to clipper
 
 
 allok:
 	get_int 1 			; Get the first parameter
 	mov	toprow, al		; store it in TROW
 
 	get_int 2			; Get the second parameter
 	mov	topcol, al		; store it in TCOL
 
 	get_int 3			; Get the third parameter
 	mov	botrow, al		; store it in BROW
 
 	get_int 4			; get the forth parameter
 	mov	botcol, al		; store it in BCOL
 
 get_current_page:			; get the current display page
 	mov	ah,0fh			; and save it for future reference
 	int	10h
 	mov	cpage,bh
 
 verti_shadow:				; draw vertical shadow
 	mov	dh,botrow 		; start at the bottom row
 	inc	dh			;  plus 1
 
 	cmp	dh,24			; will the shadow be past the last row
 	jg	hori_shadow  		; yes, then don't draw the verti shadow
 
 	mov	dl,topcol		; start at the top column
 					; increment the column inside loop
 	xor	cx,cx			; clear CX
 	mov	cl,botcol 		; length of vertical shadow is 
 	inc	cx			;  the bottom column plus 1
 	xor	ax,ax			;  minus the top column
 	mov	al,topcol
 	sub	cx,ax
 
 @loop1: 				; This the loop for the vertical line
 	push	ax			; save registers
 	push	bx
 	push	cx
 	inc 	dl			; position on next column
 	push	dx			; save current row and column
 
 	set_cur_pos			; set cursor position
 	read_character 			; read character at position
 	write_character			; write new attribute at position
 
 	pop	dx			; restore registers
 	pop	cx
 	pop	bx
 	pop	ax			
 
 	loop	@loop1
 
 
 Hori_shadow:				; draw horzontal shadow
 	mov	dh,toprow		; start at top row, increment inside loop
 
 	mov	dl,botcol 		; start at bottom column 
 	inc	dl			;  plus 1
 
 	cmp	dl,80			; will the shadow be past the last column
 	jge	exit	  		; yes, then don't draw the verti shadow
 
 	xor	cx,cx			; clear CX
 	mov	cl,botrow		; length of hori shadow is 
 	inc	cx			;  the bottom row plus 1
 	xor	ax,ax			;  minus the top row
 	mov	al,toprow			
 	sub	cx,ax
 
 @loop2:	      			; This is the loop for the the hori line
 	push	ax			; save registers
 	push	bx
 	push	cx
 	inc 	dh			; position on next row
 	push	dx			; save current row and column
 
 	set_cur_pos			; set cursor position
 	read_character 			; read character at position
 	write_character			; write new attribute at position
 
 	inc	dl			; next column
 	cmp	dl,80			; will the shadow be past the last column
 	jge	past_second_verti 	; yes, then don't draw the second verti shadow
 
 	set_cur_pos			; set cursor position
 	read_character 			; read character at position
 	write_character			; write new attribute at position
 
 past_second_verti:
 	pop	dx			; restore registers
 	pop	cx
 	pop	bx
 	pop	ax			
 
 	loop	@loop2

        xor     ax,ax                   ; clear AX for return code
        mov     ax,1
 
 
exit:
	pop	si			; restore registers
	pop	di
	pop	ds
	pop	es
	pop	bp

	ret_int  ax 			; Return the value in AX

  	ret   				; Go on back to Clipper

shadow	endp

cseg	ends
	end
