* Program....: The Colour Converter				 ͻ
* Author.....: Dave Bruce - CIS 76127,274			  CLRATTR.EXE 
* Date.......: January 1989					 ͼ
* Comments...: This is the result of a lazy afternoon.	I was in need of a
*	     : quick and simple way of calculating equivilants of dBASE/
*	     : Clipper colour codes in numeric form.  Realising quickly that
*	     : no such method existed, I set out and wrote one.  Critisize
*	     : if you must, but it does, however, work.
*	     :
*	     : Dave Bruce, Guelph Ontario, January 1989.

set bell off
set confirm on

clear

@  1, 0 say "ͻ   The Colour Converter"
@  2, 0 say " Colour   Code "
@  3, 0 say "Ķ"
@  4, 0 say " Black     N      Colour string:"
@  5, 0 say " Blue      B   "
@  6, 0 say " Green     G   "
@  7, 0 say " Cyan      BG  "
@  8, 0 say " Red       R   "
@  9, 0 say " Magenta   BR  "
@ 10, 0 say " Brown     GR  "
@ 11, 0 say " White     W   "
@ 12, 0 say "ͼ"
@ 23, 0 to 23,79
@ 24, 0 say "Public Domain by Dave Bruce - CIS 76127,274                         January 1989"

do while lastkey() <> 27
	@  7,21
	@  8,21
	@ 10,21
	colour_string = space(10)
	@  5,21 get colour_string picture "@!"
	read
	if lastkey() <> 27
			attribute = colour_attr(colour_string)
		@  8,21
		if attribute < 0
			@  8,21 say "Invalid Colour String."
		else
			@  7,21 say "Equivilant Colour Attribute:"
			@  8,21 say ltrim(str(attribute))
		endif
		@ 10,21 say "Press any key to continue, Esc to exit."
		inkey(0)
	endif
enddo
@ 13, 0 clear
@ 15, 0
return

****************************************

function colour_attr
private error, start, string, char, fore, back, attr
parameter start
*
* Function....: COLOUR_ATTR
* Author......: Dave Bruce - CIS 76127,274
* Date........: January 1989
* Parameter...: Any colour string in dBASE letter codes.
* Purpose.....: Calculate an equivilant attribute number for a given string.
* Syntax......: <varN1> = colour_attr(<varC1>)
*		where: <varN1> is any numeric variable available for assignment
*		       <varC1> is any valid colour string.
* Returns.....: 0-255 - Valid colour string entered, attribute value returned
*		-1    - Invalid colour string entered, function aborted
error  = .f.
start  = ltrim(trim(start))
string = start
char   = ""
fore   = ""
back   = ""
attr   = 0

if len(string) > 0
	loop = .t.
else
	loop  = .f.
	error = .t.
endif

do while loop .and. .not. error
	char   = substr(string,1,1)
	if len(string) = 1
		string = ""
	else
		string = iif(len(string)=1,"",substr(string,2))
	endif
	if char $ "/,"
		loop = .f.
	else
		if .not. char $ "+*RGBNWIU"
			error = .t.
		else
			fore = fore + char
			if len(string) = 0
				loop = .f.
			endif
		endif
	endif
enddo

if len(string) > 0 .and. .not. error
	loop = .t.
	do while loop .and. .not. error
		char   = substr(string,1,1)
		if len(string) = 1
			string = ""
		else
			string = iif(len(string)=1,"",substr(string,2))
		endif
		if char $ "/,"
			loop = .f.
		else
			if .not. char $ "RGBNW"
				error = .t.
			else
				back = back + char
				if len(string) = 0
					loop = .f.
				endif
			endif
		endif
	enddo
endif

if .not. error
	do case
	case "BG" $ fore                && Cyan
		attr = 3
	case "BR" $ fore                && Magenta
		attr = 5
	case "GR" $ fore                && Brown (Yellow)
		attr = 6
	case "N" $ fore                 && Black
		attr = 0
	case "B" $ fore .or. "U" $ fore         && Blue or Mono Underline
		attr = 1
	case "G" $ fore                 && Green
		attr = 2
	case "R" $ fore                 && Red
		attr = 4
	case "W" $ fore                 && White
		attr = 7
	case "I" $ fore                 && Mono Inverted (Black on White)
		attr = 112
	endcase
	if attr <= 15			&& Only if not Underlined or Inverted
		if "+" $ fore                   && Check for High Intensity
			attr = attr + 8
		endif
		if "*" $ fore                   && Check for Blinking
			attr = attr + 128
		endif
	endif
	if .not. fore $ "UI"            && Background only if not Underlined
		do case 		&& or Inverted
		case "BG" $ back                && Cyan
			attr = attr + 48
		case "BR" $ back                && Magenta
			attr = attr + 80
		case "GR" $ back                && Brown (Yellow)
			attr = attr + 96
		case "N" $ back                 && Black
			attr = attr + 0
		case "B" $ back                 && Blue
			attr = attr + 16
		case "G" $ back                 && Green
			attr = attr + 32
		case "R" $ back                 && Red
			attr = attr + 64
		case "W" $ back                 && White
			attr = attr + 112
		endcase
	endif

	return(attr)

else
	return(-1)
endif
