
* Copyright (c)  1987, 1988 by DONNAY Software Designs

*******************
* Program: _dcclr.prg
* Author : Roger J. Donnay
* Date   : Jan 5, 1989
* Notes  : COLOR_SEL() function, color configuration, COLORARRAY() function
********************

PRIVATE save_code,junk,code,_update
_update=.f.
PARAMETERS _update

DO WHILE .T.
  SET COLOR TO
  CLEAR
  IF _update
    code=_D_C_MENU(12,10,19,70,'SELECT MENU TO CHANGE COLOR - ESCAPE TO ABORT',;
    'C = General Data Menus',;
    'D = Memo Windows',;
    'E = Pop-up Menus',;
    'F = Exploding Windows',;
    'G = Warning Boxes',;
    'X = EXIT and Save')
  ELSE
    code=_D_C_MENU(9,10,19,70,'SELECT MENU TO CHANGE COLOR - ESCAPE TO ABORT',;
    'A = MAIN Dot Prompt',;
    'B = dBUGGER Dot Prompt',;
    'C = General Data Menus',;
    'D = Memo Windows',;
    'E = Pop-up Menus',;
    'F = Exploding Windows',;
    'G = Warning Boxes',;
    'H = Source Code Boxes',;
    'X = EXIT and Save')
  ENDIF
  DO CASE
    CASE LASTKEY()=27 
      EXIT

    CASE code='A' .AND. !_update
      _D_C_COLOR(_d_c_color[1])
      CLEAR
      @ 24,0 SAY '. This is the MAIN dot prompt.   C = Change color,  X = No Changes'
      IF UPPER(CHR(INKEY(0)))='C'
        _d_c_color[1]=COLOR_SEL(13,_d_c_color[1],'MAIN DOT PROMPT')
      ENDIF

    CASE code='B' .AND. !_update
      _D_C_COLOR(_d_c_color[14])
      CLEAR
      @ 24,0 SAY ': This is the dBUGGER dot prompt.   C = Change color,  X = no changes'
      IF UPPER(CHR(INKEY(0)))='C'
        _d_c_color[14]=COLOR_SEL(13,_d_c_color[14],'dBUGGER DOT PROMPT')
      ENDIF

    CASE code='C'
      save_code=code
      SET COLOR TO
      CLEAR
      junk=''
      DO WHILE .T.
        KEYBOARD 'Q'
        DBCHOICE(0,3,9,76,;
        ' This is the Menu Bar',;
        ' This is the Heading Bar',;
        ' This is the Title',;
        _d_c_color[2],_d_c_color[3],_d_c_color[6],_d_c_color[4],_d_c_color[5],;
        '"This is the data select bar"','junk','junk','junk',;
        7,70,70,70,.t.,.t.,.t.,.f.)
        _D_C_COLOR(_d_c_color[3])
        @ 5,11 SAY 'This is the Data Window'
        _D_C_MENU(16,15,23,45,'SELECT COLOR TO CHANGE',;
        'M = Menu bar and Title',;
        'H = Heading bar',;
        'F = Frame and Lines',;
        'D = Data window',;
        'B = Data Select bar',;
        'X = No more changes')
        DO CASE
          CASE code='M'
            _d_c_color[5]=COLOR_SEL(13,_d_c_color[5],'MENU BAR AND TITLE')
          CASE code='H'
            _d_c_color[4]=COLOR_SEL(13,_d_c_color[4],'HEADING BAR')
          CASE code='F'
            _d_c_color[2]=COLOR_SEL(13,_d_c_color[2],'FRAME AND LINES')
          CASE code='D'
            _d_c_color[3]=COLOR_SEL(13,_d_c_color[3],'DATA WINDOW')
          CASE code='B'
            _d_c_color[6]=COLOR_SEL(13,_d_c_color[6],'DATA SELECT BAR')
          CASE code='X'
            EXIT
        ENDCASE
        code=save_code
      ENDDO

  CASE code = 'E'
    DO WHILE .T.
      code=_D_C_MENU(18,48,23,77,'THIS IS A POP-UP MENU',;
        'F = Frame',;
        'M = Menu Items',;
        'B = Select Bar',;
        'X = No more changes')
      DO CASE
        CASE code='F'
          _d_c_color[7]=COLOR_SEL(13,_d_c_color[7],'POPUP MENU FRAME')
        CASE code='M'
          _d_c_color[8]=COLOR_SEL(13,_d_c_color[8],'POPUP MENU ITEMS')
        CASE code='B'
          _d_c_color[9]=COLOR_SEL(13,_d_c_color[9],'POPUP SELECT BAR')
        CASE code='X'
          EXIT
      ENDCASE
    ENDDO

  CASE code = 'F'
    DO WHILE .T.
      code=' '
      _D_C_EXPL(2,10,9,70)
      @ 3,12 SAY 'THIS IS AN EXPLODING WINDOW'
      @ 4,12 SAY 'F = Change Frame Color'
      @ 5,12 SAY 'C = Change Contents Color'
      @ 6,12 SAY 'X = No more changes'
      @ 8,12 SAY 'Enter Selection ' GET code PICT '!'
      READ
      DO CASE
        CASE code='F'
          _d_c_color[12]=COLOR_SEL(13,_d_c_color[12],'EXPLODING WINDOW FRAME')
        CASE code='C'
          _d_c_color[13]=COLOR_SEL(13,_d_c_color[13],'EXPLODING WINDOW CONTENTS')
        CASE code='X'
          EXIT
      ENDCASE
    ENDDO

  CASE code = 'G'
    DO WHILE .T.
      code=' '
      _DCEXPLODE(2,10,9,70,_d_c_color[15],_d_c_color[16])
      @ 3,12 SAY 'THIS IS A WARNING AND ERROR WINDOW'
      @ 4,12 SAY 'F = Change Frame Color'
      @ 5,12 SAY 'C = Change Contents Color'
      @ 6,12 SAY 'X = No more changes'
      @ 8,12 SAY 'Enter Selection ' GET code PICT '!'
      READ
      DO CASE
        CASE code='F'
          _d_c_color[15]=COLOR_SEL(13,_d_c_color[15],'WARNING WINDOW FRAME')
        CASE code='C'
          _d_c_color[16]=COLOR_SEL(13,_d_c_color[16],'WARNING WINDOW CONTENTS')
        CASE code='X'
          EXIT
      ENDCASE
    ENDDO

  CASE code = 'D'
    DO WHILE .T.
      _DCEXPLODE(2,20,10,60,_d_c_color[10],_d_c_color[11],.f.)
      _D_C_COLOR(_d_c_color[10])
      @ 2,29 SAY CHR(180)+' THIS IS A MEMO WINDOW '+CHR(195)
      code=' '
      @ 4,22 SAY 'F = Change Frame Color'
      @ 5,22 SAY 'T = Change Text Color'
      @ 6,22 SAY 'X = No more changes'
      @ 8,22 SAY 'Enter Selection ' 
      @ 8,38 GET code PICT '!'
      READ
      DO CASE
        CASE code='F'
          _d_c_color[10]=COLOR_SEL(13,_d_c_color[10],'MEMO WINDOW FRAME')
        CASE code='T'
          _d_c_color[11]=COLOR_SEL(13,_d_c_color[11],'MEMO WINDOW TEXT')
        CASE code='X'
          EXIT
      ENDCASE
    ENDDO

  CASE code = 'H' .AND. !_update
    _d_c_clr1=SUBSTR(_d_c_color[20],1,1)
    _d_c_clr2=SUBSTR(_d_c_color[20],2,1)
    DO WHILE .T.
      _DCEXPLODE(0,20,14,79,_d_c_color[17],_d_c_color[18],.f.)
      _D_C_COLOR(_d_c_color[17])
      @ 0,33 SAY CHR(180)+' THIS IS THE SOURCE CODE WINDOW '+CHR(195)
      _D_C_COLOR(_d_c_color[18]+','+_d_c_color[19])
      _choice=1
      @ 4,22 PROMPT '  F = Change Frame Color'
      @ 5,22 PROMPT '  T = Change Text Color'
      @ 6,22 PROMPT '  S = Change Select Bar Color'
      @ 7,22 PROMPT '  X = No more changes'
      MENU TO _choice
      DO CASE
        CASE _choice=1
          _d_c_color[17]=COLOR_SEL(13,_d_c_color[17],'SOURCE WINDOW FRAME')
        CASE _choice=2
          _d_c_color[18]=COLOR_SEL(13,_d_c_color[18],'SOURCE WINDOW TEXT')
          _D_C_COLOR(_d_c_color[18])
          @0,0 SAY ' '
          _d_c_clr1=SUBSTR(SAVESCREEN(0,0,0,0),2,1)
        CASE _choice=3
          _d_c_color[19]=COLOR_SEL(13,_d_c_color[19],'SOURCE WINDOW SELECT BAR')
          _D_C_COLOR(_d_c_color[19])
          @0,0 SAY ' '
          _d_c_clr2=SUBSTR(SAVESCREEN(0,0,0,0),2,1)
        CASE _choice=4
          _d_c_color[20]=_d_c_clr1+_d_c_clr2
          EXIT
      ENDCASE
    ENDDO

  CASE code='X'
    FOR _d_c_count=1 TO 20
      _d_c_var='_d_c__'+LTRIM(STR(_d_c_count,3))
      &_d_c_var=_d_c_color[_d_c_count]
    NEXT
    _d_c_file=_d_c_envir+'DCCOLOR'
    SAVE TO &_d_c_file ALL LIKE _d_c__*
    RELEASE ALL LIKE _d_c__*
    EXIT

  ENDCASE
ENDDO
SET CURS ON
RETURN



***********************************
* COLOR_SEL()
*
* Select a color from a lookup table
*
* SYNTAX:  COLOR_SEL(<expN1>,<expC1>,<expC2>)
*
*  <expN1> = Number of top display row
*  <expC1> = DEFAULT color string
*  <expC2> = Title
*
*  Returns: String value of Selected color if exited with 'X'
*           Null string if exited with ESCape

FUNCTION color_sel

_srow=10
_ccolor=''
_cname=''

PRIVATE _row,_col,_code,_inkey,_page,;
        _inten,_colrcolor,_colorscrn,_paintscrn,_compcolor,_start,;
        _blink,_colsave,_rowsave

PARAMETERS _srow,_ccolor,_cname

_colrcolor=SETCOLOR()
_code=' '
STORE 0 TO _inkey
_colorscrn=_D_C_EXPL(_srow,5,_srow+9,75,;
       'Select Color Below '+IIF(EMPTY(_cname),'','for ')+_cname)
_D_C_COLOR(_d_c_color[12])
@ _srow+9,16 SAY CHR(180)+' '+;
CHR(26)+' '+CHR(27)+' '+CHR(24)+' '+CHR(25)+;
' PgUp PgDn   X = EXIT   ESCape = ABORT '+CHR(195)
STORE .t. TO _start,_paintscrn
_page=1
IF '+'$_ccolor
  _page=2
ENDIF
IF '*'$_ccolor
  _page=_page+2
ENDIF
DO WHILE .t.
  _inten=.f.
  _blink=.f.
  IF _page=2 .OR. _page=4
    _inten=.t.
  ENDIF
  IF _page=3 .OR. _page=4
    _blink=.t.
  ENDIF
  IF _paintscrn
    _paintscrn=.f.
    _colsave=11
    _rowsave=_srow+1
    _D_C_COLOR(_d_c_color[13])
    @ _srow+1,6 CLEAR TO _srow+8,74
    FOR _col=11 TO 67 STEP 8
      FOR _row=_srow+1 TO _srow+8
        SET COLOR TO
        _compcolor=;
         _D_C_CLRCH(_row-_srow-1,1)+IIF(_inten,'+','')+;
         IIF(_blink,'*','')+'/'+_D_C_CLRCH((_col-11)/8,1)
        SET COLOR TO &_compcolor
        @ _row,_col SAY '<*'+CHR(177)+CHR(176)+'-'
        IF _ccolor=_compcolor .AND. _start
          _start=.f.
          _colsave=_col
          _rowsave=_row
        ENDIF
      NEXT _row
    NEXT _col
    _col=_colsave
    _row=_rowsave
  ENDIF
  _D_C_COLOR('GR+')
  @ _row,_col-2 SAY '-'+CHR(16)
  _D_C_COLOR(_d_c_color[13])
  DISP_TIME(0,0,'_inkey','_code',.f.)
  @ _row,_col-2 SAY '  '
  DO CASE
    CASE (_code='2' .OR. _inkey=24) .AND. _row<_srow+8 &&Down arrow key
      _row=_row+1
    CASE (_code='8' .OR. _inkey=5) .AND. _row>_srow+1 &&Up arrow key
      _row=_row-1
    CASE (_code='6' .OR. _inkey=4) .AND. _col<67 &&Right arrow key
      _col=_col+8
    CASE (_code='4' .OR. _inkey=19) .AND. _col>11 &&Left arrow key
      _col=_col-8
     * Page up or page down
    CASE _inkey=3 .OR. _code='3' 
      _paintscrn=.t.
      _page=_page-1
      IF _page=0
        _page=4
      ENDIF
    CASE _inkey=18 .OR. _code='9'
      _paintscrn=.t.
      _page=_page+1
      IF _page=5
        _page=1
      ENDIF
    CASE _inkey=27 .OR. _code='X'
      @ 24,0 SAY ''
      _D_C_IMPL(_colorscrn,.f.)
      _D_C_COLOR(_colrcolor)
      SET CURSOR ON
      RETURN IIF(_inkey=27,_ccolor,;
       SUBSTR(_D_C_CLRCH(_row-_srow-1,1)+IIF(_inten,'+','')+;
         IIF(_blink,'*','')+'/'+_D_C_CLRCH((_col-11)/8,1)+'   ',1,7))
  ENDCASE
ENDDO

*
*  EOF COLOR_SEL()
********************

FUNC _d_c_clrch

PARAMETERS _colornum

RETURN TRIM(SUBSTR('N B G BGR RBGRW ',(_colornum*2)+1,2))


FUNC colorarray

PRIVATE _d_c_envir,_update
_update=.f.
_d_c_envir=''
PARAMETERS _update
IF TYPE('_d_c_color')#'A'
  PUBLIC _d_c_color[30]
ENDIF
IF FILE('DCCOLOR.MEM')
  RESTORE FROM dccolor ADDITIVE
  FOR _d_c_count=1 TO 20
    _d_c_var='_d_c__'+LTRIM(STR(_d_c_count,2))
    _d_c_color[_d_c_count]=&_d_c_var
  NEXT
  RELE ALL LIKE _d_c__*
ELSE
  _d_c_color[1]='W+/B'  &&main screen
  _d_c_color[2]='N/W'   &&browse menus frame
  _d_c_color[3]='W+/W'  &&browse menus data
  _d_c_color[4]='W+/RB' &&browse menus header
  _d_c_color[5]='W+/BG' &&browse menus menu bar
  _d_c_color[6]='GR+/R' &&browse menus select bar
  _d_c_color[7]='W+/GR' &&popup menus frame
  _d_c_color[8]='W+/GR' &&popup menus items
  _d_c_color[9]='N/W'   &&popup menus select bar
  _d_c_color[10]='N/W'  &&all memos box
  _d_c_color[11]='W+/B' &&all memos contents
  _d_c_color[12]='GR+/B' &&exploding boxes frame
  _d_c_color[13]='BG+/B' &&exploding boxes contents
  _d_c_color[14]='W+/R' &&dBUGGER main screen
  _d_c_color[15]='GR+/R' &&warning boxes frame
  _d_c_color[16]='GR+/R' &&warning boxes contents
  _d_c_color[17]='N/BG' &&debug boxes frames
  _d_c_color[18]='N/W'  &&debug boxes contents
  _d_c_color[19]='W+/B' &&debug boxes select bar
  _d_c_color[20]=CHR(112)+CHR(31)
ENDIF
IF _update
  DO _dcclr WITH .t.
ENDIF
RETURN .t.

* Copyright (c)  1987, 1988 by DONNAY Software Designs


