parameters srcfile,destfile

&& Author:  Brad Tharalson   72030,3045

#include "fileio.ch"

#define TABWIDTH 2
#define MAXCHK 15

private ii,jj,kk,orgstr,retstr,thandle,pc1,pc2,thand2,ln,indent,curline
private cpy,acomment,nextline,parscnt,pars[120],line,outfile,usemxr,tempfile
declare simple[MAXCHK,2],xarr[120],xcnt,late[MAXCHK,2],cmplx[MAXCHK,2]
declare badlines[200],bdcnt,errmess,inproc

outfile="byhand.txt"   // printer output file
tempfile="mx.prg"
usemxr=.t.   // switch @ commands to use generic printing subsystem
if pcount()=0
  srcfile="testfile.prg"
endif
if pcount()<2
  destfile=tempfile
endif
if !("PRG" $ upper(srcfile))
  srcfile=trim(srcfile)+".prg"
endif
if !("PRG" $ upper(destfile))
  destfile=trim(destfile)+".prg"
endif
if !file(srcfile)
  wait "Source File: "+srcfile+" - Not Found"
  return
endif
cpy=.t.
// @ 5,0 say "Copy Converted File Over Original" get cpy pict "Y"
// read

bdcnt=0
afill(badlines," ")
clear screen
@ 1,0 say "Converting Clipper Style Program "+upper(srcfile)+ ;
  " to dBase for Windows Style"
if destfile=tempfile
  @ 3,0 say "Saving Conversion As Original File"
else
  @ 3,0 say "Saving Conversion As "+upper(destfile)
endif
cnvrt(srcfile,destfile)
if bdcnt>0
  @ 5,0 say "Be Sure To Check File "+upper(outfile)+ ;
    " For A List Of Necessary Corrections"
  devtopr()
  line=0
  @ line,0 say padc("The Following Lines Need To Be Adjusted By Hand",80)
  line++
  line++
  @ line,0 say upper(srcfile)
  line++
  line++
  for ii=1 to bdcnt
    @line,3 say badlines[ii]
    line++
  next
  fcrlf()
  fcrlf()
  eject
  devtoscr()
  // copyfile(outfile,"LPT1")
endif
if cpy .and. tempfile=destfile
  pc1=noext(srcfile,".")
  delfile(srcfile)
  copyfile(destfile,srcfile)
  delfile(destfile)
endif
?
?


function cnvrt(srcfile,destfile)

retstr=""
for ii=1 to MAXCHK
  afill(simple[ii]," ")
  afill(late[ii]," ")
next
&& simple substitions, done first
simple[1,1]="//"
simple[1,2]="&&"
simple[2,1]="!="
simple[2,2]="<>"
simple[3,1]="=="
simple[3,2]="="
simple[4,1]="clear screen"
simple[4,2]="clrscrn()"
simple[5,1]="close all"
simple[5,2]="clozall()"
simple[6,1]="]["
simple[6,2]=","
simple[7,1]="!"
simple[7,2]=".not. "
&& simple substitions, done last
late[1,1]="unlockit"   // unlockit first because lockit is subpart
late[1,2]="mxunlock"
late[2,1]="lockit"
late[2,2]="mxlock"
late[3,1]="dbappend"
late[3,2]="mxappend"
late[4,1]="append blank"
late[4,2]="mxappend()"
late[5,1]="dbseek("
late[5,2]='mxseek(" ",'
late[6,1]="dbsetorder("
late[6,2]='mxsetorder(" ",'
late[7,1]="mxlock(."
late[7,2]='mxlock(" ",.'
&& complex substitions of form emp->(lockit())
cmplx[1,1]="unlockit"
cmplx[1,2]="mxunlock"
cmplx[2,1]="lockit"
cmplx[2,2]="mxlock"
cmplx[3,1]="dbappend"
cmplx[3,2]="mxappend"
cmplx[4,1]="dbseek"
cmplx[4,2]="mxseek"
cmplx[5,1]="clozdbf"
cmplx[5,2]="mxclose"
cmplx[6,1]="dbsetorder"
cmplx[6,2]="mxsetorder"
cmplx[7,1]="eof"
cmplx[7,2]="mxeof"
cmplx[8,1]="dbskip"
cmplx[8,2]="mxskip"
cmplx[9,1]="recno"
cmplx[9,2]="mxrecno"
cmplx[10,1]="dbgobottom"
cmplx[10,2]="mxbottom"
cmplx[11,1]="dbgotop"
cmplx[11,2]="mxtop"
cmplx[12,1]="dbgoto"
cmplx[12,2]="mxgoto"
thandle=fopen(srcfile)
thand2=fcreate(destfile)
tst=freadln(thandle)
curline=1
inproc=.t.
nextline=.f.
do while .not. feof(thandle)
  fixline()
  tst=freadln(thandle)
  curline++
enddo
fixline()
fclose(thandle)
fclose(thand2)


function fixline

local tt2,tt3,jj,ii,kk,mm

  indent=0
  if len(tst)>0
    orgstr=tst
    retstr=""
    for ii=1 to len(orgstr)
      tt2=substr(orgstr,ii,1)
      if asc(tt2)=9  // tab key
        tt2=space(TABWIDTH)
      endif
      retstr=retstr+tt2
    next
    orgstr=retstr
    setindent(orgstr)
    retstr=ltrim(retstr)
    // ++ option
    if "++" $ retstr .and. .not. ("+++" $ retstr)
      ii=at("++",retstr)
      pc1=substr(retstr,1,ii-1)
      retstr=substr(retstr,1,ii-1)+"="+ltrim(pc1)+"+1"
    endif
    // -- option
    if "--" $ retstr .and. .not. ("---" $ retstr)
      ii=at("--",retstr)
      pc1=substr(retstr,1,ii-1)
      retstr=substr(retstr,1,ii-1)+"="+ltrim(pc1)+"+1"
      retstr=pc1+"="+ltrim(pc1)+"-1"
    endif
    // += option
    if "+=" $ retstr
      split(retstr,"+")
      pc1=pars[1]
      split(retstr,"=")
      pc2=pars[2]
      retstr=pc1+"="+ltrim(pc1)+"+("+pc2+")"
    endif
    // -= option
    if "-=" $ retstr
      split(retstr,"-")
      pc1=pars[1]
      split(retstr,"=")
      pc2=pars[2]
      retstr=pc1+"="+ltrim(pc1)+"-("+pc2+")"
    endif
    // *= option
    if "*=" $ retstr
      split(retstr,"*")
      pc1=pars[1]
      split(retstr,"=")
      pc2=pars[2]
      retstr=pc1+"="+ltrim(pc1)+"*("+pc2+")"
    endif
    // /= option
    if "/=" $ retstr
      split(retstr,"/")
      pc1=pars[1]
      split(retstr,"=")
      pc2=pars[2]
      retstr=pc1+"="+ltrim(pc1)+"/("+pc2+")"
    endif
    for ii=1 to MAXCHK
      if !empty(simple[ii,1])
        if ii=7 .and. "pict" $ retstr
          loop
        endif
        jj=at(simple[ii,1],retstr)
        do while jj>0
          pc1=""
          pc2=""
          if jj>1
            pc1=substr(retstr,1,jj-1)
            if len(retstr)>(jj-1+len(simple[ii,1]))
              pc2=substr(retstr,jj+len(simple[ii,1]),120)
            endif
          else
            pc2=substr(retstr,len(simple[ii,1])+1,120)
          endif
          retstr=pc1+simple[ii,2]+pc2
          jj=at(simple[ii,1],retstr)
        enddo
      endif
    next
    // save the comment and clear it
    acomment=" "
    ii=at("&&",retstr)
    do case
      case ii=1
        acomment=retstr
        retstr=""
      case ii>1
        acomment=" "+substr(retstr,ii,120)
        retstr=trim(substr(retstr,1,ii-1))
    endcase
    if "set ord" $ retstr
      split(retstr,"s")
      retstr=pars[1]+'mxsetorder(" ",'+ltrim(str(procint(retstr),2,0))+')'
    endif
    if "seek " $ retstr
      split(retstr,"k")
      retstr='mxseek(" ",'+ltrim(trim(pars[2]))+')'
    endif
    // now for more complicated stuff
    if ":=" $ retstr .and. "->" $ retstr
      split(retstr,":")
      pc1=pars[1]
      orgstr=ltrim(pc1)
      ii=at(":=",retstr)
      pc2=substr(retstr,ii+2,120)
      retstr="replace "+orgstr+" with "+pc2
    endif
    if "->(" $ retstr
      for jj=1 to MAXCHK
        if !empty(cmplx[jj,1])
          split(retstr," ")
          retstr=""
          for ii=1 to parscnt
            xarr[ii]=pars[ii]
          next
          xcnt=parscnt
          for ii=1 to xcnt
            if cmplx[jj,1] $ xarr[ii]
              split(xarr[ii],"-")
              pc1=pars[1]
              if "()" $ xarr[ii]  // no param
                xarr[ii]=cmplx[jj,2]+'("'+pc1+'")'
              else   // has a param
                split(xarr[ii],"(")
                xarr[ii]=pars[3]
                split(xarr[ii],")")
                pc2=pars[1]
                xarr[ii]=cmplx[jj,2]+'("'+pc1+'",'+pc2+')'
              endif
            endif
            if ii<xcnt
              retstr=retstr+xarr[ii]+" "
            else
              retstr=retstr+xarr[ii]
            endif
          next
        endif
      next
    endif
    for ii=1 to MAXCHK
      if !empty(late[ii,1])
        if ii=7 .and. "pict" $ retstr
          loop
        endif
        jj=at(late[ii,1],retstr)
        do while jj>0
          pc1=""
          pc2=""
          if jj>1
            pc1=substr(retstr,1,jj-1)
            if len(retstr)>(jj-1+len(late[ii,1]))
              pc2=substr(retstr,jj+len(late[ii,1]),120)
            endif
          else
            pc2=substr(retstr,len(late[ii,1])+1,120)
          endif
          retstr=pc1+late[ii,2]+pc2
          jj=at(late[ii,1],retstr)
        enddo
      endif
    next
    pc1=ltrim(upper(retstr))
    if "PROCEDU" $ pc1
      inproc=.t.
    endif
    if "FUNCTIO" $ pc1
      inproc=.f.
    endif
    if bdcnt<200
      errmess=" "
      // convert @ ?,? say ? to mxr(?,?,?)
      if usemxr
        pc2=trim(pc1)
        if substr(pc1,1,1)=="@" .and. !(" GET " $ pc1) .and. "SAY" $ pc1
          if substr(pc2,len(pc2),1)==";"
            errmess="Convert to mxr()"
          else
            // check for @3,5 style, convert to @ 3,5
            if substr(pc1,2,1)<>" "
              retstr="@ "+substr(retstr,2,120)
            endif
            jj=at(" say ",retstr)
            kk=at(", ",retstr)
            if kk>0 .and. kk<jj
              retstr=stuff(retstr,kk,2,",")
            endif
            jj=at(" say ",retstr)
            kk=at("  ",retstr)
            if kk>0 .and. kk<jj
              retstr=stuff(retstr,kk,2," ")
            endif
            split(retstr," ")
            pc1=""
            jj=at(" say ",retstr)
            kk=at(" picture",retstr)
            mm=len(" picture")
            if kk=0
              kk=at(" pict",retstr)
              mm=len(" pict")
            endif
            tt3=" "
            if kk=0
              kk=len(retstr)
              tt2=substr(retstr,jj+5,kk-(jj+5)+1)
            else
              tt2=substr(retstr,jj+5,kk-(jj+5)+1)
              tt3=trim(substr(retstr,kk+mm,len(retstr)))
            endif
            for ii=1 to parscnt
              pc2=pars[ii]
              if !empty(pars[ii])
                do case
                  case pc2="@"
                    pc2="mxr("
                  case pc2="say"
                    pc2=","
                    if !empty(tt3)
                      for jj=ii+1 to parscnt
                        pars[jj]=" "
                      next
                      pars[ii+1]="transform("+trim(tt2)+","+ltrim(trim(tt3))+")"
                    else
                      for jj=ii+1 to parscnt
                        pars[jj]=" "
                      next
                      pars[ii+1]=trim(tt2)
                    endif
                endcase
                if ii<parscnt
                   pc1=pc1+pc2
                endif
              endif
            next
            pc1=pc1+trim(pc2)+")"
            retstr=pc1
          endif
        endif
      endif
      pc1=upper(retstr)
      if "LOCAL" $ pc1 .and. ("[" $ pc1 .or. "{" $ pc1)
        errmess="Use Declare"
      endif
      if "PRIVATE" $ pc1 .and. ("[" $ pc1 .or. "{" $ pc1)
        errmess="Use Declare"
      endif
      if "STATIC" $ pc1 .and. ("[" $ pc1 .or. "{" $ pc1)
        errmess="Use Declare"
      endif
      if "PUBLIC" $ pc1 .and. ("[" $ pc1 .or. "{" $ pc1)
        errmess="Use Public Array"
      endif
      if "AFILL" $ pc1 .and. "[" $ pc1
        errmess="Delete brackets"
      endif
      if "AADD" $ pc1 .and. "[" $ pc1
        errmess="Change AADD to AGROW"
      endif
      if "FOUND()" $ pc1 .and. "->" $ pc1
        errmess="Can't Use found() in ->()"
      endif
      if "DESCEND()" $ pc1
        errmess="Can't Use descend() in dBase"
      endif
      if ")->" $ pc1
        errmess="Use Macro (&) With Priv. Var"
      endif
      if "@" $ pc1 .and. !("mxr(" $ pc1)
        jj=at("@",pc1)   // check for var passing by referece using "@"
        if jj>1 .and. numsequal(procint(substr(pc1,jj+1,2)))
          errmess="Change to: do ? with ?"
        endif
      endif
      if "NIL" $ pc1
        errmess="Use pcount()"
      endif
      if " % " $ pc1
        errmess="Use mod()"
      endif
      if ":=" $ pc1 .and. !("->" $ pc1)
        for ii=1 to 20
          jj=at(":=",retstr)
          if jj>0
            retstr=stuff(retstr,jj,2,"=")
          else
            exit
          endif
        next
      endif
      pc1=trim(pc1)
      if !inproc .and. "RETURN" $ pc1
        if trim(pc1)=="RETURN"   // no return value, an error in functions
          retstr="return 0"
        endif
      endif
      if !empty(errmess)
        bdcnt++
        pc1=ltrim(retstr)
        badlines[bdcnt]=str(curline,5)+":  "+ ;
          padr(substr(pc1,1,35),35)+" > "+errmess
      endif
    endif
    retstr=trim(retstr)
    if substr(retstr,len(retstr)-1,2)==";)"
      retstr=substr(retstr,1,len(retstr)-1)
      nextline=.t.
    else
      if nextline
        retstr=retstr+")"
        nextline=.f.
      endif
    endif
    fwrite(thand2,space(indent)+retstr+acomment+chr(13)+chr(10))
  else
    fwrite(thand2,chr(13)+chr(10))
  endif


function setindent(ostr)

  local tt

  indent=0
  tt=ltrim(ostr)
  indent=len(ostr)-len(tt)
  return indent


// the following functions are used extensively in other code

function noext(fname)  // NOEXT  return file name minus extension

local ii

  if fname=NIL
    return nil
  endif
  ii=at(".",fname)
  if ii>1
    return substr(fname,1,ii-1)
  else
    return fname
  endif


function copyfile( cpyn1,cpyn2 )   && COPYFILE

  copy file (cpyn1) to (cpyn2)


function delfile(fname)   && DELFILE

  if file(fname)
    delete file (fname)
  endif


function fcrlf(cnt)   && FCRLF   handy for flushing last line of forms/checks

  @ prow(),pcol() say chr(13)+chr(10)


function devtopr  && used for reports involving @"s   DEVTOPR

  set printer to &outfile
  set device to printer
  setprc(0,0)
  return .t.


function devtoscr  && DEVTOSCR

  setprc(0,0)
  set device to screen
  set printer to
  return .t.


function split( orgline,pchar,altarray,altcnt )   && SPLIT

  local aline,tline,ii,jj,kk,ats[80],acnt

  if pchar=NIL
    pchar=":"
  endif
  aline=trim(orgline)
  jj=len(aline)
  afill(ats,0)
  if altarray==NIL
    afill(pars,"")
    parscnt=0
    if jj>0
      parscnt=1
      ats[parscnt]=0
      for ii=1 to jj
        if substr(aline,ii,1)==pchar
          parscnt++
          ats[parscnt]=ii
        endif
      next
      ats[parscnt+1]=jj+1
      for ii=1 to parscnt
        kk=ats[ii+1]-ats[ii]-1
        if kk>0
          pars[ii]=substr(aline,ats[ii]+1,kk)
        endif
      next
    endif
  else
    afill(altarray,"")
    altcnt=0
    if jj>0
      altcnt=1
      ats[altcnt]=0
      for ii=1 to jj
        if substr(aline,ii,1)==pchar
          altcnt++
          ats[altcnt]=ii
        endif
      next
      ats[altcnt+1]=jj+1
      for ii=1 to altcnt
        kk=ats[ii+1]-ats[ii]-1
        if kk>0
          altarray[ii]=substr(aline,ats[ii]+1,kk)
        endif
      next
    endif
  endif
  return .t.


function freadln( nHandle, nLineLength)  && FREADLN

   local nCurPos, nFileSize, nChrsToRead, nChrsRead
   local cBuffer, cLines, nLines, cDelim, nCount, nEOLPos

   nLines := 1
   cDelim := chr(13) + chr(10)
   if nLineLength==NIL
      nLineLength := 200  && was 80 in sample/fileio.prg
   endif
   nCurPos   := FilePos( nHandle )
   nFileSize := FileSize( nHandle )
   // Make sure no attempt is made to read past EOF
   nChrsToRead := MIN( nLineLength, nFileSize - nCurPos )
   cLines  := ""
   nCount  := 1
   do while (nCount <= nLines) .AND. ( nChrsToRead != 0 )
      cBuffer   := SPACE( nChrsToRead )
      nChrsRead := FREAD( nHandle, @cBuffer, nChrsToRead )
      // Check for error condition
      if ! (nChrsRead == nChrsToRead)
         // Error!
         // In order to stay conceptually compatible:=the other
         // low-level file functions, force the user to check FERROR()
         // (which was set by the FREAD() above) to discover this fact
         //
         nChrsToRead := 0
      endif
      nEOLPos := AT( cDelim, cBuffer )
      // Update buffer and current file position
      if nEOLPos == 0
         cLines  += left( cBuffer, nChrsRead )
         nCurPos += nChrsRead
      else
        if nEOLPos>1
         cLines  += left( cBuffer, ( nEOLPos - 1 ))
        endif
        nCurPos +=(nEOLPos+len(cDelim)-1)
        fseek( nHandle, nCurPos, FS_SET )
      endif
      // Make sure we don't try to read past EOF
      if (nFileSize - nCurPos) < nLineLength
         nChrsToRead := (nFileSize - nCurPos)
      endif
      nCount++
   endDO
   return cLines


function numsequal( n1,n2,decs )  && NUMSEQUAL

&& compare numbers for exact equality to specified places

  local nst1,nst2,width

  width=14
  if n2==NIL
    n2=0
  endif
  if decs==NIL
    decs=4
  endif
  decs++
  nst1=substr(str(n1,width,decs),1,width-1)
  nst2=substr(str(n2,width,decs),1,width-1)
  return nst1==nst2


function procint( nval )   && PROCINT

  local decs,prnum,ii,jj,ist,pastdec,isminus

  prnum=0.00
  pastdec=.f.
  isminus=.f.
  decs=1.0
  for ii=1 to len(nval)
    ist=substr(nval,ii,1)
    if ist="-"
      isminus=.t.
    endif
    if ist="."
      pastdec=.t.
    else
      if ist >= "0" .and. ist <= "9"
        jj=val(ist)
        prnum = prnum * 10.0
        prnum = prnum + jj
        if pastdec
          decs=decs / 10.0
        endif
      endif
    endif
  next
  if isminus
    prnum=(prnum * decs) * -1
  else
    prnum=prnum * decs
  endif
  if !pastdec
    prnum=int(prnum)
  endif
  return prnum


function feof( nhandle )  && FEOF

   return (if(filesize(nhandle) == filepos(nhandle), .T., .F. ))


function filepos(nHandle)  && FILEPOS

  return fseek(nHandle, 0, 1)


function filesize( nHandle )   && FILESIZE

   local nCurrent, nLength

   // save current position
   nCurrent := FilePos(nHandle)
   // Get file length
   nLength := FSEEK(nHandle, 0, 2)
   // Reset file position
   fseek(nHandle, nCurrent)
   return nLength


