#include <stdio.h>
#include <dos2.h>
#include "c:\c5\include\extend.h"
/*

   
   the two useful functions here are DisableSwap and EnableSwap. They do
   the obvious thing...

   Clipper Functions: SWAPON and SWAPOFF return logical (see test code TEST.PRG)
   Useful to stop user from swapping out of Clipper App in middle of reindexing
   or to prevent dreaded deadlock situations which can be introduced via
   DOSSWAP which were heretofore impossible in a multi-user Clipper App....


   DisableSwap returns 1 if successful, 0 if dosswap not installed
   EnableSwap  returns 1 if successful, 0 if dosswap not previously disabled

   Author: David Conway, CIBC Mortage Corp., Toronto Canada
   Clipperized and MSCized by Kevin Burns, CIBC Mortgage Corp, Toronto Canada

   Swap.c is released into the public domain

   Compile the following in Borland C++ using the following compile options

            bcc -c -ml -Z -O -r -f- -i15 -1- -B

   You will require the modified dos.h header "dos2.h" which contain
   the MSC function prototypes for _dos_setvect and _dos_getvect suitably
   modified for Borland C++.

   _dos_setvect and _dos_getvect are the MSC equivalents
   of the Borland functions setvect and getvect.

   Therefore, to link your clipper code you will require LLIBCA.LIB (ugh...)


*/


void far* Detect_Switcher();
void far notify();

void far interrupt hex2f(unsigned bp,unsigned  di,unsigned	si,unsigned  ds,
						unsigned  es,unsigned  dx,unsigned	cx,unsigned  bx,
						unsigned  ax,unsigned  ip,unsigned	cs,unsigned  flags);

/* swapinfo structure, detailing ASYNC API's we support
        -- none at this time --.
*/

struct SWINFO{
	int  word1;
	int  word2;
	int  word3;
	int  word4;
	int  word5;
	int  word6;
}swinfo={10,0,0,0,0,0};

struct SWCALLBACKINFO{
    void far *dd1;
    void (far *notptr)();
    void far *reserved;
	void far* swapinfo;
}cbinfo={NULL,notify,NULL,&swinfo};

static void (far * callback)();
static void (interrupt far *mplex)();
static void (far* swapper)();


CLIPPER SWAPON()
{
_retl(EnableSwap());
}


CLIPPER SWAPOFF()
{
_retl(DisableSwap());
}


int DisableSwap(void)
{
	union REGS regs;
    struct SREGS segregs;
    // use getvect(0x2f) for pure Borland C++
    mplex = _dos_getvect(0x2f);
    if(!mplex)
    {
		/* Error - swap not installed */
		return(0);
    }
    if(!(swapper=(void far *)Detect_Switcher()))
    {
		/* Error - swap not installed */
		return(0);
    }

    callback = (void far *)mplex;
    // use setvect(0x2f,hex2f) for pure Borland C++
    _dos_setvect(0x2f,hex2f);
	return (1);
}

int EnableSwap(void)
{
	if(mplex!=NULL)
    // use setvect(0x2f,mplex) for pure Borland C++
       _dos_setvect(0x2f,mplex);
	else
	   return(0);
	return(1);
}


void far notify()
{
    asm{
		push ds
		mov ax, DGROUP
        mov ds, ax
	}
	asm  pop ds
	asm  mov ax, 1
}

void far* Detect_Switcher ()
{
    asm {
          mov bx, 0
          mov di, 0
          mov es, di
          mov ax, 0x4b02
          int 0x2f
        }
    return(MK_FP(_ES,_DI));
}

void interrupt hex2f(unsigned bp,unsigned  di,unsigned	si,unsigned  ds,
                unsigned  es,unsigned  dx,unsigned  cx,unsigned  bx,
                unsigned  ax,unsigned  ip,unsigned  cs,unsigned  flags)
{
	if(ax==0x4b01)
	{
		asm pushf
		(*callback)();
		cbinfo.dd1=MK_FP(_ES,_BX);
		asm mov ax,ds
		es=_AX;
		asm mov ax, offset cbinfo;
		bx=_AX;
	}
}


