*$CALL,NOMOVELINK,NOSTRCHK,NOSTATABORT
**************************************************************************
*FILENAME: CLPSHELL         Version 1.0                   02/10/89       *
*                                                                        *
*PURPOSE : ALLOW FOR THE EXECUTION OF PROGRAMS VIA DOS EXEX THRU THE     *
*          INTERPROGRAM COMMUNICATION AREA (IPCA) LOCATED AT 40:F0-FF.   *
*                                                                        *
*USAGE   : CLPSHELL TOP_PROG.EXE (OR .COM)                               *
*                                                                        *
*NOTES   : THE .EXE AND/OR .COM FILES MUST BE IN THE CURRENT DIRECTORY.  *
*          FOR FURTHER DETAILS ON THE USE OF THE PROGRAM, SEE THE        *
*          DOCUMENTATION SUPPLIED WITH THE PROGRAM.                      *
*          THIS PROGRAM IS WRITTEN FOR THE REALIA COBOL COMPILER         *
*                                                                        *
*Author  : Paul G. Kurr                                                  *
*                                                                        *
* Send all inquiries to:         or if you prefer,                       *
*                                you may reach me via:                   *
*    Language LightHouse                                                 *
*    Paul G. Kurr                   Language LightHouse BBS              *
*    4150 Megan Road                                                     *
*    Duluth, GA 30136                  404 - 263 - 1151                  *
*                                                                        *
*Copyright: (c) Copyright 1989, Paul G. Kurr all rights reserved.        *
*                                                                        *
*Warranty: No warranties or guarantees are given, either expressly or    *
*          implied.                                                      *
*                                                                        *
*Legal   : In no event will the author be liable for any lost profits,   *
*          lost savings, or any incidental damages or other consequential*
*          damages (real or otherwise), even if the author has been      *
*          advised of the possibility of such damages, or for any claim  *
*          by you (the user) based on a third party claim.               *
*                                                                        *
*          These program(s) and/or routine(s) are released under the     *
*          shareware concept "as is" for use by any and all persons      *
*          and/or corporations.  Copying and/or distribution of these    *
*          program(s) and/or routine(s) is permitted only under the      *
*          following conditions:                                         *
*                 1) it is done so in the original unmodified form,      *
*                 2) that all credits remain fully in-tact.              *
*          Changes to the original source code of said program(s) and/or *
*          routine(s) is permitted for the sole purpose of private use.  *
*          The user also agrees not to distribute any modified form of   *
*          these programs and/or routines without the express written    *
*          consent of the author.                                        *
*                                                                        *
*          Use of these program(s) and/or routines confirms your         *
*          unconditional acceptance of the above conditions.             *
*                                                                        *
*Other   : If you use these program(s) and/or routine(s), and find them  *
*          of value, your "contribution" would be appreciated and inspire*
*          further development of other useful software products.        *
*                                                                        *
*        * REALIA IS A REGISTERED TRADEMARK OF REALIA INC.      *        *
*        * Clipper is a registered trademark of Nantucket Corp. *        *
**************************************************************************
/****************************************
 IDENTIFICATION DIVISION.
*****************************************
 PROGRAM-ID. CLPSHELL.
 AUTHOR. KURR.
 DATE-WRITTEN. 08 FEB, 1989
 DATE-COMPILED.

****************************************
 ENVIRONMENT DIVISION.
*****************************************
  CONFIGURATION SECTION.
*============================
   SOURCE-COMPUTER.          IBM-PC.
   OBJECT-COMPUTER.          IBM-PC.

*============================
 INPUT-OUTPUT SECTION.
*============================
 FILE-CONTROL.
*----------------------------


/***************************************
 DATA DIVISION.
****************************************
 FILE SECTION.
*---------------------------------------


****************************************
 WORKING-STORAGE SECTION.
****************************************
*    WORKING STORAGE 77'S
*=======================================

*=======================================
*    OTHER 01'S
*=======================================

*    SET UP ADDRESS OF IPCA 0040:00F0

 01  WS-MISC-TABLE.
     03  WS-TOP-OF-SHELL         PIC X(16)   VALUE LOW-VALUES.
     03  FILLER                  PIC X       VALUE LOW-VALUE.

     03  WS-PROG-NAME            PIC X(16)   VALUE LOW-VALUES.
     03  FILLER                  PIC X       VALUE LOW-VALUE.

     03  WS-RUN-FLAG             PIC X       VALUE "R".
     88  RUNNING-PROG                    VALUE "R".
     88  TERMINATE-PROG                  VALUE "T".

     03  WS-IPCA-COUNT           PIC S9(4) COMP-5 VALUE 16.

 01  MACHINE-ADDRESS.
     03  ADDRESS-OFFSET      PIC S9(4) COMP-5    VALUE 240.
     03  ADDRESS-SEGMENT     PIC S9(4) COMP-5    VALUE 64.

 01  WAIT-RETURN-CODE.
     03  TERMINATION-TYPE    PIC S9(4) COMP-5.
         88  NORMAL-TERMINATION                  VALUE +0.
         88  CTRL-BREAK-TERMINATION              VALUE +1.
         88  DEVICE-ERR-TERMINATION              VALUE +2.
         88  RESIDENT-TERMINATION                VALUE +3.
     03  PROGRAM-STATUS      PIC S9(4) COMP-5.

 01  DISPLAY-STUFF.
     03  FILLER              PIC X(31)   VALUE
     "CLPSHELL - Clipper shell system".
     03  FILLER              PIC XX      VALUE X"0D0A".
     03  FILLER              PIC X(32)   VALUE
     "(c) Copyright 1989, Paul G. Kurr".
     03  FILLER              PIC XX      VALUE X"0D0A".
     03  FILLER              PIC X(33)   VALUE
     "Langauage LightHouse 404/263-1151".

****************************************
 LINKAGE SECTION.
****************************************

 01  PARAMETER.
     03  PARAMETER-LENGTH            PIC S9(4) COMP-4.
     03  PARAMETER-CHARS.
         05  PARAMETER-CHAR          PIC X
             OCCURS 1 TO 120 TIMES
             DEPENDING ON PARAMETER-LENGTH.

 01  PROGRAM-SEGMENT-PREFIX.
     03  INT-20                      PIC XX.
     03  TOP-OF-MEMORY               PIC XX.
     03  FILLER                      PIC X(6).
     03  TERM-ADDRESS-IP             PIC XX.
     03  TERM-ADDRESS-CS             PIC XX.
     03  CTRL-BRK-ADDRESS-IP         PIC XX.
     03  CTRL-CRK-ADDRESS-CS         PIC XX.
     03  CRITICAL-ERROR-ADDRESS      PIC X(4).
     03  FILLER                      PIC X(22).
     03  ENV-POINTER                 PIC S9(4) COMP-5.
     03  FILLER                      PIC X(34).
     03  DOS-CALL                    PIC XX.
     03  FILLER                      PIC X(10).
     03  UNOPENED-FCB1               PIC X(16).
     03  UNOPENED-FCB2               PIC X(20).
     03  PSP-PARM-LENGTH             PIC XX.
     03  PSP-COMMAND-LINE            PIC X(127).

 01  INTER-PROGRAM-COMM-AREA.
     03  IPCA-CHARS.
         05  IPCA-CHAR       PIC X
             OCCURS 1 TO 16 TIMES
             DEPENDING ON WS-IPCA-COUNT.

/***************************************
 PROCEDURE DIVISION USING PARAMETER.
****************************************

     PERFORM INITIAL-LINE.

     IF RUNNING-PROG
         PERFORM MAIN-LINE UNTIL TERMINATE-PROG.

     STOP RUN.

/=======================================
 INITIAL-LINE.
*=======================================
*    SET UP PROGRAM, CLEAR IPCA.

     DISPLAY DISPLAY-STUFF.

*SET IPCA POINTER UP.

     CALL "MLI_SETLINK" 
         USING MACHINE-ADDRESS INTER-PROGRAM-COMM-AREA.

*CHECK STATUS, TERMINATE IF INVALID PROG
*OR LOAD PROG-NAME INTO SHELL AND NEXT EXEC

     IF PARAMETER-LENGTH < 5
         SET TERMINATE-PROG TO TRUE
     ELSE
         MOVE PARAMETER-CHARS TO WS-PROG-NAME WS-TOP-OF-SHELL.

*SET PSP POINTER UP AND FREE ENVIRONMENT SPACE

     CALL "DOS_GET_PSP_ADDRESS" 
         USING MACHINE-ADDRESS.

     CALL "MLI_SETLINK"
         USING MACHINE-ADDRESS PROGRAM-SEGMENT-PREFIX.

     MOVE 0 TO ADDRESS-OFFSET.
     MOVE ENV-POINTER TO ADDRESS-SEGMENT.

     CALL "DOS_FREE" USING MACHINE-ADDRESS.

*CLEAR IPCA AND PARAMETER LINE.

     MOVE LOW-VALUE TO
          INTER-PROGRAM-COMM-AREA PARAMETER-CHARS.

/=======================================
 MAIN-LINE.
*=======================================

     CALL "DOS_EXEC" USING WS-PROG-NAME PARAMETER-CHARS.

     CALL "DOS_WAIT" USING WAIT-RETURN-CODE.
     MOVE PROGRAM-STATUS TO RETURN-CODE.

     IF NORMAL-TERMINATION
         PERFORM GET-NEXT-PROG
     ELSE
         MOVE WS-TOP-OF-SHELL TO WS-PROG-NAME.

*---------------------------------------
 GET-NEXT-PROG.
*---------------------------------------

     MOVE 16 TO WS-IPCA-COUNT.

     PERFORM CHECK-IPCA
         VARYING TALLY FROM 1 BY 1 
         UNTIL TALLY > 16.

*    IF NOTHING IS IN THE IPCA, AND WS-PROG-NAME = WS-TOP-PROG, 
*        THEN TERMINATE PROGRAM.

     IF WS-IPCA-COUNT < 5
         IF WS-PROG-NAME = WS-TOP-OF-SHELL
             SET TERMINATE-PROG TO TRUE
         ELSE
             MOVE WS-TOP-OF-SHELL TO WS-PROG-NAME
         END-IF
     ELSE
         MOVE IPCA-CHARS TO WS-PROG-NAME.

*---------------------------------------
 CHECK-IPCA.
*---------------------------------------

     IF IPCA-CHAR( TALLY ) = LOW-VALUE
         MOVE TALLY TO WS-IPCA-COUNT
         MOVE 20 TO TALLY.
