#include "Clip_Dev.ch"

/*
   The QUEUE class sets up a first-in-first-out (FIFO) queue.
   Any data type can be pushed or popped.  Any attempt to pop more data
   than is in the queue is ignored and a NIL is returned.
   Compare this to the STACK class.
*/

FUNCTION z_Queue

   DEFINE CLASS Queue
      IMPORT VARIABLES Queue := {}
      EXPORT METHODS ;
	 Push  := { |o,p| AADD( |<o:Queue>|, p[1] ) }, ;
	 Pop   := { |o| Pop(o) }, ;              // Pop item out of queue
	 Depth := { |o| LEN(|<o:Queue>|) }       // Depth of queue
   ENDCLASS

RETURN NIL

STATIC FUNCTION Pop( o )
   LOCAL ret_val := NIL, aQueue
   /*
      If queue is empty ignore the Pop request and return NIL, else remove
      and return the bottom-most value in the queue. (First one pushed.)
   */
   IF LEN(|<o:Queue>|) > 0
      /*
	 The 'aQueue' local variable is required since we cannot
	 access an element of an array instance variable of an object
	 directly.
      */
      aQueue := |<o:Queue>|
      ret_val := aQueue[1]             // Grab the first element
      aQueue := ADEL( aQueue, 1 )      // Remove it & shrink queue
      |<o:Queue>| := ASIZE( aQueue, LEN(aQueue) - 1 )
   ENDIF
RETURN ret_val
