/*
   Sample program to demonstrate Odometer Class.  Creates an instance of
   an ODOMETER called 'meter' and then increments the meter 1001 times
   while displaying the 'Reading'.  Uses the Odometer class as defined
   in the program file 'z_odomet.prg'.
*/

#include "Clip_Usr.ch"

FUNCTION Main
   LOCAL meter, i

   CLEAR SCREEN

   // Declare which class will be used
   ANNOUNCE Class:ODOMETER FROM LIBRARY SOFTWARE_PERSPECTIVES

   meter := |< ODOMETER:New() >|       // Create an instance of ODOMETER

   FOR i := 1 TO 1001
      @ 10, 10 SAY |< meter:Reading >|
      |< meter:Increment() >|
   NEXT i

   ?
   ? "Attempting to assign to the READONLY Instance Variable"
   ? "called 'Reading' gives an Error:"
   ?
   |< meter:Reading >| := " 0.1"

RETURN NIL
