/*
    Example program to demonstrate simple UDO creation and access.
    This example also shows how to use a Trigger code block to force
    an instance variable's value to be within a desired range.  Uses
    the DIGIT class as defined in the program file 'z_Digit.prg'
*/

#include "Clip_Usr.ch"

FUNCTION Main
   LOCAL count,i

   CLEAR SCREEN

   // Declare which classes will be used
   ANNOUNCE Class:Digit FROM LIBRARY SOFTWARE_PERSPECTIVES

   count := |< DIGIT:New() >|          // Create an instance of DIGIT

   // Loop 10 times printing the value of count's Digit and incrementing.
   FOR i := 1 TO 11
       ? "Digit = " + LTRIM(STR( |< count:Digit >| ))
       |< count:Increment() >|
   NEXT i

   ?
   ?

   // Can assign directly to Digit since it is Exportable.
   ? "Assign 4 To Digit gives:"
   ? |< count:Digit >| := 4
   ?

   // Assignment ignored since the trigger code block returned false.
   ? "Assign 11 To Digit gives:"
   ? |<count:Digit>| := 11
   ? "(Because Trigger code block for Digit returned false.)"

RETURN NIL
