#include "Clip_Dev.ch"

/*
   The STACK class sets up a last-in-first-out (LIFO) stack.
   Any data type can be pushed or popped.  Any attempt to pop more data
   than is in the stack is ignored and a NIL is returned.
   Compare this to the QUEUE class.
*/

FUNCTION z_Stack

   DEFINE CLASS Stack
      IMPORT VARIABLES Stack := {}, ;
		       Depth := 0
      EXPORT METHODS ;
	 Push  := { |o,p| AADD( |<o:Stack>|, p[1] ), ;
			  |<o:Depth>|++ }, ;     // Push item onto stack
	 Pop   := { |o| Pop(o) }, ;              // Pop item off stack
	 Depth := { |o| |<o:Depth>| }            // Depth of stack
   ENDCLASS

RETURN NIL

STATIC FUNCTION Pop( o )
   LOCAL ret_val := NIL, aStack
   /*
      If stack is empty ignore the Pop request and return NIL, else remove
      and return the top-most value on the stack.
   */
   IF |<o:Depth>| > 0
      /*
	 The 'aStack' local variable is required since we cannot
	 access the elements of an array instance variable of an
	 object directly.
      */
      aStack := |<o:Stack>|
      ret_val := aStack[LEN(aStack)]             // Grab the top element
      |<o:Stack>| := ASIZE( aStack, LEN(aStack) - 1 )
      |<o:Depth>|--                              // One less item on stack
   ENDIF
RETURN ret_val
