#include "Clip_Dev.ch"

/*
   Class definition for DIGIT.  Shows an example of a TRIGGER which returns
   a logical value.  It will return a logical false (.F.) if an attempt
   is made to assign a value less than 0 and greater than 9.  If this
   happens the assignment will be ignored.  See 'Digit.prg' for an
   example of this.
*/
FUNCTION z_Digit
   DEFINE Class DIGIT
      // Force Digit to be between 0 and 9 with a trigger.
      EXPORT VARIABLES Digit := 0 TRIGGER {|o| |<o:Digit>| >= 0 .AND. ;
					       |<o:Digit>| <= 9 }

      // Add 1 to Digit variable - rolls over at 9 to begin again at 0.
      EXPORT METHODS   Increment := ;
	 { | o | |<o:Digit>| := IIF( |<o:Digit>| == 9, 0, |<o:Digit>| + 1 ) }
   ENDCLASS
RETURN NIL
