#include 'Clip_Usr.ch'
#include 'inkey.ch'

/*
   Example program to demonstrate the TBrowse UDO class.  This example
   simply browses the 'Titlmstr.dbf' sample database of book titles using
   a Clip/++ UDO instead of a Clipper TBrowse object.
*/

FUNCTION Main
   LOCAL tb, cols, nKey, lExitRequested

   CLEAR SCREEN

   // Register the TBROWSE class for use below.
   ANNOUNCE Class:TBrowse FROM LIBRARY SOFTWARE_PERSPECTIVES

   USE titlmstr                           // Open some database.

   /*
      Create an instance of TBrowse using the NEW() universal constructor
      method instead of the normal Clipper function TBrowseDB().  Notice
      how the browse co-ordinates can still be set in the usual way.
   */
   tb := |< TBrowse:New(5,5,20,65) >|

   cols := ARRAY(2)                       // Create an array of Columns

   /*
      Initialize the columns with column objects.  TBColumn Clipper objects
      could be "wrapped" into Clip/++ UDO objects so that they could be
      inherited, in a similar fashion to the way TBrowse has been in
      z_TBrowse.prg.
   */
   cols[1] := TBColumnNew( "Title", { || titlmstr->Title } )
   cols[2] := TBColumnNew( "Rec. #", { || Recno() } )

   // Add the Columns to the TBrowse object using the AddColumn() method.
   |< tb:AddColumn( cols[1] ) >|
   |< tb:AddColumn( cols[2] ) >|

   // Standard TBrowse loop from here on.
   lExitRequested := .F.
   DO WHILE .NOT. lExitRequested

      DO WHILE .NOT. |<tb:stabilize()>|
      ENDDO

      nKey := INKEY(0)                    // Get a keystroke and process it.
      DO CASE
	 CASE nKey == K_DOWN        ;    |<tb:down()>|
	 CASE nKey == K_UP          ;    |<tb:up()>|
	 CASE nKey == K_PGUP        ;    |<tb:pageup()>|
	 CASE nKey == K_PGDN        ;    |<tb:pagedown()>|
	 CASE nKey == K_CTRL_PGUP   ;    |<tb:gotop()>|
	 CASE nKey == K_CTRL_PGDN   ;    |<tb:gobottom()>|
	 CASE nKey == K_HOME        ;    |<tb:Home()>|
	 CASE nKey == K_END         ;    |<tb:End()>|
	 CASE nKey == K_CTRL_HOME   ;    |<tb:PanHome()>|
	 CASE nKey == K_CTRL_END    ;    |<tb:PanEnd()>|
	 CASE nKey == K_RIGHT       ;    |<tb:Right()>|
	 CASE nKey == K_LEFT        ;    |<tb:Left()>|
	 CASE nKey == K_CTRL_LEFT   ;    |<tb:PanLeft()>|
	 CASE nKey == K_CTRL_RIGHT  ;    |<tb:PanRight()>|
	 CASE nKey == K_ESC         ;    lExitRequested := .T.
      ENDCASE
   ENDDO

RETURN NIL
