/*
   This program demonstrates the use of the Stack class to push and pop
   character images of the screen.  The Stack class is completely generic
   in that it can be used to push and pop any Clipper data type or abstract
   data structure.
*/

#include "Clip_Usr.ch"

FUNCTION Main
   LOCAL s, i

   // Stack class defined in 'z_Stack.prg'
   ANNOUNCE Class:Stack FROM LIBRARY SOFTWARE_PERSPECTIVES

   CLEAR SCREEN
   SET CURSOR OFF

   s := |< Stack:New() >|              // Create an instance of Stack

   DO WHILE INKEY() == 0               // Loop until a key is pressed
      /*
	 Draw several boxes on the screen saving the screen after each one
	 by pushing it on the stack.
      */
      FOR i := 0 TO MAXROW()/2
	 @ i, i TO MAXROW()-i, MAXCOL()-i
	 |< s:Push( SAVESCREEN( 0,0,MAXROW(),MAXCOL() ) ) >|
      NEXT i

      /*
	 Redisplay the screen images saved above on the stack in reverse
	 order by popping them off the stack until the stack is empty.
      */
      DO WHILE |< s:Depth() >| > 0
	 RESTSCREEN( 0, 0, MAXROW(), MAXCOL(), |< s:Pop() >| )
      ENDDO
   ENDDO

   CLEAR SCREEN

RETURN NIL
