/*
   This program demonstrates the use of the Queue class to push and pop
   character images of the screen.  The Queue class is completely generic
   in that it can be used to push and pop any Clipper data type or abstract
   data structure.
*/

#include "Clip_Usr.ch"

FUNCTION Main
   LOCAL q, i

   // Queue class defined in 'z_Queue.prg'
   ANNOUNCE Class:Queue FROM LIBRARY SOFTWARE_PERSPECTIVES

   CLEAR SCREEN
   SET CURSOR OFF

   q := |< Queue:New() >|              // Create an instance of Queue

   /*
      Display a bunch of letters on the screen.
   */
   FOR i := 0 to MAXROW()
      @ i, i * 3 SAY CHR(ASC('A') + i)
   NEXT i

   DO WHILE INKEY() == 0               // Loop until a key is pressed
      /*
	 Save all of the screen lines.
	 The queue will look like this:  1 2 3 ... 25
      */
      FOR i := 0 TO MAXROW()
	 |< q:Push( SAVESCREEN( i, 0, i, MAXCOL() ) ) >|
      NEXT i
      /*
	 Take the first item off the queue and put it back on, at the end.
	 Now the queue will look like this:  2 3 ... 25 1
      */
      |< q:Push( |< q:Pop() >| ) >|

      /*
	 Redisplay the screen images saved above on the queue by
	 popping them off the queue until the queue is empty.
      */
      i := 0
      DO WHILE |< q:Depth() >| > 0
	 RESTSCREEN( i, 0, i, MAXCOL(), |< q:Pop() >| )
	 i := i + 1
      ENDDO
   ENDDO

   CLEAR SCREEN

RETURN NIL
