/*
   Example of Multiple Inheritance with the Clip/++ Extension for Clipper.
*/

// Because we use DEFINE CLASS, we need the Developer's header file.
#include "Clip_Dev.ch"

FUNCTION Main
   LOCAL e1,m1

   /*
      Define a class representing a Person.  Notice that we do not assign
      any default values but instead specify a type for each instance
      variable.
   */
   DEFINE CLASS Person
       EXPORT VARIABLES  FirstName TYPE |"C"|,;
			 LastName  TYPE |"C"|,;
			 Age       TYPE |"N"|
       EXPORT METHOD     ListInfo :=;
	  {|o| QOUT( |<o:FirstName>|, ;
		     |<o:LastName>|, ;
		     |<o:Age>| ) }
   ENDCLASS

   /*
      Define a class representing an Address.
   */
   DEFINE CLASS Address
       EXPORT VARIABLES  Street    TYPE |"C"|,;
			 City      TYPE |"C"|,;
			 ZipCode   TYPE |"C"|
       EXPORT METHOD     ListInfo :=;
	  {|o| QOUT( |<o:Street>|, ;
		     |<o:City>|,   ;
		     |<o:ZipCode>| ) }
   ENDCLASS

   /*
      Define a class representing a Mailing List Entry which consists of
      a 'Person' along with 'Address' information.  This is accomplished
      by inheriting from both the above classes.  This class has only
      one method called 'ListInfo()' which takes precedence over the
      similarly named method in both 'Person' & 'Address'.
   */
   DEFINE CLASS MailingListEntry INHERIT FROM Person, Address
       EXPORT VARIABLES  DirectMail_ID TYPE |"C"|
       EXPORT METHOD     ListInfo := ;
	  {|o| QOUT( |<o:FirstName>|, ;
		     |<o:LastName>|,  ;
		     |<o:Age>|,       ;
		     |<o:Street>|,    ;
		     |<o:City>|,      ;
		     |<o:ZipCode>| ) }
   ENDCLASS

   /*
      Class 'MailingListEntry' Inherits all instance variables from Class
      'Person' and class 'Address', as displayed below.
   */
   m1 := |<MailingListEntry:NEW()>|
   ? "The Instance Variables of the 'MailingListEntry' Class are:"
   AEVAL( GetVariables( m1 ), {| x | QOUT( x ) } )

RETURN NIL
