page 63, 132
Comment ~
 Filename: OS2Start.ASM
           (c) 1993, Paul G. Kurr All Rights Reserved. CIS-70511,3626
           Use and modification of this program is permitted by any person or
           organization provided that the credit for the original work is
           maintained (keep my name in it).
           This program is provided as is without any warranty what-so-ever.
           The author assumes no responsibility for the use of this program.
           Use at your own risk.

 Purpose : Allow Clipper programs acces to OS/2 DOSStartSession API
           Note:  not all DOSStartSession options are being used (see structure).

 Usage   : OS2Start(cCommand, cParms, nProgType)

           Where:     cCommand  == Command line to execute
                      nProgType == Type of execution (see below)
                      nProgType == DOSStartSesstion Program type (see below)

 Returns : Numeric return code from DOS

 Linking : Simply link OS2Start.OBJ into your program an you should be able to 
           launch OS/2, Windoze, and DOS programs from your clipper app.
           Note: This requires OS/2 2.1 or higher.
           This function should be fully overlayable!
           Sorry, I have not tested it for protect mode compatability.

 Actual call:

        AH = 64h
        CX = 636Ch
        BX = 0025h
        DS:SI -> STARTDATA structure (see below)
        INT 21h

Format of STARTDATA structure:                                                 My Comments/defaults

Offset Size    Description
 00h   WORD    length of structure (must be 0018h,001Eh,0020h,0032h,or 003Ch)  We'll use 20h
 02h   WORD    relation of new process to caller (00h independent, 01h child)  Independant
 04h   WORD    fore/background (00h foreground, 01h background)                Background
 06h   WORD    trace options (00h-02h, 00h = no trace)                         00
 08h   DWORD   pointer to ASCIZ program title (max 62 chars) or 0000h:0000h    00
 0Ch   DWORD   pointer to ASCIZ program name (max 128 chars) or 0000h:0000h    cCommand
 10h   DWORD   pointer to ASCIZ program args (max 144 chars) or 0000h:0000h    cParms
 14h   DWORD   "TermQ" (currently reserved, must be 00000000h)                 00
 18h   DWORD   pointer to environment (max 486 bytes) or 0000h:0000h           00
 1Ch   WORD    inheritance (00h or 01h)                                        00
 1Eh   WORD    session type                                                    nProgType
       00h OS/2 session manager determines type (default)
       01h OS/2 full-screen
       02h OS/2 window
       03h PM
       04h VDM full-screen
       07h VDM window                                                          ---------------------------------------
 20h   DWORD   pointer to ASCIZ icon filename (max 128 chars) or 0000h:0000h   These options are not used!
 24h   DWORD   "PgmHandle" (currently reserved, must be 00000000h)
 28h   WORD    "PgmControl"
 2Ah   WORD    initial column
 2Ch   WORD    initial row
 2Eh   WORD    initial width
 30h   WORD    initial height
 32h   WORD    reserved (0)
 34h   DWORD   "ObjectBuffer" (currently reserved, must be 00000000h)
 38h   DWORD   "ObjectBufferLen" (currently reserved, must be 00000000h)
~

PUBLIC          OS2START

EXTRN           __parc:FAR, __parni:FAR, __retni:FAR

DGROUP  GROUP   DATASEG
DATASEG         SEGMENT PUBLIC  'DATA'   ; DATA IS THE REQUIRED CLASS

StartData       dw      20h            ; Structure size
                dw      00h            ; relation independant
                dw      01h            ; background processing
                dw      00h            ; no trace
StartTtlPtr     dw      00h            ; Program title pointer (not implemented)
                dw      00h            ; ... high
StartPgmName    dw      00h            ; This is the program to start (cCommand)
                dw      00h            ; ... high
StartPgmArgs    dw      00h            ; Command line arguments if any
                dw      00h            ; ... high
                dd      00h            ; Termq must be 0
                dd      00h            ; pointer to env (use system env)
                dw      00h            ; inheritance
StartPgmType    dw      00h            ; Program session type

DATASEG         ENDS

CODESEG         SEGMENT 'CODE'           ; CODE IS THE REQUIRED CLASS
                ASSUME  CS:CODESEG,DS:DGROUP

OS2START        PROC    FAR

;* INITIALIZATION PROCEDURE
        PUSH    BP
        MOV     BP,SP

        PUSH    DS
        push    es
        push    si
        push    di
        PUSH    DX
        PUSH    CX

        mov     ax, 1                  ; Get Command 
        push    ax
        call    __parc                 ; pointer returned in DX:AX
        add     sp, 2                  ; reset stack pointer

        Mov     StartPgmName, ax
        Mov     StartPgmName + 2, dx


        mov     ax, 2                  ; Get Parameters
        push    ax
        call    __parc                 ; pointer returned in DX:AX
        add     sp, 2                  ; reset stack pointer

        Mov     StartPgmArgs, ax
        Mov     StartPgmArgs + 2, dx

        mov     ax, 3                  ; Get Program type request
        push    ax
        call    __parni                ; Int returned in AX
        add     sp, 2                  ; reset stack pointer

        Mov     StartPgmType, ax

        push    ss                                    ; verify DS
        pop     ds

        mov     AH, 064h                              ; Setup for OS/2 Start call
        mov     CX, 0636Ch
        mov     BX, 0025h
        LEA     SI, StartData

        Int     021h                                  ; DOS do it!

        push    ss                                    ; verify set up for clipper calls!
        pop     ds

        Push    ax                                    ; Return DOS Return code
        Call    __Retni
        Add     sp, 2
        jmp     Go_Home


;* TERMINATION PROCEDURE

Go_home:

        POP     CX
        POP     DX
        pop     di
        pop     si
        pop     es
        POP     DS
        POP     BP

        RET

OS2START        ENDP

CODESEG         ENDS
                END
